/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonLoader;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityParseSchemaReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityParseSchemaRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityTransBO;
import com.ohaotian.abilityadmin.ability.service.AbilityTransService;
import com.ohaotian.abilityadmin.mapper.AbilityTransMapper;
import com.ohaotian.abilityadmin.model.po.AbilityTransPO;
import com.ohaotian.abilityadmin.util.TransUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class AbilityTransServiceImpl
implements AbilityTransService {
    @Resource
    AbilityTransMapper abilityTransMapper;

    @Override
    public AbilityTransBO qryTrans(Long abilityId) {
        AbilityTransPO abilityTransPO = this.abilityTransMapper.queryLimitOneByAbilityId(abilityId);
        if (abilityTransPO == null) {
            return null;
        }
        AbilityTransBO abilityTransBO = new AbilityTransBO();
        BeanUtils.copyProperties((Object)abilityTransPO, (Object)abilityTransBO);
        return abilityTransBO;
    }

    @Override
    public void saveReqTrans(AbilityTransBO abilityTransBO) {
        AbilityTransPO abilityTransPO = new AbilityTransPO();
        abilityTransPO.setAbilityId(abilityTransBO.getAbilityId());
        this.saveReq(abilityTransBO, abilityTransPO);
        AbilityTransPO abilityTransPO_old = this.abilityTransMapper.queryLimitOneByAbilityId(abilityTransBO.getAbilityId());
        if (abilityTransPO_old == null) {
            this.abilityTransMapper.insertSelective(abilityTransPO);
        } else {
            this.abilityTransMapper.updateByAbilityId(abilityTransPO);
        }
    }

    private void saveReq(AbilityTransBO abilityTransBO, AbilityTransPO abilityTransPO) {
        abilityTransPO.setReqTransType(abilityTransBO.getReqTransType());
        if (abilityTransBO.getReqTransType() == 1) {
            abilityTransPO.setFrontLogic(abilityTransBO.getFrontLogic());
        } else if (abilityTransBO.getReqTransType() == 2) {
            abilityTransPO.setFrontSchema(abilityTransBO.getFrontSchema());
            abilityTransPO.setFrontProtocal(abilityTransBO.getFrontProtocal());
            abilityTransPO.setFrontTemplate(TransUtil.jsonTrans(abilityTransBO.getFrontSchema(), abilityTransBO.getFrontProtocal()));
        } else if (abilityTransBO.getReqTransType() == 3) {
            abilityTransPO.setFrontXmlLogic(abilityTransBO.getFrontXmlLogic());
        } else {
            abilityTransPO.setReqTransType(0);
        }
    }

    @Override
    public void saveRspTrans(AbilityTransBO abilityTransBO) {
        AbilityTransPO abilityTransPO = new AbilityTransPO();
        abilityTransPO.setAbilityId(abilityTransBO.getAbilityId());
        this.saveRsp(abilityTransBO, abilityTransPO);
        AbilityTransPO abilityTransPO_old = this.abilityTransMapper.queryLimitOneByAbilityId(abilityTransBO.getAbilityId());
        if (abilityTransPO_old == null) {
            this.abilityTransMapper.insertSelective(abilityTransPO);
        } else {
            this.abilityTransMapper.updateByAbilityId(abilityTransPO);
        }
    }

    private void saveRsp(AbilityTransBO abilityTransBO, AbilityTransPO abilityTransPO) {
        abilityTransPO.setRspTransType(abilityTransBO.getRspTransType());
        if (abilityTransBO.getRspTransType() == 1) {
            abilityTransPO.setBackLogic(abilityTransBO.getBackLogic());
        } else if (abilityTransBO.getRspTransType() == 2) {
            abilityTransPO.setBackSchema(abilityTransBO.getBackSchema());
            abilityTransPO.setBackProtocal(abilityTransBO.getBackProtocal());
            abilityTransPO.setBackTemplate(TransUtil.jsonTrans(abilityTransBO.getBackSchema(), abilityTransBO.getBackProtocal()));
        } else if (abilityTransBO.getRspTransType() == 3) {
            abilityTransPO.setBackXmlLogic(abilityTransBO.getBackXmlLogic());
        } else {
            abilityTransPO.setRspTransType(0);
        }
    }

    @Override
    public List<OptionGenerRspBO<String, String>> getTransOption() {
        OptionGenerRspBO option = new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)((Object)"json"));
        ArrayList<OptionGenerRspBO<String, String>> list = new ArrayList<OptionGenerRspBO<String, String>>();
        list.add(new OptionGenerRspBO((Serializable)((Object)"JSON"), (Serializable)((Object)"json")));
        list.add(new OptionGenerRspBO((Serializable)((Object)"XML"), (Serializable)((Object)"xml")));
        return list;
    }

    @Override
    public AbilityParseSchemaRspBO parseSchema(AbilityParseSchemaReqBO abilityParseSchemaReqBO) {
        AbilityParseSchemaRspBO abilityParseSchemaRspBO = new AbilityParseSchemaRspBO();
        try {
            JsonNode mainNode = JsonLoader.fromString((String)abilityParseSchemaReqBO.getSchemaText());
            Map map = TransUtil.parseSchema(mainNode, "", "");
            abilityParseSchemaRspBO.setSchemaText(GsonUtil.toJson((Object)map));
            return abilityParseSchemaRspBO;
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u62a5\u6587\u8f6c\u5316Schema\u751f\u6210\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a" + e.getMessage());
        }
    }
}

