/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub.redis;

import com.ohaotian.abilityadmin.config.pubsub.ChannelNaming;
import com.ohaotian.abilityadmin.config.pubsub.properties.PubSubResProperties;
import com.ohaotian.plugin.cache.CacheClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="system.parma", name={"syncWay"}, havingValue="redis")
public class PubSubRedisProvider {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisProvider.class);
    @Autowired
    private PubSubResProperties pubSubResProperties;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${atp.channel.value.size:200}")
    private int channelValueSize;

    public void provideMessage(String channel, String value) {
        if (Boolean.FALSE.equals(channel.startsWith(ChannelNaming.get(this.pubSubResProperties.getAdmin2web()))) && Boolean.FALSE.equals(channel.startsWith(ChannelNaming.get(this.pubSubResProperties.getWeb2admin())))) {
            channel = ChannelNaming.get(this.pubSubResProperties.getAdmin2web()) + "_" + channel;
        }
        try {
            this.cacheClient.publish(channel, value);
            log.info("REDIS \u63a8\u9001\u901a\u9053\uff1achannel={}  value={}", (Object)channel, (Object)value.substring(0, value.length() > this.channelValueSize ? this.channelValueSize : value.length()));
        }
        catch (Exception e) {
            log.error("publish channel error,{} --- {}", (Object)channel, (Object)e.getMessage());
        }
    }
}

