/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.platform.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.constant.TemplateEnum;
import com.ohaotian.abilityadmin.mapper.AbilityTemplateMapper;
import com.ohaotian.abilityadmin.model.po.AbilityTemplatePo;
import com.ohaotian.abilityadmin.platform.model.bo.PlatformTemplateReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateDeleteReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManagePageReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManageReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManageRspBo;
import com.ohaotian.abilityadmin.platform.service.PlatformTemplateService;
import com.ohaotian.atp.base.service.IdGenerator;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PlatformTemplateServiceImpl
implements PlatformTemplateService {
    @Autowired
    private AbilityTemplateMapper abilityTemplateMapper;
    @Autowired
    private IdGenerator idGenerator;

    @Override
    public RspBO<RspPage<TemplateManageRspBo>> selectList(TemplateManagePageReqBo reqBo) {
        if (!ObjectUtils.isEmpty((Object)reqBo.getTemplateType()) && ObjectUtils.isEmpty((Object)((Object)TemplateEnum.getEnumByCode(reqBo.getTemplateType())))) {
            return RspBO.error((String)"\u7c7b\u578b\u5f02\u5e38");
        }
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateType(reqBo.getTemplateType());
        if (StringUtils.isNotBlank((CharSequence)reqBo.getCode())) {
            abilityTemplatePo.setTemplateCode(reqBo.getCode().toUpperCase());
        }
        Page page = PageMethod.startPage((int)reqBo.getPageNo(), (int)reqBo.getPageSize());
        List<AbilityTemplatePo> abilityTemplatePoList = this.abilityTemplateMapper.selectByAll(abilityTemplatePo);
        LinkedList<TemplateManageRspBo> templateManageRspBoList = new LinkedList<TemplateManageRspBo>();
        for (AbilityTemplatePo po : abilityTemplatePoList) {
            TemplateManageRspBo oneBo = (TemplateManageRspBo)BeanMapper.map((Object)po, TemplateManageRspBo.class);
            templateManageRspBoList.add(oneBo);
        }
        RspPage rspPage = new RspPage(Integer.valueOf(reqBo.getPageSize()), Integer.valueOf(reqBo.getPageNo()), templateManageRspBoList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<String> addTemplate(TemplateManageReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)TemplateEnum.getEnumByCode(reqBo.getTemplateType())))) {
            return RspBO.error((String)"\u7c7b\u578b\u5f02\u5e38");
        }
        long id = this.idGenerator.snowflakeId();
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateId(String.valueOf(id));
        abilityTemplatePo.setTemplateType(reqBo.getTemplateType());
        if (StringUtils.isBlank((CharSequence)reqBo.getCode())) {
            abilityTemplatePo.setTemplateCode("DEFAULT");
        } else {
            abilityTemplatePo.setTemplateCode(reqBo.getCode().toUpperCase());
        }
        abilityTemplatePo.setTemplateData(reqBo.getTemplateData());
        this.abilityTemplateMapper.insert(abilityTemplatePo);
        return RspBO.success((Object)"\u6dfb\u52a0\u6210\u529f");
    }

    @Override
    public RspBO<Object> getDetail(TemplateManageReqBo reqBo) {
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateId(reqBo.getTemplateId());
        abilityTemplatePo = this.abilityTemplateMapper.selectOneByAll(abilityTemplatePo);
        if (ObjectUtils.isEmpty((Object)abilityTemplatePo)) {
            return RspBO.error((String)"\u83b7\u53d6\u5931\u8d25");
        }
        return RspBO.success((Object)abilityTemplatePo);
    }

    @Override
    public RspBO<String> modifyTemplate(TemplateManageReqBo reqBo) {
        if (ObjectUtils.isEmpty((Object)((Object)TemplateEnum.getEnumByCode(reqBo.getTemplateType())))) {
            return RspBO.error((String)"\u7c7b\u578b\u5f02\u5e38");
        }
        this.abilityTemplateMapper.updateTemplateDataByTemplateId(reqBo.getTemplateData(), reqBo.getTemplateId());
        return RspBO.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public RspBO<String> deleteTemplate(TemplateDeleteReqBo reqBo) {
        int num = this.abilityTemplateMapper.deleteByTemplateId(reqBo.getTemplateIds());
        return RspBO.success((Object)("\u6210\u529f\u5220\u9664\uff1a" + num));
    }

    @Override
    public RspBO<Map<String, Object>> getAbilityTemplate(PlatformTemplateReqBo reqBo) {
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateType(TemplateEnum.ABILITY.getCode());
        if (StringUtils.isBlank((CharSequence)reqBo.getTemplate())) {
            reqBo.setTemplate("default");
        }
        abilityTemplatePo.setTemplateCode(reqBo.getTemplate().toUpperCase());
        String regionResStr = this.getTemplate(abilityTemplatePo);
        if (ObjectUtils.nullSafeEquals((Object)"{}", (Object)regionResStr)) {
            abilityTemplatePo.setTemplateCode("DEFAULT");
            regionResStr = this.getTemplate(abilityTemplatePo);
        }
        Map rsp = (Map)JSON.parseObject((String)regionResStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        return RspBO.success((Object)rsp);
    }

    @Override
    public RspBO<Map<String, Object>> getManageTemplate() {
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateType(TemplateEnum.MANAGE.getCode());
        abilityTemplatePo.setTemplateCode("DEFAULT");
        String regionResStr = this.getTemplate(abilityTemplatePo);
        Map rsp = (Map)JSON.parseObject((String)regionResStr, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        return RspBO.success((Object)rsp);
    }

    @Override
    public String getTemplate(AbilityTemplatePo abilityTemplatePo) {
        if (ObjectUtils.isEmpty((Object)(abilityTemplatePo = this.abilityTemplateMapper.selectOneByAll(abilityTemplatePo)))) {
            return "{}";
        }
        return abilityTemplatePo.getTemplateData();
    }
}

