/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util.jsons2xsd;

import com.ohaotian.abilityadmin.util.jsons2xsd.Assert;
import com.ohaotian.abilityadmin.util.jsons2xsd.InvalidXsdSchema;
import com.sun.xml.xsom.parser.XSOMParser;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtil {
    private static final Logger log = LoggerFactory.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    public static String asXmlString(Node node) throws IOException {
        DOMSource source = new DOMSource(node);
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerException exc) {
            throw new IOException(exc.getMessage(), exc);
        }
    }

    public static Document newDocument() {
        return XmlUtil.getBuilder().newDocument();
    }

    public static DocumentBuilder getBuilder() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Element createXsdElement(Node element, String name) {
        Assert.notNull(element, "element should never be null");
        Document doc = element.getOwnerDocument() != null ? element.getOwnerDocument() : (Document)element;
        Element retVal = doc.createElement(name);
        element.appendChild(retVal);
        return retVal;
    }

    public static void validateSchema(Document doc) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        XSOMParser parser = new XSOMParser(factory);
        EH errorHandler = new EH();
        parser.setErrorHandler((ErrorHandler)errorHandler);
        try {
            log.info("\u751f\u6210xsd\uff1a" + XmlUtil.asXmlString(doc));
            parser.parse((Reader)new StringReader(XmlUtil.asXmlString(doc)));
        }
        catch (IOException | SAXException exc) {
            throw new IllegalArgumentException(exc);
        }
        List<SAXParseException> errors = errorHandler.getErrors();
        if (!errors.isEmpty()) {
            SAXParseException exc = errors.get(0);
            throw new InvalidXsdSchema(exc.getMessage(), exc);
        }
    }

    private static class EH
    implements ErrorHandler {
        private final List<SAXParseException> warnings = new LinkedList<SAXParseException>();
        private final List<SAXParseException> errors = new LinkedList<SAXParseException>();

        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            this.errors.add(x);
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            this.errors.add(x);
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            this.warnings.add(x);
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        public List<SAXParseException> getWarnings() {
            return this.warnings;
        }
    }
}

