/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.controller;

import com.ohaotian.abilityadmin.ability.model.bo.AbilityParseSchemaReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityParseSchemaRspBO;
import com.ohaotian.abilityadmin.ability.model.bo.AbilityTransBO;
import com.ohaotian.abilityadmin.ability.service.AbilityTransService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.List;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/abilityTrans"})
public class AbilityTransController {
    private static Logger log = LogManager.getLogger(AbilityTransController.class);
    @Resource
    private AbilityTransService abilityTransService;

    @PostMapping(value={"/qryTrans"})
    @BusiResponseBody
    public RspBO qryTrans(@RequestBody AbilityTransBO abilityTransBO) {
        if (StringUtils.isEmpty((Object)abilityTransBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u80fd\u529b");
        }
        AbilityTransBO transBO = this.abilityTransService.qryTrans(abilityTransBO.getAbilityId());
        RspBO rspBO = RspBO.success((Object)transBO);
        return rspBO;
    }

    @PostMapping(value={"/saveReqTrans"})
    @BusiResponseBody
    public RspBO saveReqTrans(@RequestBody AbilityTransBO abilityTransBO) {
        if (StringUtils.isEmpty((Object)abilityTransBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u80fd\u529b");
        }
        if (StringUtils.isEmpty((Object)abilityTransBO.getReqTransType())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587\u8f6c\u5316\u7c7b\u578b");
        }
        if (abilityTransBO.getReqTransType() == 1 && StringUtils.isEmpty((Object)abilityTransBO.getFrontLogic().trim())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        if (abilityTransBO.getReqTransType() == 2 && StringUtils.isEmpty((Object)abilityTransBO.getFrontSchema()) && StringUtils.isEmpty((Object)abilityTransBO.getFrontProtocal())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        if (abilityTransBO.getReqTransType() == 3 && StringUtils.isEmpty((Object)abilityTransBO.getFrontXmlLogic().trim())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        this.abilityTransService.saveReqTrans(abilityTransBO);
        RspBO rspBO = RspBO.success((Object)true);
        return rspBO;
    }

    @PostMapping(value={"/saveRspTrans"})
    @BusiResponseBody
    public RspBO saveRspTrans(@RequestBody AbilityTransBO abilityTransBO) {
        if (StringUtils.isEmpty((Object)abilityTransBO.getAbilityId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u80fd\u529b");
        }
        if (StringUtils.isEmpty((Object)abilityTransBO.getRspTransType())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u54cd\u5e94\u62a5\u6587\u8f6c\u5316\u7c7b\u578b");
        }
        if (abilityTransBO.getRspTransType() == 1 && StringUtils.isEmpty((Object)abilityTransBO.getBackLogic().trim())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u54cd\u5e94\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        if (abilityTransBO.getRspTransType() == 2 && StringUtils.isEmpty((Object)abilityTransBO.getBackSchema()) && StringUtils.isEmpty((Object)abilityTransBO.getBackProtocal())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8bf7\u6c42\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        if (abilityTransBO.getRspTransType() == 3 && StringUtils.isEmpty((Object)abilityTransBO.getBackXmlLogic().trim())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u54cd\u5e94\u62a5\u6587\u8f6c\u5316\u811a\u672c");
        }
        this.abilityTransService.saveRspTrans(abilityTransBO);
        RspBO rspBO = RspBO.success((Object)true);
        return rspBO;
    }

    @PostMapping(value={"/getTransOption"})
    @BusiResponseBody
    public RspBO getTransOption() {
        List<OptionGenerRspBO<String, String>> transOption = this.abilityTransService.getTransOption();
        RspBO rspBO = RspBO.success(transOption);
        return rspBO;
    }

    @PostMapping(value={"/parseSchema"})
    @BusiResponseBody
    public RspBO parseSchema(@RequestBody AbilityParseSchemaReqBO abilityParseSchemaReqBO) {
        if (abilityParseSchemaReqBO == null || StringUtils.isEmpty((Object)abilityParseSchemaReqBO.getSchemaText())) {
            throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u8f6c\u5316schema\u6587\u4ef6");
        }
        AbilityParseSchemaRspBO abilityParseSchemaRspBO = this.abilityTransService.parseSchema(abilityParseSchemaReqBO);
        RspBO rspBO = RspBO.success((Object)abilityParseSchemaRspBO);
        return rspBO;
    }
}

