/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.ability.model.bo.AbilitySubscribeDeployBO;
import com.ohaotian.abilityadmin.ability.model.bo.DelAbilitySubscribeReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilitySubscribeReqBO;
import com.ohaotian.abilityadmin.ability.model.bo.QryAbilitySubscribeRspBO;
import com.ohaotian.abilityadmin.ability.service.AbilitySubscribeService;
import com.ohaotian.abilityadmin.app.model.bo.AppSubscribeDeployBO;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AbilityMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppSubscribeDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RateLimiterSubscribeMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AbilityPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppSubscribeDeployPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RateLimiterSubscribePO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilitySubscribeServiceImpl
implements AbilitySubscribeService {
    private static final Logger log = LogManager.getLogger(AbilitySubscribeServiceImpl.class);
    @Resource
    private AppSubscribeDeployMapper appSubscribeDeployMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Resource
    private AbilityMapper abilityMapper;
    @Resource
    private AppMapper appMapper;
    @Resource
    private ClusterMapper clusterMapper;
    @Resource
    private RateLimiterSubscribeMapper rateLimiterSubscribeMapper;
    @Resource
    private AuthorityService authorityService;

    @Override
    public RspBO<RspPage<QryAbilitySubscribeRspBO>> qryAbilitySubscribeListPageByCond(QryAbilitySubscribeReqBO qryAbilitySubscribeReqBO) throws ZTBusinessException {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        qryAbilitySubscribeReqBO.setHirerId(tenantId);
        log.debug("AbilitySubscribeServiceImpl.qryAbilitySubscribeListPageByCond:{}", (Object)qryAbilitySubscribeReqBO);
        if (StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAbilityId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAppName())) {
            qryAbilitySubscribeReqBO.setAppName("%" + qryAbilitySubscribeReqBO.getAppName() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAppCode())) {
            qryAbilitySubscribeReqBO.setAppCode("%" + qryAbilitySubscribeReqBO.getAppCode() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryAbilitySubscribeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getSortOrder())) {
                order.append(" ").append(qryAbilitySubscribeReqBO.getSortOrder());
            }
        }
        int pageNo = qryAbilitySubscribeReqBO.getPageNo();
        int pageSize = qryAbilitySubscribeReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryAbilitySubscribeRspBO> qryAbilitySubscribeRspBOList = this.appSubscribeDeployMapper.queryAbilitySubscribePageByCond(qryAbilitySubscribeReqBO);
        qryAbilitySubscribeRspBOList.stream().map(bo -> {
            ClusterPO clusterPO = this.clusterMapper.queryByClusterId(bo.getClusterId());
            if (clusterPO != null) {
                bo.setClusterName(clusterPO.getClusterName());
            }
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), qryAbilitySubscribeRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<RspPage<QryAbilitySubscribeRspBO>> qryAbilityUnSubscribeListPageByCond(QryAbilitySubscribeReqBO qryAbilitySubscribeReqBO) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        qryAbilitySubscribeReqBO.setHirerId(tenantId);
        log.debug("AbilitySubscribeServiceImpl.qryAbilityUnSubscribeListPageByCond:{}", (Object)qryAbilitySubscribeReqBO);
        if (StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAbilityId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAppName())) {
            qryAbilitySubscribeReqBO.setAppName("%" + qryAbilitySubscribeReqBO.getAppName() + "%");
        }
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getAppCode())) {
            qryAbilitySubscribeReqBO.setAppCode("%" + qryAbilitySubscribeReqBO.getAppCode() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)qryAbilitySubscribeReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)qryAbilitySubscribeReqBO.getSortOrder())) {
                order.append(" ").append(qryAbilitySubscribeReqBO.getSortOrder());
            }
        }
        int pageNo = qryAbilitySubscribeReqBO.getPageNo();
        int pageSize = qryAbilitySubscribeReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<QryAbilitySubscribeRspBO> qryAbilitySubscribeRspBOList = this.appSubscribeDeployMapper.qryAbilityUnSubscribeListPageByCond(qryAbilitySubscribeReqBO);
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), qryAbilitySubscribeRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> deleteAbilitySubscribe(List<AppSubscribeDeployBO> list) throws ZTBusinessException {
        log.debug("AbilitySubscribeServiceImpl.deleteAbilitySubscribe:{}", list);
        list.forEach(bo -> ValidBatchUtils.isNotEmpty((Object)bo, (String[])new String[]{"subscribeDeployId", "abilityAppId"}));
        try {
            for (AppSubscribeDeployBO appSubscribeDeployBO : list) {
                AppSubscribeDeployPO appSubscribeDeployPO = new AppSubscribeDeployPO();
                appSubscribeDeployPO.setAbilityAppId(appSubscribeDeployBO.getAbilityAppId());
                List<AppSubscribeDeployPO> appSubscribeDeployPOList = this.appSubscribeDeployMapper.queryByCond(appSubscribeDeployPO);
                if (!CollectionUtils.isEmpty(appSubscribeDeployPOList) && appSubscribeDeployPOList.size() > 1) {
                    this.appSubscribeDeployMapper.deleteAppSubscribeDeployBySubscribeDeployId(appSubscribeDeployBO.getSubscribeDeployId());
                } else {
                    this.appSubscribeDeployMapper.deleteAppSubscribeDeployByRegionId(appSubscribeDeployBO.getAbilityAppId());
                    this.abilityAppMapper.deleteAbilityAppByAbilityAppId(appSubscribeDeployBO.getAbilityAppId());
                }
                this.rateLimiterSubscribeMapper.deleteRateLimiterSubscribeBySubscribeDeployId(appSubscribeDeployBO.getSubscribeDeployId());
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AbilitySubscribeServiceImpl.deleteAbilitySubscribe:{}", (Object)CodeMsg.ABILITY_UNSUBSCRIBE_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.ABILITY_UNSUBSCRIBE_ERROR.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> addAbilitySubscribe(List<AbilitySubscribeDeployBO> list) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        log.debug("AbilitySubscribeServiceImpl.addAbilitySubscribe:{}", list);
        list.forEach(bo -> ValidBatchUtils.isNotEmpty((Object)bo, (String[])new String[]{"abilityId", "appId", "capacity", "dailyCapacity", "rate", "singleMaxRate", "singleMaxCount", "singleDailyMaxCount"}));
        for (AbilitySubscribeDeployBO abilitySubscribeDeployBO : list) {
            if (!CollectionUtils.isEmpty(abilitySubscribeDeployBO.getClusterReqBOList())) continue;
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        try {
            for (AbilitySubscribeDeployBO abilitySubscribeDeployBO : list) {
                RateLimiterSubscribePO rateLimiterSubscribePO;
                AppSubscribeDeployPO appSubscribeDeployPO;
                AbilityPO abilityPO = this.abilityMapper.queryByAbilityId(abilitySubscribeDeployBO.getAbilityId());
                AppPO appPO = this.appMapper.queryByAppId(abilitySubscribeDeployBO.getAppId());
                AbilityAppPO abilityAppPO = (AbilityAppPO)BeanMapper.map((Object)abilityPO, AbilityAppPO.class);
                abilityAppPO.setAppCode(appPO.getAppCode());
                abilityAppPO.setRelationType(Constants.RelationType.SUBSCRIBE);
                List<AbilityAppPO> abilityAppPOList = this.abilityAppMapper.queryByCond(abilityAppPO);
                Date currentDate = new Date();
                if (!CollectionUtils.isEmpty(abilityAppPOList) && abilityAppPOList.size() > 0) {
                    for (Long clusterId : abilitySubscribeDeployBO.getClusterReqBOList()) {
                        DelAbilitySubscribeReqBO delAbilitySubscribeReqBO = new DelAbilitySubscribeReqBO();
                        delAbilitySubscribeReqBO.setAbilityAppId(abilityAppPOList.get(0).getAbilityAppId());
                        delAbilitySubscribeReqBO.setClusterId(clusterId);
                        this.appSubscribeDeployMapper.deleteAppSubscribeDeployByCond(delAbilitySubscribeReqBO);
                        appSubscribeDeployPO = new AppSubscribeDeployPO();
                        appSubscribeDeployPO.setClusterId(clusterId);
                        appSubscribeDeployPO.setDeployUserId(userId);
                        appSubscribeDeployPO.setDeployTime(currentDate);
                        appSubscribeDeployPO.setAbilityAppId(abilityAppPOList.get(0).getAbilityAppId());
                        this.appSubscribeDeployMapper.insertSelective(appSubscribeDeployPO);
                        rateLimiterSubscribePO = new RateLimiterSubscribePO();
                        rateLimiterSubscribePO.setCapacity(abilitySubscribeDeployBO.getCapacity());
                        rateLimiterSubscribePO.setDailyCapacity(abilitySubscribeDeployBO.getDailyCapacity());
                        rateLimiterSubscribePO.setRate(abilitySubscribeDeployBO.getRate());
                        rateLimiterSubscribePO.setSingleMaxRate(abilitySubscribeDeployBO.getSingleMaxRate());
                        rateLimiterSubscribePO.setSingleMaxCount(abilitySubscribeDeployBO.getSingleMaxCount());
                        rateLimiterSubscribePO.setSingleDailyMaxCount(abilitySubscribeDeployBO.getSingleDailyMaxCount());
                        rateLimiterSubscribePO.setSubscribeDeployId(appSubscribeDeployPO.getSubscribeDeployId());
                        rateLimiterSubscribePO.setCreateTime(currentDate);
                        rateLimiterSubscribePO.setCreateUserId(userId);
                        this.rateLimiterSubscribeMapper.insertSelective(rateLimiterSubscribePO);
                    }
                    continue;
                }
                this.abilityAppMapper.insertSelective(abilityAppPO);
                Long abilityAppId = abilityAppPO.getAbilityAppId();
                for (Long clusterId : abilitySubscribeDeployBO.getClusterReqBOList()) {
                    appSubscribeDeployPO = new AppSubscribeDeployPO();
                    appSubscribeDeployPO.setClusterId(clusterId);
                    appSubscribeDeployPO.setDeployUserId(userId);
                    appSubscribeDeployPO.setDeployTime(currentDate);
                    appSubscribeDeployPO.setAbilityAppId(abilityAppId);
                    this.appSubscribeDeployMapper.insertSelective(appSubscribeDeployPO);
                    rateLimiterSubscribePO = new RateLimiterSubscribePO();
                    rateLimiterSubscribePO.setCapacity(abilitySubscribeDeployBO.getCapacity());
                    rateLimiterSubscribePO.setDailyCapacity(abilitySubscribeDeployBO.getDailyCapacity());
                    rateLimiterSubscribePO.setRate(abilitySubscribeDeployBO.getRate());
                    rateLimiterSubscribePO.setSingleMaxRate(abilitySubscribeDeployBO.getSingleMaxRate());
                    rateLimiterSubscribePO.setSingleMaxCount(abilitySubscribeDeployBO.getSingleMaxCount());
                    rateLimiterSubscribePO.setSingleDailyMaxCount(abilitySubscribeDeployBO.getSingleDailyMaxCount());
                    rateLimiterSubscribePO.setSubscribeDeployId(appSubscribeDeployPO.getSubscribeDeployId());
                    rateLimiterSubscribePO.setCreateTime(currentDate);
                    rateLimiterSubscribePO.setCreateUserId(userId);
                    this.rateLimiterSubscribeMapper.insertSelective(rateLimiterSubscribePO);
                }
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AbilitySubscribeServiceImpl.addAbilitySubscribe:{}", (Object)CodeMsg.ABILITY_SUBSCRIBE_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.ABILITY_SUBSCRIBE_ERROR.getMessage());
        }
    }
}

