/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.init;

import com.ohaotian.abilityadmin.config.cluster.InitClusterMonitor;
import com.ohaotian.abilityadmin.mapper.SystemCodeTypeMapper;
import com.ohaotian.abilityadmin.model.po.SystemCodeTypePO;
import com.ohaotian.abilityadmin.model.po.SystemCodeValuePO;
import com.ohaotian.abilityadmin.util.DynamicCompilerUtil;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeType;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.util.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InitConfig
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(InitConfig.class);
    @Resource
    private SystemCodeTypeMapper systemCodeTypeMapper;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    ServerProperties serverProperties;
    @Autowired
    InitClusterMonitor initClusterMonitor;

    public void run(String ... args) throws Exception {
        this.start();
    }

    private void start() throws Exception {
        this.initSystemCode();
        this.initProject();
        this.initClusterMonitor.run();
        log.info("\u521d\u59cb\u5316\u64cd\u4f5c\u5b8c\u6210");
    }

    private void initSystemCode() {
        log.info("\u542f\u52a8\u9879\u76ee\u4ece\u914d\u7f6e\u5e93\u8bfb\u53d6\u7cfb\u7edf\u53c2\u6570\u5230jvm");
        List<SystemCodeTypePO> systemCodeTypePOList = this.systemCodeTypeMapper.findAllSystemCodeTypeWithSystemCodeValue();
        for (SystemCodeTypePO systemCodeTypePO : systemCodeTypePOList) {
            SystemCodeType systemCodeType = (SystemCodeType)BeanMapper.map((Object)systemCodeTypePO, SystemCodeType.class);
            HashMap<String, SystemCodeValue> stringSystemCodeValueMap = new HashMap<String, SystemCodeValue>();
            List<SystemCodeValuePO> systemCodeValueList = systemCodeTypePO.getSystemCodeValuePOList();
            for (SystemCodeValuePO systemCodeValuePO : systemCodeValueList) {
                SystemCodeValue systemCodeValue = (SystemCodeValue)BeanMapper.map((Object)systemCodeValuePO, SystemCodeValue.class);
                stringSystemCodeValueMap.put(systemCodeValue.getDicCode(), systemCodeValue);
            }
            systemCodeType.setSystemCodeValueMap(stringSystemCodeValueMap);
            SystemCodeMap.getSystemCodeMap().put(systemCodeType.getTypeCode(), systemCodeType);
        }
        log.info("\u8bfb\u53d6\u7cfb\u7edf\u53c2\u6570\u5230jvm\u5b8c\u6210");
    }

    private void initProject() throws Exception {
        String systemPath = Constants.SYSTEM_PATH;
        log.info("\u7cfb\u7edf\u8fd0\u884c\u76ee\u5f55:" + systemPath);
        File fileService = new File(Constants.projectPath.ABILITY_SERVICE_PATH);
        File fileJava = new File(Constants.projectPath.ABILITY_JAVA_PATH);
        File fileClass = new File(Constants.projectPath.ABILITY_CLASS_PATH);
        File fileJar = new File(Constants.projectPath.ABILITY_JAR_PATH);
        File filexsd = new File(Constants.projectPath.ABILITY_XSD_PATH);
        File filejson = new File(Constants.projectPath.ABILITY_JSON_PATH);
        File filelib = new File(Constants.projectPath.ABILITY_LIB_PATH);
        File filews = new File(Constants.projectPath.ABILITY_WS_PATH);
        if (!fileService.exists()) {
            fileService.mkdir();
            log.info("\u521b\u5efa\u670d\u52a1\u8def\u5f84\uff1a{}" + Constants.projectPath.ABILITY_SERVICE_PATH);
        }
        if (!fileJava.exists()) {
            fileJava.mkdir();
            log.info("\u521b\u5efajava\u8def\u5f84\uff1a{}" + Constants.projectPath.ABILITY_JAVA_PATH);
        }
        if (!fileClass.exists()) {
            fileClass.mkdir();
            log.info("\u521b\u5efajavaclass\u8def\u5f84\uff1a{}" + Constants.projectPath.ABILITY_CLASS_PATH);
        }
        if (!fileJar.exists()) {
            fileJar.mkdir();
            log.info("\u521b\u5efajar\u8def\u5f84{}\uff1a" + Constants.projectPath.ABILITY_JAR_PATH);
        }
        if (!filexsd.exists()) {
            filexsd.mkdir();
            log.info("\u521b\u5efaxsd\u8def\u5f84{}\uff1a" + Constants.projectPath.ABILITY_XSD_PATH);
        }
        if (!filejson.exists()) {
            filejson.mkdir();
            log.info("\u521b\u5efajson\u8def\u5f84{}\uff1a" + Constants.projectPath.ABILITY_JSON_PATH);
        }
        if (!filews.exists()) {
            filews.mkdir();
            log.info("\u521b\u5efaws\u8def\u5f84{}\uff1a" + Constants.projectPath.ABILITY_WS_PATH);
        }
        FileUtil.delAllFile((String)Constants.projectPath.ABILITY_LIB_PATH);
        if (!filelib.exists()) {
            filelib.mkdir();
            log.info("\u521b\u5efalib\u8def\u5f84{}\uff1a" + Constants.projectPath.ABILITY_LIB_PATH);
        }
        DynamicCompilerUtil.putBootJar(Constants.projectPath.ABILITY_LIB_PATH);
    }
}

