/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ohaotian.abilityadmin.ability.model.bo.abilitydeploy.DeployCallBackBO;
import com.ohaotian.abilityadmin.config.pubsub.ChannelNaming;
import com.ohaotian.abilityadmin.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.NodeMapper;
import com.ohaotian.abilityadmin.mapper.PluginMapper;
import com.ohaotian.abilityadmin.model.po.AbilityProvideMqCacheDataPo;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.NodePO;
import com.ohaotian.abilityadmin.model.po.PluginPO;
import com.ohaotian.abilityadmin.pushClient.abilityMqBase.AbilityMessagePoolService;
import com.ohaotian.abilityadmin.pushClient.kafka.model.bo.KafkaSubRspBo;
import com.ohaotian.abilityadmin.system.model.bo.SyncReqBO;
import com.ohaotian.abilityadmin.system.service.SyncDataService;
import com.ohaotian.abilityadmin.system.service.SysService;
import com.ohaotian.atp.base.model.TokenRefreshBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.config.systemcode.SystemParam;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.ModifyStatusBO;
import com.ohaotian.portalcommon.model.bo.NodeDataBO;
import com.ohaotian.portalcommon.model.bo.RedisSyncDataBo;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import com.ohaotian.portalcommon.model.bo.SyncServiceBO;
import com.ohaotian.portalcommon.service.PluginService;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class PubSubMsgHandler {
    private static final Logger log = LoggerFactory.getLogger(PubSubMsgHandler.class);
    @Autowired
    CacheClient cacheClient;
    @Resource
    NodeMapper nodeMapper;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    SystemParam systemParam;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    SyncDataService syncDataService;
    @Resource
    PubSubRes pubSubRes;
    @Resource
    SysService sysService;
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Autowired
    private PluginMapper pluginMapper;
    @Value(value="${atp.web.heartbeat.expired:60}")
    private int webNodesMapExpired;
    @Value(value="${redis.hashTags:false}")
    private Boolean hashTags;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Resource
    PluginService pluginService;
    @Autowired
    private AbilityMessagePoolService abilityMessagePoolService;

    public void redisCoreNodeDeal(String message) {
        if (!this.adminClusterConfig.isMaster()) {
            log.warn("\u975e\u4e3b\u8282\u70b9\u4e0d\u8fdb\u884c\u6570\u636e\u5e93\u64cd\u4f5c\uff01");
            return;
        }
        RedisSyncDataBo redisSyncDataBo = (RedisSyncDataBo)GsonUtil.fromJson((String)message, RedisSyncDataBo.class);
        if (redisSyncDataBo.getCode().equals("INIT_NODE")) {
            try {
                log.info("web\u8282\u70b9\u521d\u59cb\u5316...");
                log.info("web\u8282\u70b9\u521d\u59cb\u5316\u5b8c\u6210");
            }
            catch (Exception e) {
                log.error("web\u8282\u70b9\u521d\u59cb\u5316\u5931\u8d25\uff01");
                NodePO nodePO = new NodePO();
                BeanUtils.copyProperties((Object)redisSyncDataBo.getNodeBo(), (Object)nodePO);
                this.notifyWebCoreNodeAll(nodePO, "web\u8282\u70b9\u521d\u59cb\u5316\u5931\u8d25");
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (redisSyncDataBo.getCode().equals("PROCESSED")) {
            this.webNodeProcessedDeal(redisSyncDataBo);
        } else if (redisSyncDataBo.getCode().equals("PUBSUB")) {
            this.webAccurateDataPush(redisSyncDataBo);
        } else if (redisSyncDataBo.getCode().equals("DEPLOY_RETURN")) {
            this.webDeployReturnDeal(redisSyncDataBo);
        } else if (redisSyncDataBo.getCode().equals("HEARTBEAT")) {
            this.initClusterNodeDeal(redisSyncDataBo);
        } else if (redisSyncDataBo.getCode().equals("TOKEN_REFRESH")) {
            this.tokenRefreshDeal(redisSyncDataBo);
        } else if (redisSyncDataBo.getCode().equals("CONGESTION")) {
            try {
                log.error("\u6b64\u6d88\u606f\u5904\u7406\u6709\u95ee\u9898\uff1a{}", (Object)redisSyncDataBo);
            }
            catch (Exception e) {
                log.error("\u8282\u70b9\u8bbf\u95ee\u5f02\u5e38\uff1a{}" + redisSyncDataBo.getNodeIp() + ":" + redisSyncDataBo.getPort());
                log.error(e.getMessage(), (Throwable)e);
            }
        } else if (redisSyncDataBo.getCode().equals("MQ_OPERATION_QUEUE")) {
            this.mqOperationQueue(redisSyncDataBo);
        }
    }

    private void mqOperationQueue(RedisSyncDataBo redisSyncDataBo) {
        JSONObject extData = redisSyncDataBo.getExtData();
        KafkaSubRspBo kafkaSubRspBo = (KafkaSubRspBo)extData.getObject("kafkaSubRspBo", KafkaSubRspBo.class);
        AbilityProvideMqCacheDataPo mqCacheDataPo = (AbilityProvideMqCacheDataPo)extData.getObject("mqCacheDataPo", AbilityProvideMqCacheDataPo.class);
        this.abilityMessagePoolService.pushDataQueue(kafkaSubRspBo, mqCacheDataPo);
    }

    private void tokenRefreshDeal(RedisSyncDataBo redisSyncDataBo) {
        try {
            TokenRefreshBo tokenRefreshBo = redisSyncDataBo.getTokenRefreshBo();
            for (Long pluginId : tokenRefreshBo.getPluginIds()) {
                PluginPO pluginPo = this.pluginMapper.queryByPluginId(pluginId);
                String pluginType = pluginPo.getPluginType();
                log.info("\u63d2\u4ef6\u8865\u507f\u5237\u65b0\u9274\u6743 pluginId:{} pluginName:{} data:{}", new Object[]{pluginId, pluginPo.getPluginName(), tokenRefreshBo});
                RspBO mapRspBO = this.pluginService.handleTokenRefresh((Object)tokenRefreshBo, pluginType, ExtensionPointPositionEnum.ABILITY_POSITION.getCode());
                log.info(GsonUtil.toJson((Object)mapRspBO));
            }
        }
        catch (Exception e) {
            log.error("token\u8865\u507f\u5237\u65b0\u5f02\u5e38\uff01");
        }
    }

    private void webDeployReturnDeal(RedisSyncDataBo redisSyncDataBo) {
        DeployCallBackBO callBackBO = (DeployCallBackBO)GsonUtil.fromJson((String)redisSyncDataBo.getMsg(), DeployCallBackBO.class);
        log.info("\u80fd\u529b\u90e8\u7f72\uff1a{}({}) {}({}) -> {}:{} -> {}", new Object[]{callBackBO.getAbilityEname(), callBackBO.getAbilityVersion(), redisSyncDataBo.getClusterEname(), redisSyncDataBo.getClusterId(), redisSyncDataBo.getNodeIp(), redisSyncDataBo.getPort(), redisSyncDataBo.isSuccess()});
        String statusDescriptionString = this.abilityProvideDeployMapper.queryDeployStatusByTraceId(callBackBO);
        try {
            if (callBackBO.getDeployStatus().equals(Constants.AbilityDeployStatus.SUCCESS)) {
                JSONObject jsonObject = JSONObject.parseObject((String)statusDescriptionString);
                ArrayList<String> success = new ArrayList<String>(GsonUtil.fromList((String)jsonObject.get((Object)"success").toString(), String[].class));
                ArrayList failed = new ArrayList(GsonUtil.fromList((String)jsonObject.get((Object)"failed").toString(), String[].class));
                boolean remove = Boolean.FALSE;
                Iterator iterator = failed.iterator();
                while (iterator.hasNext()) {
                    String name = (String)iterator.next();
                    if (!name.equals(redisSyncDataBo.getName())) continue;
                    iterator.remove();
                    remove = Boolean.TRUE;
                }
                if (Boolean.TRUE.equals(remove)) {
                    success.add(redisSyncDataBo.getName());
                }
                if (failed.size() == 0 && success.size() == Integer.parseInt(jsonObject.get((Object)"count").toString())) {
                    callBackBO.setDeployStatus(Constants.AbilityDeployStatus.SUCCESS);
                }
                jsonObject.put("success", success);
                jsonObject.put("failed", failed);
                statusDescriptionString = jsonObject.toString();
            }
            callBackBO.setStatusDescription(statusDescriptionString);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6web\u90e8\u7f72\u8fd4\u56de\u4fe1\u606f\u5931\u8d25{}", (Throwable)e);
            callBackBO.setStatusDescription(statusDescriptionString);
            callBackBO.setDeployStatus(Constants.AbilityDeployStatus.FAIL);
        }
        this.abilityProvideDeployMapper.updateDeployStatusByTraceId(callBackBO);
    }

    private void webAccurateDataPush(RedisSyncDataBo redisSyncDataReqBo) {
        SyncReqBO syncReqBO = this.syncReqPack(Collections.singletonList(redisSyncDataReqBo.getClusterId()));
        NodeDataBO nodeDataBO = this.sysService.syncH2(syncReqBO, "\u80fd\u529b\u53d1\u5e03\u83b7\u53d6\u5168\u91cf\u66f4\u65b0\u5185\u5bb9\uff01", null);
        List syncDataClusterIdList = nodeDataBO.getClusterIds();
        RedisSyncDataBo redisSyncDataRspBo = new RedisSyncDataBo();
        redisSyncDataRspBo.setCode("SYNC_DATA");
        this.syncDataAcquisitionAndPackaging(nodeDataBO, syncDataClusterIdList, redisSyncDataRspBo);
        this.pubSubRes.getClient().publish(ChannelNaming.get(redisSyncDataReqBo.getName()), GsonUtil.toJson((Object)redisSyncDataRspBo));
    }

    private void syncDataAcquisitionAndPackaging(NodeDataBO nodeDataBO, List<Long> syncDataClusterIdList, RedisSyncDataBo redisSyncDataRspBo) {
        NodeDataBO.SyncBO rspCodeSyncBO = new NodeDataBO.SyncBO(FisrtLevelEnum.EXCEPTION.getCode(), SecondLevelEnum.EXCEPTION.getCode(), null);
        nodeDataBO.getSyncBOs().add(rspCodeSyncBO);
        redisSyncDataRspBo.setSyncDataMap(new HashMap());
        if (!ObjectUtils.isEmpty((Object)this.systemParam.getSyncWay()) && !this.systemParam.getSyncWay().equals("api")) {
            syncDataClusterIdList.forEach(clusterId -> {
                ArrayList syncDataList = new ArrayList();
                nodeDataBO.getSyncBOs().forEach(syncBO -> {
                    SyncDataReqBO syncDataReqBO = new SyncDataReqBO();
                    BeanUtils.copyProperties((Object)syncBO, (Object)syncDataReqBO);
                    syncDataReqBO.setClusterId(clusterId);
                    syncDataReqBO.setHirerId(Long.valueOf(1L));
                    RspBO rspBO = this.syncDataService.syncAllData(syncDataReqBO);
                    Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
                    syncDataList.add(gson.toJson((Object)rspBO));
                });
                redisSyncDataRspBo.getSyncDataMap().put(String.valueOf(clusterId), syncDataList);
            });
        } else {
            log.error("admin \u63a8\u9001\u914d\u7f6e\u5b58\u5728\u95ee\u9898\uff01syncWay:{}", (Object)this.systemParam.getSyncWay());
        }
    }

    private void webNodeProcessedDeal(RedisSyncDataBo redisSyncDataBo) {
        if (Boolean.TRUE.equals(redisSyncDataBo.isSuccess())) {
            log.info("\u8282\u70b9\u6d88\u606f\u5904\u7406\u6210\u529f\uff1a" + ChannelNaming.get(redisSyncDataBo.getName()));
        } else {
            log.error("\u8282\u70b9\u6d88\u606f\u5904\u7406\u5931\u8d25\uff1a" + ChannelNaming.get(redisSyncDataBo.getName()));
            log.error("\u8282\u70b9\u6536\u5230\u6d88\u606f\uff1a" + redisSyncDataBo.getReceiveMsg());
            log.error("\u5931\u8d25\u539f\u56e0\uff1a" + redisSyncDataBo.getMsg());
        }
    }

    private void initClusterNodeDeal(RedisSyncDataBo redisSyncDataReqBo) {
        block12: {
            NodePO nodePO = new NodePO();
            BeanUtils.copyProperties((Object)redisSyncDataReqBo.getNodeBo(), (Object)nodePO);
            if (!ObjectUtils.isEmpty((Object)nodePO)) {
                this.adminClusterConfig.getCoreHeart().remove(redisSyncDataReqBo.getName());
                this.adminClusterConfig.getCoreHeart().add(redisSyncDataReqBo.getName());
                Boolean flag = false;
                String clusterId = nodePO.getClusterId().toString();
                String nodeIp = nodePO.getNodeIp();
                String port = nodePO.getPort().toString();
                Map webHeartbeatInfo = GsonUtil.toObjectMap((String)this.cacheClient.get(redisSyncDataReqBo.getName()).toString());
                Object webNodesObj = this.cacheClient.get(this.constantBaseVersion.getWEB_NODES());
                String webNodesStr = ObjectUtils.isEmpty((Object)webNodesObj) ? "{}" : webNodesObj.toString();
                Map nodes = (Map)GsonUtil.fromJson((String)webNodesStr, Map.class);
                List nodeInfos = (List)nodes.get(clusterId);
                ArrayList<Map> newNodeInfos = new ArrayList<Map>();
                HashMap<String, String> newEfficientNode = new HashMap<String, String>();
                newEfficientNode.put("createUserId", "1");
                newEfficientNode.put("updateUserId", "1");
                newEfficientNode.put("validFlag", "0");
                newEfficientNode.put("startTime", webHeartbeatInfo.get("startTime").toString());
                newEfficientNode.put("name", "<" + StringUtils.substringAfter((String)redisSyncDataReqBo.getName(), (String)"<"));
                newEfficientNode.put("remark", "\u5237\u65b0\u6210\u529f:" + DateUtil.formatDateWithMS((Date)new Date()));
                newEfficientNode.put("resUsingRate", "0");
                if (!CollectionUtils.isEmpty((Collection)nodeInfos)) {
                    for (Map nodeInfo : nodeInfos) {
                        if (nodeInfo.get("nodeIp").equals(nodeIp) && nodeInfo.get("port").equals(port)) {
                            ArrayList<HashMap<String, String>> efficientNodes = new ArrayList<HashMap<String, String>>();
                            efficientNodes.addAll(GsonUtil.fromList((String)GsonUtil.toJson(nodeInfo.get("efficientNodes")), Object[].class));
                            efficientNodes.add(newEfficientNode);
                            nodeInfo.put("efficientNodes", efficientNodes);
                            nodeInfo.put("efficientNodeCount", efficientNodes.size() + "");
                            newNodeInfos.add(nodeInfo);
                            flag = true;
                            break;
                        }
                        newNodeInfos.add(nodeInfo);
                    }
                }
                if (!flag.booleanValue()) {
                    HashMap<String, Object> nodeInfo = new HashMap<String, Object>();
                    ArrayList<HashMap<String, String>> efficientNodes = new ArrayList<HashMap<String, String>>();
                    efficientNodes.add(newEfficientNode);
                    nodeInfo.put("nodeIp", nodeIp);
                    nodeInfo.put("port", port);
                    nodeInfo.put("invalidNodes", new ArrayList());
                    nodeInfo.put("invalidNodeCount", "0");
                    nodeInfo.put("efficientNodes", efficientNodes);
                    nodeInfo.put("efficientNodeCount", "1");
                    nodeInfo.put("createTime", DateUtil.formatDateWithMS((Date)new Date()));
                    newNodeInfos.add(nodeInfo);
                    flag = true;
                }
                if (flag.booleanValue()) {
                    nodes.put(clusterId, newNodeInfos);
                    this.cacheClient.set(this.constantBaseVersion.getWEB_NODES(), (Object)GsonUtil.toJson((Object)nodes));
                } else {
                    log.error("\u65b0\u5efa\u5bb9\u5668\u5931\u8d25\uff01");
                }
                ClusterPO tmp = this.clusterMapper.queryByClusterId(nodePO.getClusterId());
                if (ObjectUtils.isEmpty((Object)tmp)) {
                    log.error("\u8282\u70b9\u521d\u59cb\u5316\u9519\u8bef,\u96c6\u7fa4\u4e0d\u5b58\u5728\uff1a{}", (Object)ChannelNaming.get(nodePO));
                    return;
                }
                NodePO selectNodePo = new NodePO();
                selectNodePo.setClusterId(nodePO.getClusterId());
                selectNodePo.setNodeIp(nodePO.getNodeIp());
                selectNodePo.setPort(nodePO.getPort());
                NodePO oldNodePO = this.nodeMapper.queryLimitOne(selectNodePo);
                try {
                    if (oldNodePO == null) {
                        nodePO.setValidFlag(1);
                        nodePO.setCreateUserId(1L);
                        nodePO.setCreateTime(new Date());
                        this.nodeMapper.insertSelective(nodePO);
                        log.info("Mysql\u521b\u5efa\u6838\u5fc3\u8282\u70b9\u6210\u529f");
                        this.notifyWebCoreNodeAll(nodePO, "\u65b0\u589e\u8282\u70b9");
                        break block12;
                    }
                    nodePO.setValidFlag(1);
                    nodePO.setUpdateUserId(1L);
                    nodePO.setUpdateTime(new Date());
                    this.nodeMapper.updateByIPAndPort(nodePO);
                    log.info("Mysql\u4fee\u6539\u6838\u5fc3\u8282\u70b9\u6210\u529f");
                    this.notifyWebCoreNodeAll(nodePO, "\u4fee\u6539\u8282\u70b9");
                }
                catch (Exception e) {
                    log.warn("Mysql\u6ce8\u518c\u8282\u70b9\u53d1\u751f\u9519\u8bef\uff1a{}", (Object)ChannelNaming.get(nodePO));
                }
            } else {
                log.error("\u8282\u70b9\u521d\u59cb\u5316\u9519\u8bef\uff1a{}", (Object)ChannelNaming.get(nodePO));
            }
        }
    }

    public void notifyWebCoreNodeAll(NodePO nodePO, String typeString) {
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setCode("NOTIFY");
        redisSyncDataBo.setMsg(typeString + "\uff1a" + nodePO.getNodeIp() + ":" + nodePO.getPort() + "  \u96c6\u7fa4\uff1a" + nodePO.getClusterId());
        this.adminClusterConfig.getCoreHeart().forEach(key -> this.pubSubRes.getClient().publish(ChannelNaming.get(key), GsonUtil.toJson((Object)redisSyncDataBo)));
        log.info("\u8282\u70b9\u589e\u52a0\u5168\u5c40\u901a\u77e5");
    }

    public void delRedisClusterNode(ClusterPO clusterPO) {
        NodePO nodePO = new NodePO();
        nodePO.setClusterId(clusterPO.getClusterId());
        List<NodePO> delNodePoList = this.nodeMapper.queryByCond(nodePO);
        StringBuilder stringBuilder = new StringBuilder("\u8282\u70b9\u5220\u9664\uff1a\u96c6\u7fa4(" + nodePO.getClusterId() + ") ");
        delNodePoList.forEach(delNodePO -> stringBuilder.append(nodePO.getNodeIp() + ":" + nodePO.getPort() + "  "));
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setCode("NOTIFY");
        redisSyncDataBo.setMsg(stringBuilder.toString());
        this.adminClusterConfig.getCoreHeart().forEach(key -> this.pubSubRes.getClient().publish(ChannelNaming.get(key), GsonUtil.toJson((Object)redisSyncDataBo)));
    }

    public void abilityRelease(List<SyncServiceBO> syncServiceBOList, String code) {
        try {
            if (ObjectUtils.isEmpty((Object)this.systemParam.getSyncWay()) || this.systemParam.getSyncWay().equals("api")) {
                this.dataSyncApi(syncServiceBOList, code);
            } else {
                this.dataSyncPubSub(syncServiceBOList, code);
            }
        }
        catch (Exception e) {
            log.error("{} \u6570\u636e\u5199\u5165\u5931\u8d25\uff01", (Object)this.systemParam.getSyncWay());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void dataSyncApi(List<SyncServiceBO> syncServiceBOList, String code) {
        List<Long> clusterIdList = syncServiceBOList.stream().map(SyncServiceBO::getClusterIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setSyncServiceBOList(syncServiceBOList);
        redisSyncDataBo.setCode(code);
        this.bulkPushData(clusterIdList, redisSyncDataBo);
    }

    public void dataSyncPubSub(List<SyncServiceBO> syncServiceBOList, String code) {
        List<Long> clusterIdList = syncServiceBOList.stream().map(SyncServiceBO::getClusterIds).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        NodeDataBO nodeDataBO = this.sysService.syncH2(this.syncReqPack(clusterIdList), "\u80fd\u529b\u53d1\u5e03\u83b7\u53d6\u5168\u91cf\u66f4\u65b0\u5185\u5bb9\uff01", null);
        List syncDataClusterIdList = nodeDataBO.getClusterIds();
        RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
        redisSyncDataBo.setCode(code);
        this.syncDataAcquisitionAndPackaging(nodeDataBO, syncDataClusterIdList, redisSyncDataBo);
        redisSyncDataBo.setSyncServiceBOList(syncServiceBOList);
        redisSyncDataBo.setCode(code);
        this.bulkPushData(clusterIdList, redisSyncDataBo);
    }

    public void abilityStatus(ModifyStatusBO modifyStatusBO, String code) {
        try {
            RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
            redisSyncDataBo.setModifyStatusBO(modifyStatusBO);
            redisSyncDataBo.setCode(code);
            this.adminClusterConfig.getCoreHeart().forEach(key -> this.pubSubRes.getClient().publish(ChannelNaming.get(key), GsonUtil.toJson((Object)redisSyncDataBo)));
        }
        catch (Exception e) {
            log.error("{} \u6570\u636e\u5199\u5165\u5931\u8d25\uff01", (Object)this.systemParam.getSyncWay());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writeRedisNode(NodeDataBO nodeDataBO, String code) {
        try {
            List clusterIdList = nodeDataBO.getClusterIds();
            RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
            redisSyncDataBo.setDataBO(nodeDataBO);
            redisSyncDataBo.setCode(code);
            this.syncDataAcquisitionAndPackaging(nodeDataBO, clusterIdList, redisSyncDataBo);
            this.bulkPushData(clusterIdList, redisSyncDataBo);
        }
        catch (Exception e) {
            log.error("{} \u6570\u636e\u5199\u5165\u5931\u8d25\uff01", (Object)this.systemParam.getSyncWay());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void increment(Long clusterId, String schema, Object multiple, List<Long> abilityIds) {
        try {
            TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
            LinkedList<String> syncData = new LinkedList<String>();
            Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").serializeNulls().create();
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(schema, multiple);
            syncData.add(gson.toJson((Object)RspBO.success(dataMap)));
            map.put(String.valueOf(clusterId), syncData);
            RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
            redisSyncDataBo.setCode("INCREMENT_SYNC_DATA");
            this.incrementAbilityScope(abilityIds, map, redisSyncDataBo);
        }
        catch (Exception e) {
            log.error("{} \u6570\u636e\u5199\u5165\u5931\u8d25\uff01", (Object)this.systemParam.getSyncWay());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void incrementAbilityScope(List<Long> abilityIds, Map<String, List<String>> map, RedisSyncDataBo redisSyncDataBo) {
        redisSyncDataBo.setSyncDataMap(map);
        if (!CollectionUtils.isEmpty(abilityIds)) {
            JSONObject extData = new JSONObject();
            extData.put("abilityIds", abilityIds);
            redisSyncDataBo.setExtData(extData);
        }
        this.adminClusterConfig.getCoreHeart().forEach(key -> this.pubSubRes.getClient().publish(ChannelNaming.get(key), GsonUtil.toJson((Object)redisSyncDataBo)));
    }

    public void incrementWriteRedisNode(Map<String, List<String>> map, List<Long> abilityIds, String code) {
        try {
            RedisSyncDataBo redisSyncDataBo = new RedisSyncDataBo();
            redisSyncDataBo.setCode(code);
            this.incrementAbilityScope(abilityIds, map, redisSyncDataBo);
        }
        catch (Exception e) {
            log.error("{} \u6570\u636e\u5199\u5165\u5931\u8d25\uff01", (Object)this.systemParam.getSyncWay());
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private void bulkPushData(List<Long> clusterIdList, RedisSyncDataBo redisSyncDataBo) {
        List channels = this.adminClusterConfig.getCoreHeart();
        clusterIdList.forEach(clusterId -> {
            log.info("channels:{}", (Object)channels);
            String name = this.constantBaseVersion.getWEB_NODES_HEARTBEAT();
            if (Boolean.FALSE.equals(this.hashTags)) {
                name = name.replace("{", "").replace("}", "");
            }
            String finalName = name;
            List<String> clusterChannel = channels.stream().filter(channel -> channel.contains(finalName + clusterId)).collect(Collectors.toList());
            clusterChannel.forEach(key -> this.pubSubRes.getClient().publish(ChannelNaming.get(key), GsonUtil.toJson((Object)redisSyncDataBo)));
        });
    }

    private SyncReqBO syncReqPack(List<Long> clusterIds) {
        SyncReqBO syncReqBO = new SyncReqBO();
        ArrayList<String> ability = new ArrayList<String>();
        ability.add("abilityBasic");
        ability.add("abilityRelation");
        ArrayList<String> app = new ArrayList<String>();
        app.add("app");
        app.add("region");
        ArrayList<String> plugin = new ArrayList<String>();
        plugin.add("plugin");
        ArrayList<String> systemCode = new ArrayList<String>();
        systemCode.add("systemCode");
        ArrayList<String> exception = new ArrayList<String>();
        exception.add("exception");
        syncReqBO.setAbility(ability);
        syncReqBO.setApp(app);
        syncReqBO.setPlugin(plugin);
        syncReqBO.setSystemCode(systemCode);
        syncReqBO.setException(exception);
        syncReqBO.setClusterIds(clusterIds);
        return syncReqBO;
    }

    public CacheClient getCacheClient() {
        return this.cacheClient;
    }

    public NodeMapper getNodeMapper() {
        return this.nodeMapper;
    }

    public ClusterMapper getClusterMapper() {
        return this.clusterMapper;
    }

    public SystemParam getSystemParam() {
        return this.systemParam;
    }

    public AdminClusterConfig getAdminClusterConfig() {
        return this.adminClusterConfig;
    }

    public SyncDataService getSyncDataService() {
        return this.syncDataService;
    }

    public PubSubRes getPubSubRes() {
        return this.pubSubRes;
    }

    public SysService getSysService() {
        return this.sysService;
    }

    public AbilityProvideDeployMapper getAbilityProvideDeployMapper() {
        return this.abilityProvideDeployMapper;
    }

    public PluginMapper getPluginMapper() {
        return this.pluginMapper;
    }

    public int getWebNodesMapExpired() {
        return this.webNodesMapExpired;
    }

    public Boolean getHashTags() {
        return this.hashTags;
    }

    public ConstantBaseVersion getConstantBaseVersion() {
        return this.constantBaseVersion;
    }

    public PluginService getPluginService() {
        return this.pluginService;
    }

    public AbilityMessagePoolService getAbilityMessagePoolService() {
        return this.abilityMessagePoolService;
    }

    public void setCacheClient(CacheClient cacheClient) {
        this.cacheClient = cacheClient;
    }

    public void setNodeMapper(NodeMapper nodeMapper) {
        this.nodeMapper = nodeMapper;
    }

    public void setClusterMapper(ClusterMapper clusterMapper) {
        this.clusterMapper = clusterMapper;
    }

    public void setSystemParam(SystemParam systemParam) {
        this.systemParam = systemParam;
    }

    public void setAdminClusterConfig(AdminClusterConfig adminClusterConfig) {
        this.adminClusterConfig = adminClusterConfig;
    }

    public void setSyncDataService(SyncDataService syncDataService) {
        this.syncDataService = syncDataService;
    }

    public void setPubSubRes(PubSubRes pubSubRes) {
        this.pubSubRes = pubSubRes;
    }

    public void setSysService(SysService sysService) {
        this.sysService = sysService;
    }

    public void setAbilityProvideDeployMapper(AbilityProvideDeployMapper abilityProvideDeployMapper) {
        this.abilityProvideDeployMapper = abilityProvideDeployMapper;
    }

    public void setPluginMapper(PluginMapper pluginMapper) {
        this.pluginMapper = pluginMapper;
    }

    public void setWebNodesMapExpired(int webNodesMapExpired) {
        this.webNodesMapExpired = webNodesMapExpired;
    }

    public void setHashTags(Boolean hashTags) {
        this.hashTags = hashTags;
    }

    public void setConstantBaseVersion(ConstantBaseVersion constantBaseVersion) {
        this.constantBaseVersion = constantBaseVersion;
    }

    public void setPluginService(PluginService pluginService) {
        this.pluginService = pluginService;
    }

    public void setAbilityMessagePoolService(AbilityMessagePoolService abilityMessagePoolService) {
        this.abilityMessagePoolService = abilityMessagePoolService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PubSubMsgHandler)) {
            return false;
        }
        PubSubMsgHandler other = (PubSubMsgHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWebNodesMapExpired() != other.getWebNodesMapExpired()) {
            return false;
        }
        Boolean this$hashTags = this.getHashTags();
        Boolean other$hashTags = other.getHashTags();
        if (this$hashTags == null ? other$hashTags != null : !((Object)this$hashTags).equals(other$hashTags)) {
            return false;
        }
        CacheClient this$cacheClient = this.getCacheClient();
        CacheClient other$cacheClient = other.getCacheClient();
        if (this$cacheClient == null ? other$cacheClient != null : !this$cacheClient.equals(other$cacheClient)) {
            return false;
        }
        NodeMapper this$nodeMapper = this.getNodeMapper();
        NodeMapper other$nodeMapper = other.getNodeMapper();
        if (this$nodeMapper == null ? other$nodeMapper != null : !this$nodeMapper.equals(other$nodeMapper)) {
            return false;
        }
        ClusterMapper this$clusterMapper = this.getClusterMapper();
        ClusterMapper other$clusterMapper = other.getClusterMapper();
        if (this$clusterMapper == null ? other$clusterMapper != null : !this$clusterMapper.equals(other$clusterMapper)) {
            return false;
        }
        SystemParam this$systemParam = this.getSystemParam();
        SystemParam other$systemParam = other.getSystemParam();
        if (this$systemParam == null ? other$systemParam != null : !this$systemParam.equals(other$systemParam)) {
            return false;
        }
        AdminClusterConfig this$adminClusterConfig = this.getAdminClusterConfig();
        AdminClusterConfig other$adminClusterConfig = other.getAdminClusterConfig();
        if (this$adminClusterConfig == null ? other$adminClusterConfig != null : !this$adminClusterConfig.equals(other$adminClusterConfig)) {
            return false;
        }
        SyncDataService this$syncDataService = this.getSyncDataService();
        SyncDataService other$syncDataService = other.getSyncDataService();
        if (this$syncDataService == null ? other$syncDataService != null : !this$syncDataService.equals(other$syncDataService)) {
            return false;
        }
        PubSubRes this$pubSubRes = this.getPubSubRes();
        PubSubRes other$pubSubRes = other.getPubSubRes();
        if (this$pubSubRes == null ? other$pubSubRes != null : !this$pubSubRes.equals(other$pubSubRes)) {
            return false;
        }
        SysService this$sysService = this.getSysService();
        SysService other$sysService = other.getSysService();
        if (this$sysService == null ? other$sysService != null : !this$sysService.equals(other$sysService)) {
            return false;
        }
        AbilityProvideDeployMapper this$abilityProvideDeployMapper = this.getAbilityProvideDeployMapper();
        AbilityProvideDeployMapper other$abilityProvideDeployMapper = other.getAbilityProvideDeployMapper();
        if (this$abilityProvideDeployMapper == null ? other$abilityProvideDeployMapper != null : !this$abilityProvideDeployMapper.equals(other$abilityProvideDeployMapper)) {
            return false;
        }
        PluginMapper this$pluginMapper = this.getPluginMapper();
        PluginMapper other$pluginMapper = other.getPluginMapper();
        if (this$pluginMapper == null ? other$pluginMapper != null : !this$pluginMapper.equals(other$pluginMapper)) {
            return false;
        }
        ConstantBaseVersion this$constantBaseVersion = this.getConstantBaseVersion();
        ConstantBaseVersion other$constantBaseVersion = other.getConstantBaseVersion();
        if (this$constantBaseVersion == null ? other$constantBaseVersion != null : !this$constantBaseVersion.equals(other$constantBaseVersion)) {
            return false;
        }
        PluginService this$pluginService = this.getPluginService();
        PluginService other$pluginService = other.getPluginService();
        if (this$pluginService == null ? other$pluginService != null : !this$pluginService.equals(other$pluginService)) {
            return false;
        }
        AbilityMessagePoolService this$abilityMessagePoolService = this.getAbilityMessagePoolService();
        AbilityMessagePoolService other$abilityMessagePoolService = other.getAbilityMessagePoolService();
        return !(this$abilityMessagePoolService == null ? other$abilityMessagePoolService != null : !this$abilityMessagePoolService.equals(other$abilityMessagePoolService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PubSubMsgHandler;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWebNodesMapExpired();
        Boolean $hashTags = this.getHashTags();
        result = result * 59 + ($hashTags == null ? 43 : ((Object)$hashTags).hashCode());
        CacheClient $cacheClient = this.getCacheClient();
        result = result * 59 + ($cacheClient == null ? 43 : $cacheClient.hashCode());
        NodeMapper $nodeMapper = this.getNodeMapper();
        result = result * 59 + ($nodeMapper == null ? 43 : $nodeMapper.hashCode());
        ClusterMapper $clusterMapper = this.getClusterMapper();
        result = result * 59 + ($clusterMapper == null ? 43 : $clusterMapper.hashCode());
        SystemParam $systemParam = this.getSystemParam();
        result = result * 59 + ($systemParam == null ? 43 : $systemParam.hashCode());
        AdminClusterConfig $adminClusterConfig = this.getAdminClusterConfig();
        result = result * 59 + ($adminClusterConfig == null ? 43 : $adminClusterConfig.hashCode());
        SyncDataService $syncDataService = this.getSyncDataService();
        result = result * 59 + ($syncDataService == null ? 43 : $syncDataService.hashCode());
        PubSubRes $pubSubRes = this.getPubSubRes();
        result = result * 59 + ($pubSubRes == null ? 43 : $pubSubRes.hashCode());
        SysService $sysService = this.getSysService();
        result = result * 59 + ($sysService == null ? 43 : $sysService.hashCode());
        AbilityProvideDeployMapper $abilityProvideDeployMapper = this.getAbilityProvideDeployMapper();
        result = result * 59 + ($abilityProvideDeployMapper == null ? 43 : $abilityProvideDeployMapper.hashCode());
        PluginMapper $pluginMapper = this.getPluginMapper();
        result = result * 59 + ($pluginMapper == null ? 43 : $pluginMapper.hashCode());
        ConstantBaseVersion $constantBaseVersion = this.getConstantBaseVersion();
        result = result * 59 + ($constantBaseVersion == null ? 43 : $constantBaseVersion.hashCode());
        PluginService $pluginService = this.getPluginService();
        result = result * 59 + ($pluginService == null ? 43 : $pluginService.hashCode());
        AbilityMessagePoolService $abilityMessagePoolService = this.getAbilityMessagePoolService();
        result = result * 59 + ($abilityMessagePoolService == null ? 43 : $abilityMessagePoolService.hashCode());
        return result;
    }

    public String toString() {
        return "PubSubMsgHandler(cacheClient=" + this.getCacheClient() + ", nodeMapper=" + this.getNodeMapper() + ", clusterMapper=" + this.getClusterMapper() + ", systemParam=" + this.getSystemParam() + ", adminClusterConfig=" + this.getAdminClusterConfig() + ", syncDataService=" + this.getSyncDataService() + ", pubSubRes=" + this.getPubSubRes() + ", sysService=" + this.getSysService() + ", abilityProvideDeployMapper=" + this.getAbilityProvideDeployMapper() + ", pluginMapper=" + this.getPluginMapper() + ", webNodesMapExpired=" + this.getWebNodesMapExpired() + ", hashTags=" + this.getHashTags() + ", constantBaseVersion=" + this.getConstantBaseVersion() + ", pluginService=" + this.getPluginService() + ", abilityMessagePoolService=" + this.getAbilityMessagePoolService() + ")";
    }
}

