/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.config.pubsub.redis;

import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.config.pubsub.loader.PubSubRes;
import com.ohaotian.abilityadmin.mapper.AbilityProvideDeployMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.NodeMapper;
import com.ohaotian.abilityadmin.system.service.SyncDataService;
import com.ohaotian.abilityadmin.system.service.SysService;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.config.cluster.AdminClusterConfig;
import com.ohaotian.portalcommon.config.systemcode.SystemParam;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisPubSub;

@Service
@ConditionalOnProperty(prefix="system.parma", name={"syncWay"}, havingValue="redis")
public class PubSubRedisConsumer
extends JedisPubSub {
    private static final Logger log = LoggerFactory.getLogger(PubSubRedisConsumer.class);
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Autowired
    CacheClient cacheClient;
    @Resource
    NodeMapper nodeMapper;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    SystemParam systemParam;
    @Autowired
    AdminClusterConfig adminClusterConfig;
    @Autowired
    SyncDataService syncDataService;
    @Resource
    PubSubRes pubSubRes;
    @Resource
    SysService sysService;
    @Resource
    AbilityProvideDeployMapper abilityProvideDeployMapper;
    @Resource
    private AuthorityService authorityService;

    public void init() {
        this.pubSubMsgHandler.setCacheClient(this.cacheClient);
        this.pubSubMsgHandler.setNodeMapper(this.nodeMapper);
        this.pubSubMsgHandler.setClusterMapper(this.clusterMapper);
        this.pubSubMsgHandler.setSystemParam(this.systemParam);
        this.pubSubMsgHandler.setAdminClusterConfig(this.adminClusterConfig);
        this.pubSubMsgHandler.setSyncDataService(this.syncDataService);
        this.pubSubMsgHandler.setPubSubRes(this.pubSubRes);
        this.pubSubMsgHandler.setSysService(this.sysService);
        this.pubSubMsgHandler.setAbilityProvideDeployMapper(this.abilityProvideDeployMapper);
    }

    public void onMessage(String channel, String message) {
        this.init();
        this.pubSubMsgHandler.redisCoreNodeDeal(message);
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        System.out.printf("subscribe redis channel success, channel %s, subscribedChannels %d%n", channel, subscribedChannels);
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        System.out.printf("unsubscribe redis channel, channel %s, subscribedChannels %d%n", channel, subscribedChannels);
    }
}

