/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.platform.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.abilityadmin.constant.TemplateEnum;
import com.ohaotian.abilityadmin.model.po.AbilityTemplatePo;
import com.ohaotian.abilityadmin.platform.model.bo.PlatformTemplateReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateDeleteReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManagePageReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManageReqBo;
import com.ohaotian.abilityadmin.platform.model.bo.TemplateManageRspBo;
import com.ohaotian.abilityadmin.platform.service.PlatformTemplateService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plat/template"})
public class PlatformTemplateController {
    @Autowired
    private PlatformTemplateService platformTemplateService;

    @PostMapping(value={"/type"})
    @BusiResponseBody
    public RspBO<JSONArray> templateType() {
        JSONArray jsonArray = new JSONArray();
        for (TemplateEnum tEnum : TemplateEnum.values()) {
            JSONObject jsonEnum = new JSONObject();
            jsonEnum.put("label", (Object)tEnum.getDesc());
            jsonEnum.put("code", (Object)tEnum.getCode());
            jsonArray.add((Object)jsonEnum);
        }
        return RspBO.success((Object)jsonArray);
    }

    @PostMapping(value={"/selectList"})
    @BusiResponseBody
    public RspBO<RspPage<TemplateManageRspBo>> selectList(@RequestBody TemplateManagePageReqBo reqBo) {
        return this.platformTemplateService.selectList(reqBo);
    }

    @PostMapping(value={"/detail"})
    @BusiResponseBody
    public RspBO<Object> details(@RequestBody TemplateManageReqBo reqBo) {
        return this.platformTemplateService.getDetail(reqBo);
    }

    @PostMapping(value={"/add"})
    @BusiResponseBody
    public RspBO<String> add(@RequestBody TemplateManageReqBo reqBo) {
        return this.platformTemplateService.addTemplate(reqBo);
    }

    @PostMapping(value={"/delete"})
    @BusiResponseBody
    public RspBO<String> delete(@RequestBody TemplateDeleteReqBo reqBo) {
        return this.platformTemplateService.deleteTemplate(reqBo);
    }

    @PostMapping(value={"/modify"})
    @BusiResponseBody
    public RspBO<String> modify(@RequestBody TemplateManageReqBo reqBo) {
        return this.platformTemplateService.modifyTemplate(reqBo);
    }

    @PostMapping(value={"/ability"})
    @BusiResponseBody
    public RspBO<Map<String, Object>> abilityTemplate(@RequestBody PlatformTemplateReqBo reqBo) {
        return this.platformTemplateService.getAbilityTemplate(reqBo);
    }

    @PostMapping(value={"/manage"})
    @BusiResponseBody
    public RspBO<Map<String, Object>> manageTemplate(@RequestBody PlatformTemplateReqBo reqBo) {
        return this.platformTemplateService.getManageTemplate();
    }

    @PostMapping(value={"/noauth/hpartyCheck/accessToken"})
    @BusiResponseBody
    public String hpartyCheck(@RequestBody JSONObject reqBo) {
        return this.getAccessToken();
    }

    @PostMapping(value={"/noauth/jdHpartyCheck/accessToken"})
    public String jdHpartyCheck(HttpServletRequest request) {
        return this.getAccessToken();
    }

    private String getAccessToken() {
        AbilityTemplatePo abilityTemplatePo = new AbilityTemplatePo();
        abilityTemplatePo.setTemplateType(TemplateEnum.TOKEN.getCode());
        abilityTemplatePo.setTemplateCode("DEFAULT");
        String data = this.platformTemplateService.getTemplate(abilityTemplatePo);
        RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)data, RefreshTokenRspBO.class);
        refreshTokenRspBO.getResult().setTime(DateUtil.getCurrentDateTime());
        refreshTokenRspBO.getResult().setRefresh_token(DateUtil.getCurrentDateTime());
        String token = "MOCK_TOKEN_" + new Date().getTime();
        refreshTokenRspBO.getResult().setRefresh_token(token);
        refreshTokenRspBO.getResult().setAccess_token(token);
        return GsonUtil.toJson((Object)refreshTokenRspBO);
    }
}

