/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.util.jsons2xsd;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.ohaotian.abilityadmin.util.jsons2xsd.Assert;
import com.ohaotian.abilityadmin.util.jsons2xsd.Config;
import com.ohaotian.abilityadmin.util.jsons2xsd.XmlUtil;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Jsons2Xsd {
    private static final String TYPE_REFERENCE = "reference";
    private static final String TYPE_ENUM = "enum";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_PROPERTIES = "properties";
    private static final String FIELD_ITEMS = "items";
    private static final String FIELD_REQUIRED = "required";
    private static final String XSD_ATTRIBUTE = "attribute";
    private static final String XSD_ELEMENT = "element";
    private static final String XSD_SEQUENCE = "sequence";
    private static final String XSD_COMPLEXTYPE = "complexType";
    private static final String XSD_SIMPLETYPE = "simpleType";
    private static final String XSD_RESTRICTION = "restriction";
    private static final String XSD_VALUE = "value";
    private static final String XSD_CHOICE = "choice";
    private static final String XSD_OBJECT = "object";
    private static final String XSD_ARRAY = "array";
    private static final String JSON_REF = "$ref";
    private static final String JSON_DEFINITIONS = "definitions";
    private static final Map<String, String> typeMapping = new HashMap<String, String>();
    private static final ObjectMapper mapper;

    private Jsons2Xsd() {
    }

    public static Document convert(String jsonSchema, Config cfg) throws IOException {
        return Jsons2Xsd.convert(jsonSchema, null, cfg);
    }

    public static Document convert(String jsonSchema, Reader definitionSchema, Config cfg) throws IOException {
        JsonNode definitions;
        JsonNode rootNode = mapper.readTree(jsonSchema);
        Element schemaRoot = Jsons2Xsd.createDocument(cfg);
        LinkedHashSet<String> neededElements = new LinkedHashSet<String>();
        String type = rootNode.path("type").textValue();
        Assert.notNull(type, "type property of root node must be defined");
        switch (type) {
            case "object": {
                Jsons2Xsd.handleObjectSchema(cfg, rootNode, schemaRoot, neededElements);
                break;
            }
            case "array": {
                Jsons2Xsd.handleArraySchema(cfg, rootNode, schemaRoot, neededElements);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown root type: " + type);
            }
        }
        if (definitionSchema != null) {
            JsonNode definitionsRootNode = mapper.readTree(definitionSchema);
            definitions = definitionsRootNode.path(JSON_DEFINITIONS);
        } else {
            definitions = rootNode.path(JSON_DEFINITIONS);
        }
        Jsons2Xsd.doIterateDefinitions(neededElements, schemaRoot, definitions, cfg);
        if (cfg.isValidateXsdSchema()) {
            XmlUtil.validateSchema(schemaRoot.getOwnerDocument());
        }
        return schemaRoot.getOwnerDocument();
    }

    private static void handleArraySchema(Config cfg, JsonNode rootNode, Element schemaRoot, Set<String> neededElements) {
        JsonNode items = rootNode.path(FIELD_ITEMS);
        Assert.notNull(items, "\"items\" property should be found in root of an array schema\"");
        Element schemaSequence = Jsons2Xsd.createRootElementIfNeeded(cfg, schemaRoot);
        if (!items.isArray()) {
            Jsons2Xsd.doIterate(neededElements, schemaSequence, items.get(FIELD_PROPERTIES), Jsons2Xsd.getRequiredList(items), cfg);
        } else {
            Jsons2Xsd.doIterate(neededElements, schemaSequence, items, Jsons2Xsd.getRequiredList(rootNode), cfg);
        }
    }

    private static Element createRootElementIfNeeded(Config cfg, Element schemaRoot) {
        if (cfg.isCreateRootElement()) {
            Element wrapper = Jsons2Xsd.element(schemaRoot, XSD_ELEMENT, cfg);
            wrapper.setAttribute(FIELD_NAME, cfg.getName());
            Element schemaComplexType = Jsons2Xsd.element(wrapper, XSD_COMPLEXTYPE, cfg);
            return Jsons2Xsd.element(schemaComplexType, XSD_SEQUENCE, cfg);
        }
        Element schemaComplexType = Jsons2Xsd.element(schemaRoot, XSD_COMPLEXTYPE, cfg);
        return Jsons2Xsd.element(schemaComplexType, XSD_SEQUENCE, cfg);
    }

    private static void handleObjectSchema(Config cfg, JsonNode rootNode, Element schemaRoot, Set<String> neededElements) {
        JsonNode properties = rootNode.get(FIELD_PROPERTIES);
        Assert.notNull(properties, "\"properties\" property should be found in root of JSON schema\"");
        Element schemaSequence = Jsons2Xsd.createRootElementIfNeeded(cfg, schemaRoot);
        Jsons2Xsd.doIterate(neededElements, schemaSequence, properties, Jsons2Xsd.getRequiredList(rootNode), cfg);
    }

    private static Element createDocument(Config cfg) {
        Document xsdDoc = XmlUtil.newDocument();
        xsdDoc.setXmlStandalone(true);
        Element schemaRoot = Jsons2Xsd.element(xsdDoc, "schema", cfg);
        schemaRoot.setAttribute("xmlns:" + cfg.getNsAlias(), cfg.getTargetNamespace());
        schemaRoot.setAttribute("elementFormDefault", "qualified");
        if (cfg.isAttributesQualified()) {
            schemaRoot.setAttribute("attributeFormDefault", "qualified");
        }
        return schemaRoot;
    }

    private static void doIterateDefinitions(Set<String> neededElements, Element elem, JsonNode node, Config cfg) {
        Iterator iter = node.fields();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String key = (String)entry.getKey();
            JsonNode val = (JsonNode)entry.getValue();
            if (!neededElements.contains(key) && cfg.isIncludeOnlyUsedTypes()) continue;
            if ("Link".equals(key)) {
                Element schemaComplexType = Jsons2Xsd.element(elem, XSD_COMPLEXTYPE, cfg);
                schemaComplexType.setAttribute(FIELD_NAME, key);
                Element href = Jsons2Xsd.element(schemaComplexType, XSD_ATTRIBUTE, cfg);
                Element rel = Jsons2Xsd.element(schemaComplexType, XSD_ATTRIBUTE, cfg);
                Element title = Jsons2Xsd.element(schemaComplexType, XSD_ATTRIBUTE, cfg);
                Element method = Jsons2Xsd.element(schemaComplexType, XSD_ATTRIBUTE, cfg);
                Element type = Jsons2Xsd.element(schemaComplexType, XSD_ATTRIBUTE, cfg);
                href.setAttribute(FIELD_NAME, "href");
                href.setAttribute("type", "string");
                rel.setAttribute(FIELD_NAME, "rel");
                rel.setAttribute("type", "string");
                title.setAttribute(FIELD_NAME, "title");
                title.setAttribute("type", "string");
                method.setAttribute(FIELD_NAME, "method");
                method.setAttribute("type", "string");
                type.setAttribute(FIELD_NAME, "type");
                type.setAttribute("type", "string");
                continue;
            }
            Jsons2Xsd.handleObject(neededElements, key, elem, val, cfg);
        }
    }

    private static void handleObject(Set<String> neededElements, String key, Element elem, JsonNode node, Config cfg) {
        JsonNode properties = node.get(FIELD_PROPERTIES);
        if (properties != null) {
            Element complexType = Jsons2Xsd.element(elem, XSD_COMPLEXTYPE, cfg);
            Element schemaSequence = Jsons2Xsd.element(complexType, XSD_SEQUENCE, cfg);
            Jsons2Xsd.doIterate(neededElements, schemaSequence, properties, Jsons2Xsd.getRequiredList(node), cfg);
        } else if (node.get("oneOf") != null) {
            ArrayNode oneOf = (ArrayNode)node.get("oneOf");
            Jsons2Xsd.handleChoice(neededElements, elem, oneOf, cfg);
        }
    }

    private static void handleChoice(Set<String> neededElements, Element elem, ArrayNode oneOf, Config cfg) {
        Element complexTypeElem = Jsons2Xsd.element(elem, XSD_COMPLEXTYPE, cfg);
        Element choiceElem = Jsons2Xsd.element(complexTypeElem, XSD_CHOICE, cfg);
        for (JsonNode e : oneOf) {
            Element nodeElem = Jsons2Xsd.element(choiceElem, XSD_ELEMENT, cfg);
            JsonNode refs = e.get(JSON_REF);
            String fixRef = refs.asText().replace("#/definitions/", cfg.getNsAlias() + ":");
            String name = fixRef.substring(cfg.getNsAlias().length() + 1);
            nodeElem.setAttribute(FIELD_NAME, name);
            nodeElem.setAttribute("type", fixRef);
            neededElements.add(name);
        }
    }

    private static void doIterate(Set<String> neededElements, Element elem, JsonNode node, List<String> requiredList, Config cfg) {
        block3: {
            block2: {
                if (!node.isObject()) break block2;
                Iterator fieldIter = node.fields();
                while (fieldIter.hasNext()) {
                    Map.Entry entry = (Map.Entry)fieldIter.next();
                    String key = (String)entry.getKey();
                    JsonNode val = (JsonNode)entry.getValue();
                    Jsons2Xsd.doIterateSingle(neededElements, key, val, elem, requiredList.contains(key), cfg);
                }
                break block3;
            }
            if (!node.isArray()) break block3;
            int i = 0;
            for (JsonNode entry : node) {
                String key = String.format("item%s", i++);
                JsonNode val = entry;
                Jsons2Xsd.doIterateSingle(neededElements, key, val, elem, requiredList.contains(key), cfg);
            }
        }
    }

    private static void doIterateSingle(Set<String> neededElements, String name, JsonNode val, Element elem, boolean required, Config cfg) {
        String xsdType = Jsons2Xsd.determineXsdType(cfg, name, val);
        Element nodeElem = Jsons2Xsd.element(elem, XSD_ELEMENT, cfg);
        nodeElem.setAttribute(FIELD_NAME, name);
        if (!XSD_OBJECT.equals(xsdType) && !XSD_ARRAY.equals(xsdType)) {
            nodeElem.setAttribute("type", cfg.getNsAlias() + ":" + xsdType);
        }
        if (!required) {
            nodeElem.setAttribute("minOccurs", "0");
        }
        switch (xsdType) {
            case "array": {
                Jsons2Xsd.handleArray(neededElements, nodeElem, val, cfg);
                break;
            }
            case "decimal": 
            case "int": {
                Jsons2Xsd.handleNumber(nodeElem, xsdType, val, cfg);
                break;
            }
            case "enum": {
                Jsons2Xsd.handleEnum(nodeElem, val, cfg);
                break;
            }
            case "object": {
                Jsons2Xsd.handleObject(neededElements, name, nodeElem, val, cfg);
                break;
            }
            case "string": {
                Jsons2Xsd.handleString(nodeElem, val, cfg);
                break;
            }
            case "reference": {
                Jsons2Xsd.handleReference(neededElements, nodeElem, val, cfg);
                break;
            }
        }
    }

    private static void handleReference(Set<String> neededElements, Element nodeElem, JsonNode val, Config cfg) {
        JsonNode refs = val.get(JSON_REF);
        nodeElem.removeAttribute("type");
        String fixRef = refs.asText().replace("#/definitions/", cfg.getNsAlias() + ":");
        String name = fixRef.substring(cfg.getNsAlias().length() + 1);
        String oldName = nodeElem.getAttribute(FIELD_NAME);
        if (oldName.length() <= 0) {
            nodeElem.setAttribute(FIELD_NAME, name);
        }
        nodeElem.setAttribute("type", fixRef);
        neededElements.add(name);
    }

    private static void handleString(Element nodeElem, JsonNode val, Config cfg) {
        Integer minimumLength = Jsons2Xsd.getIntVal(val, "minLength");
        Integer maximumLength = Jsons2Xsd.getIntVal(val, "maxLength");
        String expression = val.path("pattern").textValue();
        if (minimumLength != null || maximumLength != null || expression != null) {
            Element max;
            nodeElem.removeAttribute("type");
            Element simpleType = Jsons2Xsd.element(nodeElem, XSD_SIMPLETYPE, cfg);
            Element restriction = Jsons2Xsd.element(simpleType, XSD_RESTRICTION, cfg);
            restriction.setAttribute("base", cfg.getNsAlias() + ":" + "string");
            if (minimumLength != null) {
                Element min = Jsons2Xsd.element(restriction, "minLength", cfg);
                min.setAttribute(XSD_VALUE, Integer.toString(minimumLength));
            }
            if (maximumLength != null) {
                max = Jsons2Xsd.element(restriction, "maxLength", cfg);
                max.setAttribute(XSD_VALUE, Integer.toString(maximumLength));
            }
            if (expression != null) {
                max = Jsons2Xsd.element(restriction, "pattern", cfg);
                max.setAttribute(XSD_VALUE, expression);
            }
        }
    }

    private static void handleEnum(Element nodeElem, JsonNode val, Config cfg) {
        nodeElem.removeAttribute("type");
        Element simpleType = Jsons2Xsd.element(nodeElem, XSD_SIMPLETYPE, cfg);
        Element restriction = Jsons2Xsd.element(simpleType, XSD_RESTRICTION, cfg);
        restriction.setAttribute("base", cfg.getNsAlias() + ":" + "string");
        JsonNode enumNode = val.get(TYPE_ENUM);
        for (int i = 0; i < enumNode.size(); ++i) {
            String enumVal = enumNode.path(i).asText();
            Element enumElem = Jsons2Xsd.element(restriction, "enumeration", cfg);
            enumElem.setAttribute(XSD_VALUE, enumVal);
        }
    }

    private static void handleNumber(Element nodeElem, String xsdType, JsonNode jsonNode, Config cfg) {
        Integer minimum = Jsons2Xsd.getIntVal(jsonNode, "minimum");
        Integer maximum = Jsons2Xsd.getIntVal(jsonNode, "maximum");
        boolean exclusiveMinimum = Jsons2Xsd.getBooleanVal(jsonNode, "exclusiveMinimum");
        boolean exclusiveMaximum = Jsons2Xsd.getBooleanVal(jsonNode, "exclusiveMaximum");
        if (minimum != null || maximum != null) {
            nodeElem.removeAttribute("type");
            Element simpleType = Jsons2Xsd.element(nodeElem, XSD_SIMPLETYPE, cfg);
            Element restriction = Jsons2Xsd.element(simpleType, XSD_RESTRICTION, cfg);
            restriction.setAttribute("base", cfg.getNsAlias() + ":" + xsdType);
            if (minimum != null) {
                Element min;
                if (exclusiveMinimum) {
                    min = Jsons2Xsd.element(restriction, "minInclusive", cfg);
                    min.setAttribute(XSD_VALUE, Integer.toString(minimum));
                } else {
                    min = Jsons2Xsd.element(restriction, "minExclusive", cfg);
                    min.setAttribute(XSD_VALUE, Integer.toString(minimum));
                }
            }
            if (maximum != null) {
                Element max;
                if (exclusiveMaximum) {
                    max = Jsons2Xsd.element(restriction, "maxInclusive", cfg);
                    max.setAttribute(XSD_VALUE, Integer.toString(maximum));
                } else {
                    max = Jsons2Xsd.element(restriction, "maxExclusive", cfg);
                    max.setAttribute(XSD_VALUE, Integer.toString(maximum));
                }
            }
        }
    }

    private static void handleArray(Set<String> neededElements, Element nodeElem, JsonNode jsonNode, Config cfg) {
        JsonNode arrItems = jsonNode.path(FIELD_ITEMS);
        String arrayXsdType = Jsons2Xsd.determineXsdType(cfg, arrItems.path("type").textValue(), arrItems);
        Jsons2Xsd.handleArrayElements(neededElements, jsonNode, arrItems, arrayXsdType, nodeElem, cfg);
    }

    private static void handleArrayElements(Set<String> neededElements, JsonNode jsonNode, JsonNode arrItems, String arrayXsdType, Element arrElem, Config cfg) {
        if (arrayXsdType.equals(TYPE_REFERENCE)) {
            Jsons2Xsd.handleReference(neededElements, arrElem, arrItems, cfg);
        } else if (arrayXsdType.equals(XSD_OBJECT)) {
            Jsons2Xsd.handleObject(neededElements, null, arrElem, arrItems, cfg);
        } else {
            arrElem.setAttribute(FIELD_NAME, "item");
            arrElem.setAttribute("type", cfg.getNsAlias() + ":" + arrayXsdType);
        }
        Integer minItems = Jsons2Xsd.getIntVal(jsonNode, "minItems");
        arrElem.setAttribute("minOccurs", minItems != null ? Integer.toString(minItems) : "0");
        Integer maxItems = Jsons2Xsd.getIntVal(jsonNode, "maxItems");
        arrElem.setAttribute("maxOccurs", maxItems != null ? Integer.toString(maxItems) : "unbounded");
    }

    private static String determineXsdType(Config cfg, String key, JsonNode node) {
        boolean isRef;
        String jsonType = node.path("type").textValue();
        String jsonFormat = node.path("format").textValue();
        boolean isEnum = node.get(TYPE_ENUM) != null;
        boolean bl = isRef = node.get(JSON_REF) != null;
        if (isRef) {
            return TYPE_REFERENCE;
        }
        if (isEnum) {
            return TYPE_ENUM;
        }
        if (jsonType.equalsIgnoreCase(XSD_OBJECT)) {
            return XSD_OBJECT;
        }
        if (jsonType.equalsIgnoreCase(XSD_ARRAY)) {
            return XSD_ARRAY;
        }
        Assert.notNull(jsonType, "type must be specified on node '" + key + "': " + node);
        String xsdType = Jsons2Xsd.getType(jsonType, jsonFormat);
        if (xsdType != null) {
            return xsdType;
        }
        xsdType = cfg.getType(jsonType, jsonFormat);
        if (xsdType != null) {
            return xsdType;
        }
        Optional<Map.Entry> mapping = cfg.getTypeMapping().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(jsonType + "|")).findFirst();
        if (mapping.isPresent() && (Jsons2Xsd.isFormatMatch((String)mapping.get().getKey(), jsonType, jsonFormat) || cfg.isIgnoreUnknownFormats())) {
            return (String)mapping.get().getValue();
        }
        throw new IllegalArgumentException("Unable to determine XSD type for json type=" + jsonType + ", format=" + jsonFormat);
    }

    private static boolean isFormatMatch(String key, String jsonType, String jsonFormat) {
        return key.equalsIgnoreCase(jsonType + "|" + jsonFormat);
    }

    private static Integer getIntVal(JsonNode node, String attribute) {
        return node.get(attribute) != null ? Integer.valueOf(node.get(attribute).intValue()) : null;
    }

    private static boolean getBooleanVal(JsonNode node, String attribute) {
        return node.get(attribute) != null ? node.get(attribute).asBoolean() : true;
    }

    private static Element element(Node element, String name, Config cfg) {
        return XmlUtil.createXsdElement(element, cfg.getNsAlias() + ":" + name);
    }

    private static String getType(String type, String format) {
        String key = (type + (format != null ? "|" + format : "")).toLowerCase();
        return typeMapping.get(key);
    }

    private static List<String> getRequiredList(JsonNode jsonNode) {
        if (jsonNode.path(FIELD_REQUIRED).isMissingNode()) {
            return Collections.emptyList();
        }
        Assert.isTrue(jsonNode.path(FIELD_REQUIRED).isArray(), "'required' property must have type: array");
        ArrayList<String> requiredList = new ArrayList<String>();
        for (JsonNode requiredField : jsonNode.withArray(FIELD_REQUIRED)) {
            Assert.isTrue(requiredField.isTextual(), "required must be string");
            requiredList.add(requiredField.asText());
        }
        return requiredList;
    }

    static {
        typeMapping.put("string", "string");
        typeMapping.put(XSD_OBJECT, XSD_OBJECT);
        typeMapping.put(XSD_ARRAY, XSD_ARRAY);
        typeMapping.put("number", "decimal");
        typeMapping.put("boolean", "boolean");
        typeMapping.put("integer", "int");
        typeMapping.put("string|uri", "anyURI");
        typeMapping.put("string|email", "string");
        typeMapping.put("string|phone", "string");
        typeMapping.put("string|date-time", "dateTime");
        typeMapping.put("string|date", "date");
        typeMapping.put("string|time", "time");
        typeMapping.put("string|utc-millisec", "long");
        typeMapping.put("string|regex", "string");
        typeMapping.put("string|color", "string");
        typeMapping.put("string|style", "string");
        mapper = new ObjectMapper();
    }
}

