/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.impl;

import com.ohaotian.abilityadmin.ability.service.AbilityErpPathService;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionRepBO;
import com.ohaotian.abilityadmin.mapper.RegionAddrMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.model.po.RegionAddrPO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityErpPathServiceImpl
implements AbilityErpPathService {
    private static final Logger log = LoggerFactory.getLogger(AbilityErpPathServiceImpl.class);
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private RegionAddrMapper regionAddrMapper;

    @Override
    public String theFullPathCache(Boolean whole, String erpPath, Integer regionCallProtocol, RegionAddrPO regionAddrPo) {
        if (Boolean.TRUE.equals(whole)) {
            StringBuilder stringBuilder = new StringBuilder();
            if (regionCallProtocol != 0) {
                stringBuilder.append("https://");
            } else {
                stringBuilder.append("http://");
            }
            if (!ObjectUtils.isEmpty((Object)regionAddrPo)) {
                stringBuilder.append(regionAddrPo.getIp());
                if (!ObjectUtils.isEmpty((Object)regionAddrPo.getPort())) {
                    stringBuilder.append(":");
                    stringBuilder.append(regionAddrPo.getPort());
                }
            } else {
                stringBuilder.append("\u672a\u914d\u7f6e\u53ef\u7528\u5730\u5740");
            }
            if (erpPath.startsWith("http")) {
                stringBuilder = new StringBuilder(erpPath);
            } else {
                stringBuilder.append(erpPath);
            }
            return stringBuilder.toString();
        }
        return erpPath;
    }

    @Override
    public String theFullPath(Boolean whole, Long regionId, String erpPath) {
        if (Boolean.TRUE.equals(whole)) {
            StringBuilder stringBuilder = new StringBuilder();
            AppRegionRepBO appRegionRepBO = new AppRegionRepBO();
            appRegionRepBO.setRegionId(regionId);
            RegionPO regionPo = this.regionMapper.queryByRegionId(appRegionRepBO.getRegionId());
            if (regionPo.getCallProtocol() != 0) {
                stringBuilder.append("https://");
            } else {
                stringBuilder.append("http://");
            }
            RegionAddrPO regionAddrPo = new RegionAddrPO();
            regionAddrPo.setRegionId(regionId);
            List<RegionAddrPO> regionAddrPOList = this.regionAddrMapper.queryByCond(regionAddrPo);
            if (!CollectionUtils.isEmpty(regionAddrPOList)) {
                stringBuilder.append(regionAddrPOList.get(0).getIp());
                if (!ObjectUtils.isEmpty((Object)regionAddrPOList.get(0).getPort())) {
                    stringBuilder.append(":");
                    stringBuilder.append(regionAddrPOList.get(0).getPort());
                }
            } else {
                stringBuilder.append("\u672a\u914d\u7f6e\u53ef\u7528\u5730\u5740");
            }
            if (erpPath.startsWith("http")) {
                stringBuilder = new StringBuilder(erpPath);
            } else {
                stringBuilder.append(erpPath);
            }
            return stringBuilder.toString();
        }
        return erpPath;
    }
}

