/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.system.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.abilityadmin.ability.service.AbilityDynamicService;
import com.ohaotian.abilityadmin.mapper.AbilityMeltMapper;
import com.ohaotian.abilityadmin.mapper.SyncDataMapper;
import com.ohaotian.abilityadmin.mapper.SystemCodeValueMapper;
import com.ohaotian.abilityadmin.mapper.SystemExtColumnMapper;
import com.ohaotian.abilityadmin.model.po.AbilityMeltPo;
import com.ohaotian.abilityadmin.model.po.DefinedExceptionPO;
import com.ohaotian.abilityadmin.model.po.RspCodePO;
import com.ohaotian.abilityadmin.model.po.SystemCodeTypePO;
import com.ohaotian.abilityadmin.model.po.SystemCodeValuePO;
import com.ohaotian.abilityadmin.model.po.SystemExtColumnPO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityExtBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityExtColumnBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityExtCustomBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityLogicBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityParamBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityPluginBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideDeployBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideDubboCustomBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideDubboCustomInputBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideHsfCustomBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideHsfCustomInputBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityProvideHttpCustomBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityToVegaBo;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityTransBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAbilityWsExtBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAppBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAppExtColumnBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAppSecretBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncAppSubscribeDeployBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncPluginBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncRateLimiterAbilityBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncRateLimiterSubscribeBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncRegionAddrBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncRegionBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncRegionCertificateBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncSubAbilityBO;
import com.ohaotian.abilityadmin.system.model.bo.SyncSystemExtColumnPO;
import com.ohaotian.abilityadmin.system.service.SyncDataService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.PluginRouteColumnMapper;
import com.ohaotian.plugin.mapper.PluginRouteExtMapper;
import com.ohaotian.plugin.mapper.PluginRouteMapper;
import com.ohaotian.plugin.service.IpSyncDataService;
import com.ohaotian.plugin.service.PrioritySyncDataService;
import com.ohaotian.plugin.service.impl.TokenSyncDataService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SyncDataServiceImpl
implements SyncDataService {
    private static final Logger log = LoggerFactory.getLogger(SyncDataServiceImpl.class);
    @Resource
    private SyncDataMapper syncDataMapper;
    @Resource
    private AbilityMeltMapper abilityMeltMapper;
    @Resource
    private SystemExtColumnMapper systemExtColumnMapper;
    @Resource
    private SystemCodeValueMapper systemCodeValueMapper;
    @Resource
    private AbilityDynamicService abilityDynamicService;
    @Resource
    private PluginAPI pluginAPI;
    @Resource
    private PluginRouteMapper pluginRouteMapper;
    @Resource
    private PluginRouteExtMapper pluginRouteExtMapper;
    @Resource
    private PluginRouteColumnMapper pluginRouteColumnMapper;
    @Resource
    private IpSyncDataService ipSyncDataService;
    @Resource
    private PrioritySyncDataService prioritySyncDataService;
    @Resource
    private TokenSyncDataService tokenSyncDataService;

    @Override
    public RspBO syncAllData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel"});
        Map<String, Object> map = null;
        String firstLevel = syncDataBO.getFirstLevel();
        if (FisrtLevelEnum.ABILITY.getCode().equals(firstLevel)) {
            map = this.qryAbility(syncDataBO, 0);
        } else if (FisrtLevelEnum.APP.getCode().equals(firstLevel)) {
            map = this.qryApp(syncDataBO, 0);
        } else if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel)) {
            RspBO tokenSyncData;
            RspBO prioritySyncData;
            map = this.qryPlugin(syncDataBO, 0);
            RspBO ipSyncData = this.ipSyncDataService.syncAllData(syncDataBO);
            if (!ObjectUtils.isEmpty((Object)ipSyncData)) {
                Map syncDataMap = (Map)ipSyncData.getData();
                map.putAll(syncDataMap);
            }
            if (!ObjectUtils.isEmpty((Object)(prioritySyncData = this.prioritySyncDataService.syncAllData(syncDataBO)))) {
                Map syncDataMap = (Map)prioritySyncData.getData();
                map.putAll(syncDataMap);
            }
            if (!ObjectUtils.isEmpty((Object)(tokenSyncData = this.tokenSyncDataService.syncAllData(syncDataBO)))) {
                Map syncDataMap = (Map)tokenSyncData.getData();
                map.putAll(syncDataMap);
            }
        } else if (FisrtLevelEnum.EXCEPTION.getCode().equals(firstLevel)) {
            map = this.qryException(syncDataBO);
        } else if (FisrtLevelEnum.SYSTEM_CODE.getCode().equals(firstLevel)) {
            map = this.qrySystemCode(syncDataBO);
        } else {
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.getMessage());
        }
        return RspBO.success(map);
    }

    @Override
    public RspBO syncIncrementData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel", "primaryId"});
        Map<String, Object> map = null;
        String firstLevel = syncDataBO.getFirstLevel();
        if (FisrtLevelEnum.ABILITY.getCode().equals(firstLevel)) {
            map = this.qryAbility(syncDataBO, 1);
        } else if (FisrtLevelEnum.APP.getCode().equals(firstLevel)) {
            map = this.qryApp(syncDataBO, 1);
        } else if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel)) {
            map = this.qryPlugin(syncDataBO, 1);
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)firstLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{firstLevel}).getMessage());
        }
        return RspBO.success(map);
    }

    private Map<String, Object> qryAbility(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (SecondLevelEnum.ABILITY_BASIC.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability", (Object)primaryId);
            }
            List<SyncAbilityBO> abilityBOList = this.syncDataMapper.queryAbility(syncDataBO);
            if (!ObjectUtil.isNull(abilityBOList)) {
                map.put("ability", abilityBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_to_vega");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_to_vega", (Object)primaryId);
            }
            List<SyncAbilityToVegaBo> abilityToVegaBoList = this.syncDataMapper.queryAbilityToVega(syncDataBO);
            if (!ObjectUtil.isNull(abilityToVegaBoList)) {
                map.put("ability_to_vega", abilityToVegaBoList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_melt");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_melt", (Object)primaryId);
            }
            List<AbilityMeltPo> abilityMeltList = this.abilityMeltMapper.selectAll(syncDataBO);
            if (!ObjectUtil.isNull(abilityMeltList)) {
                map.put("ability_melt", abilityMeltList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_ext_custom");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_ext_custom", (Object)primaryId);
            }
            List<SyncAbilityExtCustomBO> abilityExtCustomBOList = this.syncDataMapper.queryAbilityExtCustom(syncDataBO);
            if (!ObjectUtil.isNull(abilityExtCustomBOList)) {
                map.put("ability_ext_custom", abilityExtCustomBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_ext_column");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_ext_column", (Object)primaryId);
            }
            List<SyncAbilityExtColumnBO> abilityExtColumnBOList = this.syncDataMapper.queryAbilityExtColumn(syncDataBO);
            if (!ObjectUtil.isNull(abilityExtColumnBOList)) {
                map.put("ability_ext_column", abilityExtColumnBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_trans");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_trans", (Object)primaryId);
            }
            List<SyncAbilityTransBO> abilityTransBOList = this.syncDataMapper.queryAbilityTrans(syncDataBO);
            if (!ObjectUtil.isNull(abilityTransBOList)) {
                map.put("ability_trans", abilityTransBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"sub_ability");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"sub_ability", (Object)primaryId);
            }
            List<SyncSubAbilityBO> subAbilityBOList = this.syncDataMapper.querySubAbility(syncDataBO);
            if (!ObjectUtil.isNull(subAbilityBOList)) {
                map.put("sub_ability", subAbilityBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_dubbo_custom");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_dubbo_custom", (Object)primaryId);
            }
            List<SyncAbilityProvideDubboCustomBO> abilityProvideDubboCustomBOList = this.syncDataMapper.queryAbilityProvideDubboCustom(syncDataBO);
            if (!ObjectUtil.isNull(abilityProvideDubboCustomBOList)) {
                map.put("ability_provide_dubbo_custom", abilityProvideDubboCustomBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_dubbo_custom_input");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_dubbo_custom_input", (Object)primaryId);
            }
            List<SyncAbilityProvideDubboCustomInputBO> dubboCustomInputBOList = this.syncDataMapper.queryAbilityProvideDubboCustomInput(syncDataBO);
            if (!ObjectUtil.isNull(dubboCustomInputBOList)) {
                map.put("ability_provide_dubbo_custom_input", dubboCustomInputBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_hsf_custom");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_hsf_custom", (Object)primaryId);
            }
            List<SyncAbilityProvideHsfCustomBO> hsfCustomBOList = this.syncDataMapper.queryAbilityProvideHsfCustom(syncDataBO);
            if (!ObjectUtil.isNull(hsfCustomBOList)) {
                map.put("ability_provide_hsf_custom", hsfCustomBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_hsf_custom_input");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_hsf_custom_input", (Object)primaryId);
            }
            List<SyncAbilityProvideHsfCustomInputBO> hsfCustomInputBOList = this.syncDataMapper.queryAbilityProvideHsfCustomInput(syncDataBO);
            if (!ObjectUtil.isNull(hsfCustomBOList)) {
                map.put("ability_provide_hsf_custom_input", hsfCustomInputBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_http_custom");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_http_custom", (Object)primaryId);
            }
            List<SyncAbilityProvideHttpCustomBO> httpCustomBOList = this.syncDataMapper.queryAbilityProvideHttpCustom(syncDataBO);
            if (!ObjectUtil.isNull(httpCustomBOList)) {
                map.put("ability_provide_http_custom", httpCustomBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"rate_limiter_ability");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"rate_limiter_ability", (Object)primaryId);
            }
            List<SyncRateLimiterAbilityBO> rateLimiterAbilityBOList = this.syncDataMapper.queryRateLimiterAbility(syncDataBO);
            if (!ObjectUtil.isNull(rateLimiterAbilityBOList)) {
                map.put("rate_limiter_ability", rateLimiterAbilityBOList);
            }
        } else if (SecondLevelEnum.ABILITY_EXT.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_ext");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_ext", (Object)primaryId);
            }
            List<SyncAbilityExtBO> extBOList = this.syncDataMapper.queryAbilityExt(syncDataBO);
            if (!ObjectUtil.isNull(extBOList)) {
                map.put("ability_ext", extBOList);
            }
        } else if (SecondLevelEnum.ABILITY_LOGIC.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_logic");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_logic", (Object)primaryId);
            }
            List<SyncAbilityLogicBO> abilityLogicBOList = this.syncDataMapper.queryAbilityLogic(syncDataBO);
            if (!ObjectUtil.isNull(abilityLogicBOList)) {
                map.put("ability_logic", abilityLogicBOList);
            }
        } else if (SecondLevelEnum.ABILITY_PARAM.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_param");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_param", (Object)primaryId);
            }
            List<SyncAbilityParamBO> abilityParamBOS = this.syncDataMapper.queryAbilityParam(syncDataBO);
            if (!ObjectUtil.isNull(abilityParamBOS)) {
                map.put("ability_param", abilityParamBOS);
            }
        } else if (SecondLevelEnum.ABILITY_RELATION.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"app_subscribe_deploy");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"app_subscribe_deploy", (Object)primaryId);
            }
            List<SyncAppSubscribeDeployBO> subscribeDeployBOList = this.syncDataMapper.queryAppSubscribeDeploy(syncDataBO);
            if (!ObjectUtil.isNull(subscribeDeployBOList)) {
                map.put("app_subscribe_deploy", subscribeDeployBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"rate_limiter_subscribe");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"rate_limiter_subscribe", (Object)primaryId);
            }
            List<SyncRateLimiterSubscribeBO> rateLimiterSubscribeBOList = this.syncDataMapper.queryRateLimiterSubscribe(syncDataBO);
            if (!ObjectUtil.isNull(rateLimiterSubscribeBOList)) {
                map.put("rate_limiter_subscribe", rateLimiterSubscribeBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_provide_deploy");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_provide_deploy", (Object)primaryId);
            }
            List<SyncAbilityProvideDeployBO> provideDeployBOList = this.syncDataMapper.queryAbilityProvideDeploy(syncDataBO);
            if (!ObjectUtil.isNull(provideDeployBOList)) {
                map.put("ability_provide_deploy", provideDeployBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_plugin");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_plugin", (Object)primaryId);
            }
            List<SyncAbilityPluginBO> abilityPluginBOList = this.syncDataMapper.queryAbilityPluginDeploy(syncDataBO.getClusterId(), syncDataBO.getHirerId(), syncDataBO.getPrimaryId(), null);
            if (!ObjectUtil.isNull(abilityPluginBOList)) {
                map.put("ability_plugin", abilityPluginBOList);
            }
        } else if (SecondLevelEnum.ABILITY_WS_EXT.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"ability_ws_ext");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"ability_ws_ext", (Object)primaryId);
            }
            List<SyncAbilityWsExtBO> wsExtBOList = this.syncDataMapper.queryAbilityWsExt(syncDataBO);
            if (!ObjectUtil.isNull(wsExtBOList)) {
                map.put("ability_ws_ext", wsExtBOList);
            }
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)secondLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{secondLevel}).getMessage());
        }
        return map;
    }

    private Map<String, Object> qryApp(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (SecondLevelEnum.APP.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"app");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"app", (Object)primaryId);
            }
            List<SyncAppBO> appBOList = this.syncDataMapper.queryApp(syncDataBO);
            if (!ObjectUtil.isNull(appBOList)) {
                map.put("app", appBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"app_secret");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"app_secret", (Object)primaryId);
            }
            List<SyncAppSecretBO> syncAppSecretBOS = this.syncDataMapper.queryAppSecret(syncDataBO);
            if (!ObjectUtil.isNull(syncAppSecretBOS)) {
                map.put("app_secret", syncAppSecretBOS);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"app_ext_column");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"app_ext_column", (Object)primaryId);
            }
            List<SyncAppExtColumnBO> appExtColumnBOList = this.syncDataMapper.queryAppExtColumn(syncDataBO);
            if (!ObjectUtil.isNull(appExtColumnBOList)) {
                map.put("app_ext_column", appExtColumnBOList);
            }
        } else if (SecondLevelEnum.APP_REGION.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"region");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"region", (Object)primaryId);
            }
            List<SyncRegionBO> regionBOList = this.syncDataMapper.queryRegion(syncDataBO);
            if (!ObjectUtil.isNull(regionBOList)) {
                map.put("region", regionBOList);
            }
        } else if (SecondLevelEnum.APP_REGION_ADDR.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"region_addr");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"region_addr", (Object)primaryId);
            }
            List<SyncRegionAddrBO> regionAddrBOList = this.syncDataMapper.queryRegionAddr(syncDataBO);
            if (!ObjectUtil.isNull(regionAddrBOList)) {
                map.put("region_addr", regionAddrBOList);
            }
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"region_certificate");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"region_certificate", (Object)primaryId);
            }
            List<SyncRegionCertificateBO> syncRegionCertificateBOList = this.syncDataMapper.queryRegionCertificate(syncDataBO);
            if (!ObjectUtil.isNull(regionAddrBOList)) {
                map.put("region_certificate", syncRegionCertificateBOList);
            }
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)secondLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{secondLevel}).getMessage());
        }
        return map;
    }

    private Map<String, Object> qryPlugin(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (SecondLevelEnum.PLUGIN_PLUGIN.getCode().equals(secondLevel)) {
            if (type == 0) {
                log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"plugin");
            } else {
                log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)"plugin", (Object)primaryId);
            }
            List<SyncPluginBO> pluginBOList = this.syncDataMapper.queryPlugin(syncDataBO);
            if (!ObjectUtil.isNull(pluginBOList)) {
                map.put("plugin", pluginBOList);
            }
            List pluginIds = this.pluginAPI.getPluginIds(syncDataBO);
            List pluginRouteBOList = this.pluginRouteMapper.queryPluginRouteByPluginIds(pluginIds);
            List abilityPluginDeployIds = null;
            if (type == 1 || type == 0) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), null, syncDataBO.getPrimaryId());
            } else if (type == 2) {
                abilityPluginDeployIds = this.pluginAPI.getAbilityPluginDeployIds(syncDataBO.getClusterId(), syncDataBO.getHirerId(), syncDataBO.getPrimaryId(), null);
            }
            List syncPluginRouteExtBOList = new ArrayList();
            List syncPluginRouteColumnBOList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)abilityPluginDeployIds)) {
                syncPluginRouteExtBOList = this.pluginRouteExtMapper.queryPluginRouteExtByPluginIds(abilityPluginDeployIds);
                syncPluginRouteColumnBOList = this.pluginRouteColumnMapper.queryPluginRouteColumnByPluginIds(abilityPluginDeployIds);
            }
            if (!ObjectUtil.isNull((Object)pluginRouteBOList)) {
                map.put("plugin_route", pluginRouteBOList);
            }
            if (!ObjectUtil.isNull(syncPluginRouteExtBOList)) {
                map.put("plugin_route_ext", syncPluginRouteExtBOList);
            }
            if (!ObjectUtil.isNull(syncPluginRouteColumnBOList)) {
                map.put("plugin_route_column", syncPluginRouteColumnBOList);
            }
        } else if (SecondLevelEnum.PLUGIN_PLUGIN_EXT.getCode().equals(secondLevel)) {
            log.info("\u63d2\u4ef6\u7ed1\u5b9a\u6269\u5c55\u4fe1\u606f\uff0c\u4e0d\u505a\u4efb\u4f55\u5904\u7406");
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)secondLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{secondLevel}).getMessage());
        }
        return map;
    }

    private Map<String, Object> qrySystemCode(SyncDataReqBO syncDataBO) {
        HashMap map = Maps.newHashMap();
        String secondLevel = syncDataBO.getSecondLevel();
        if (SecondLevelEnum.SYSTEM_CODE.getCode().equals(secondLevel)) {
            log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"system_code_type");
            List<SystemCodeTypePO> systemCodeTypePOList = this.syncDataMapper.querySystemCodeType();
            if (!ObjectUtil.isNull(systemCodeTypePOList)) {
                map.put("system_code_type", systemCodeTypePOList);
            }
            log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"system_code_value");
            List<SystemCodeValuePO> systemCodeValuePOList = this.syncDataMapper.querySystemCodeValue();
            if (!ObjectUtil.isNull(systemCodeValuePOList)) {
                map.put("system_code_value", systemCodeValuePOList);
            }
            log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"defined_exception");
            List<DefinedExceptionPO> definedExceptionPOList = this.syncDataMapper.queryDefinedException();
            if (!ObjectUtil.isNull(definedExceptionPOList)) {
                map.put("defined_exception", definedExceptionPOList);
            }
            log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"system_ext_column");
            ArrayList syncSystemExtColumnPOList = Lists.newArrayList();
            List<SystemExtColumnPO> systemExtColumnPOList = this.systemExtColumnMapper.queryByCond(new SystemExtColumnPO());
            for (SystemExtColumnPO systemExtColumnPO : systemExtColumnPOList) {
                List<Map<String, String>> list;
                SyncSystemExtColumnPO syncSystemExtColumnPO;
                if (systemExtColumnPO.getColType() == 0) continue;
                if (systemExtColumnPO.getUpholdType() == 0) {
                    SystemCodeValuePO systemCodeValuePO = new SystemCodeValuePO();
                    systemCodeValuePO.setTypeCode(systemExtColumnPO.getColCode());
                    List<SystemCodeValuePO> valueList = this.systemCodeValueMapper.queryByCond(systemCodeValuePO);
                    if (CollectionUtils.isEmpty(valueList)) continue;
                    for (SystemCodeValuePO systemCodeValuePO2 : valueList) {
                        syncSystemExtColumnPO = new SyncSystemExtColumnPO();
                        syncSystemExtColumnPO.setColCode(systemExtColumnPO.getColCode());
                        syncSystemExtColumnPO.setColLabel(systemCodeValuePO2.getDicValue());
                        syncSystemExtColumnPO.setColValue(systemCodeValuePO2.getDicCode());
                        syncSystemExtColumnPOList.add(syncSystemExtColumnPO);
                    }
                    continue;
                }
                String url = systemExtColumnPO.getUrl();
                if (StringUtils.isEmpty((Object)url) || CollectionUtils.isEmpty(list = this.abilityDynamicService.doPost(url))) continue;
                for (Map map2 : list) {
                    syncSystemExtColumnPO = new SyncSystemExtColumnPO();
                    syncSystemExtColumnPO.setColCode(systemExtColumnPO.getColCode());
                    syncSystemExtColumnPO.setColLabel((String)map2.get("label"));
                    syncSystemExtColumnPO.setColValue((String)map2.get("value"));
                    syncSystemExtColumnPOList.add(syncSystemExtColumnPO);
                }
            }
            if (!ObjectUtil.isNull((Object)syncSystemExtColumnPOList)) {
                map.put("system_ext_column", syncSystemExtColumnPOList);
            }
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)secondLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{secondLevel}).getMessage());
        }
        return map;
    }

    private Map<String, Object> qryException(SyncDataReqBO syncDataBO) {
        HashMap map = Maps.newHashMap();
        String secondLevel = syncDataBO.getSecondLevel();
        if (SecondLevelEnum.EXCEPTION.getCode().equals(secondLevel)) {
            log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)"rsp_code");
            List<RspCodePO> rspCodePOList = this.syncDataMapper.queryRspCode();
            if (!ObjectUtil.isNull(rspCodePOList)) {
                map.put("rsp_code", rspCodePOList);
            }
        } else {
            log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)secondLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{secondLevel}).getMessage());
        }
        return map;
    }
}

