/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.app.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.abilityadmin.app.model.bo.AppExtColumnReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppProviderReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppProviderRspBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRegionBO;
import com.ohaotian.abilityadmin.app.model.bo.AppReqBO;
import com.ohaotian.abilityadmin.app.model.bo.AppReqModifyBO;
import com.ohaotian.abilityadmin.app.model.bo.AppRspBO;
import com.ohaotian.abilityadmin.app.service.AppService;
import com.ohaotian.abilityadmin.config.pubsub.PubSubMsgHandler;
import com.ohaotian.abilityadmin.mapper.AbilityAppMapper;
import com.ohaotian.abilityadmin.mapper.AppExtColumnMapper;
import com.ohaotian.abilityadmin.mapper.AppMapper;
import com.ohaotian.abilityadmin.mapper.AppRegionMapper;
import com.ohaotian.abilityadmin.mapper.AppSecretMapper;
import com.ohaotian.abilityadmin.mapper.ClusterMapper;
import com.ohaotian.abilityadmin.mapper.RegionAddrMapper;
import com.ohaotian.abilityadmin.mapper.RegionMapper;
import com.ohaotian.abilityadmin.model.po.AbilityAppPO;
import com.ohaotian.abilityadmin.model.po.AppExtColumnPO;
import com.ohaotian.abilityadmin.model.po.AppPO;
import com.ohaotian.abilityadmin.model.po.AppSecretPO;
import com.ohaotian.abilityadmin.model.po.ClusterPO;
import com.ohaotian.abilityadmin.model.po.RegionAddrPO;
import com.ohaotian.abilityadmin.model.po.RegionPO;
import com.ohaotian.abilityadmin.system.model.bo.AppForSelectRspBO;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.portalcommon.api.ClusterApi;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeMap;
import com.ohaotian.portalcommon.config.systemcode.SystemCodeValue;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.Constants;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.ModifyStatusBO;
import com.ohaotian.portalcommon.model.bo.OptionGenerRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.GetRandomPwd;
import com.ohaotian.portalcommon.util.Sha256SingUtils;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class AppServiceImpl
implements AppService {
    private static final Logger log = LogManager.getLogger(AppServiceImpl.class);
    @Resource
    private AuthorityService authorityService;
    @Resource
    private AppMapper appMapper;
    @Resource
    private AppRegionMapper appRegionMapper;
    @Resource
    private RegionMapper regionMapper;
    @Resource
    private RegionAddrMapper regionAddrMapper;
    @Resource
    private AbilityAppMapper abilityAppMapper;
    @Autowired
    private PubSubMsgHandler pubSubMsgHandler;
    @Resource
    ClusterMapper clusterMapper;
    @Resource
    private ClusterApi clusterApi;
    @Resource
    private AppSecretMapper appSecretMapper;
    @Resource
    private AppExtColumnMapper appExtColumnMapper;

    @Override
    public RspBO<RspPage<AppRspBO>> qryAppListPageByCond(AppReqBO appReqBO) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        appReqBO.setHirerId(tenantId);
        log.debug("AppServiceImpl.qryAppListPageByCond:{}", (Object)appReqBO);
        if (!StringUtils.isEmpty((Object)appReqBO.getAppName())) {
            appReqBO.setAppName("%" + appReqBO.getAppName() + "%");
        }
        if (!StringUtils.isEmpty((Object)appReqBO.getAppCode())) {
            appReqBO.setAppCode("%" + appReqBO.getAppCode() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appReqBO.getSortOrder())) {
                order.append(" ").append(appReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = appReqBO.getPageNo();
        int pageSize = appReqBO.getPageSize();
        Page page = !StringUtils.isEmpty((Object)order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<AppRspBO> appRspBOList = this.appMapper.queryListByBO(appReqBO);
        appRspBOList.stream().map(bo -> {
            SystemCodeValue attentStatus = SystemCodeMap.getSystemCode((String)"1000", (String)(bo.getAttendStatus() + ""));
            if (attentStatus != null) {
                bo.setAttendStatusName(attentStatus.getDicValue());
            }
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appRspBOList, Long.valueOf(page.getTotal()));
        rspPage.getRows().forEach(appRspBO -> {
            List<AppRegionBO> appRegionBoList = this.appRegionMapper.queryByAppId(appRspBO.getAppId());
            appRspBO.setRegionNum(appRegionBoList.size());
            LinkedHashMap<String, List<JSONObject>> regionList = new LinkedHashMap<String, List<JSONObject>>();
            appRegionBoList.stream().collect(Collectors.groupingBy(AppRegionBO::getClusterName, Collectors.toList())).forEach((clusterName, regionMapOneList) -> {
                Map<Object, Object> regionAddrMap;
                LinkedList regionMap = new LinkedList();
                List<String> regionAddrIdsList = regionMapOneList.stream().map(AppRegionBO::getRegionAddrIds).collect(Collectors.toList());
                HashSet regionAddrIds = new HashSet();
                regionAddrIdsList.forEach(regionAddrIdsStr -> {
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)regionAddrIdsStr)) {
                        String[] strIds = regionAddrIdsStr.split(",");
                        regionAddrIds.addAll(Arrays.stream(strIds).map(Long::parseLong).collect(Collectors.toSet()));
                    }
                });
                if (!CollectionUtils.isEmpty(regionAddrIds)) {
                    List<RegionAddrPO> regionAddrPoList = this.regionAddrMapper.queryByRegionAddrIds(new ArrayList<Long>(regionAddrIds));
                    regionAddrMap = regionAddrPoList.stream().collect(Collectors.toMap(RegionAddrPO::getRegionAddrId, regionAddr -> regionAddr));
                } else {
                    regionAddrMap = new HashMap();
                }
                regionMapOneList.forEach(regionOne -> {
                    JSONObject data = new JSONObject();
                    data.put("regionName", (Object)regionOne.getRegionName());
                    data.put("protocol", (Object)(Constants.Http.HTTPS_INT.equals(regionOne.getCallProtocol()) ? "https" : "http"));
                    data.put("regionDeployNum", (Object)regionOne.getRegionDeployNum());
                    LinkedList regionAddressList = new LinkedList();
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)regionOne.getRegionAddrIds())) {
                        Arrays.stream(regionOne.getRegionAddrIds().split(",")).forEach(regionAddrId -> {
                            RegionAddrPO addrPo = (RegionAddrPO)regionAddrMap.get(Long.parseLong(regionAddrId));
                            regionAddressList.add(ObjectUtils.isEmpty((Object)addrPo.getPort()) ? addrPo.getIp() : addrPo.getIp() + ":" + addrPo.getPort());
                        });
                    }
                    data.put("regionAddressList", (Object)String.join((CharSequence)";", regionAddressList));
                    regionMap.add(data);
                });
                regionList.put((String)clusterName, regionMap);
            });
            appRspBO.setRegionList(regionList);
        });
        return RspBO.success((Object)rspPage);
    }

    @Override
    public RspBO<AppRspBO> qryAppByAppId(Long appId) throws ZTBusinessException {
        SystemCodeValue attentStatus;
        log.debug("AppServiceImpl.qryAppByAppId:{}", (Object)appId);
        if (StringUtils.isEmpty((Object)appId)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        AppPO appPO = this.appMapper.queryByAppId(appId);
        AppRspBO appRspBO = (AppRspBO)BeanMapper.map((Object)appPO, AppRspBO.class);
        if (!StringUtils.isEmpty((Object)appRspBO.getCreateUserId())) {
            appRspBO.setCreateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(appRspBO.getCreateUserId())).getName());
        }
        if (!StringUtils.isEmpty((Object)appRspBO.getUpdateUserId())) {
            appRspBO.setUpdateUserName(this.authorityService.getUserInfoByUserId(String.valueOf(appRspBO.getUpdateUserId())).getName());
        }
        if ((attentStatus = SystemCodeMap.getSystemCode((String)"1000", (String)(appRspBO.getAttendStatus() + ""))) != null) {
            appRspBO.setAttendStatusName(attentStatus.getDicValue());
        }
        return RspBO.success((Object)appRspBO);
    }

    @Override
    public RspBO<Boolean> appRegiste(AppReqBO appReqBO) throws ZTBusinessException {
        ValidBatchUtils.isNotEmpty((Object)appReqBO, (String[])new String[]{"appName", "appCode", "appContact", "appPhone", "isProvider"});
        if (StringUtils.isEmpty((Object)appReqBO.getAppPhone()) && StrUtil.isPhone((String)appReqBO.getAppPhone())) {
            throw new ZTBusinessException(CodeMsg.APP_ARG_ERROR.getMessage());
        }
        try {
            AppPO appPO = (AppPO)BeanMapper.map((Object)appReqBO, AppPO.class);
            appPO.setHirerId(Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId()));
            appPO.setAttendStatus(1);
            appPO.setCheckinTime(new Date());
            appPO.setCreateUserId(Long.parseLong(UserHolder.getUserId()));
            appPO.setCreateTime(new Date());
            appPO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
            appPO.setUpdateTime(new Date());
            this.appMapper.insertSelective(appPO);
            if (appReqBO.getAppExtColumnReqBO() != null) {
                AppExtColumnPO appExtColumnPO = (AppExtColumnPO)BeanMapper.map((Object)appReqBO.getAppExtColumnReqBO(), AppExtColumnPO.class);
                appExtColumnPO.setAppId(appPO.getAppId());
                this.appExtColumnMapper.insertSelective(appExtColumnPO);
            }
            List clusterBOS = this.clusterApi.qryAllCluster();
            clusterBOS.forEach(params -> {
                String sercret = GetRandomPwd.getRandomPwd((int)32);
                AppSecretPO appSecretPO = new AppSecretPO();
                appSecretPO.setAppId(appPO.getAppId());
                appSecretPO.setClusterId(params.getClusterId());
                appSecretPO.setAppSecret(sercret);
                appSecretPO.setAppCode(appPO.getAppCode());
                try {
                    String remark = appReqBO.getRemark();
                    int size = 0;
                    if (remark.contains("RSA1024")) {
                        size = 1024;
                    } else if (remark.contains("RSA2048")) {
                        size = 2048;
                    }
                    if (size != 0) {
                        Map keys = Sha256SingUtils.genKeyPair((int)size);
                        appSecretPO.setPublicKey((String)keys.get("RSAPublicKey"));
                        appSecretPO.setPrivateKey((String)keys.get("RSAPrivateKey"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.appSecretMapper.insertDynamic(appSecretPO);
            });
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Override
    public RspBO<Boolean> updateAttendIn(List<Long> list) throws ZTBusinessException {
        log.debug("AppServiceImpl.updateAttendIn:{}", list);
        if (CollectionUtils.isEmpty(list)) {
            throw new ZTBusinessException(CodeMsg.APP_ARG_ERROR.getMessage());
        }
        try {
            List<AppPO> listPO = list.stream().map(bo -> {
                AppPO appPO = new AppPO();
                appPO.setAppId((Long)bo);
                appPO.setAttendStatus(Constants.AttendStatus.SIGN_IN);
                appPO.setCheckinTime(new Date());
                appPO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
                appPO.setUpdateTime(new Date());
                return appPO;
            }).collect(Collectors.toList());
            this.appMapper.updateAttendByAppId(listPO);
            this.notifyModify(list, 1);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AppServiceImpl.updateAttendIn:{}", (Object)CodeMsg.APP_SIGNIN_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.APP_SIGNIN_ERROR.getMessage());
        }
    }

    @Override
    public RspBO<Boolean> updateAttendOut(List<Long> list) throws ZTBusinessException {
        log.debug("AppServiceImpl.updateAttendOut:{}", list);
        if (CollectionUtils.isEmpty(list)) {
            throw new ZTBusinessException(CodeMsg.PHONE_ERROR.getMessage());
        }
        try {
            List<AppPO> listPO = list.stream().map(bo -> {
                AppPO appPO = new AppPO();
                appPO.setAppId((Long)bo);
                appPO.setAttendStatus(Constants.AttendStatus.SIGN_OUT);
                appPO.setCheckoutTime(new Date());
                appPO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
                appPO.setUpdateTime(new Date());
                return appPO;
            }).collect(Collectors.toList());
            this.appMapper.updateAttendByAppId(listPO);
            this.notifyModify(list, 0);
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AppServiceImpl.updateAttendOut:{}", (Object)CodeMsg.APP_SIGNOUT_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.APP_SIGNOUT_ERROR.getMessage());
        }
    }

    @Override
    public RspBO<Boolean> appUpdate(AppReqModifyBO appReqBO) throws ZTBusinessException {
        ValidBatchUtils.isNotEmpty((Object)appReqBO, (String[])new String[]{"appId", "appName", "appCode", "appContact", "appPhone", "isProvider"});
        if (StringUtils.isEmpty((Object)appReqBO.getAppPhone()) && StrUtil.isPhone((String)appReqBO.getAppPhone())) {
            throw new ZTBusinessException(CodeMsg.PHONE_ERROR.getMessage());
        }
        try {
            AppPO appPO = (AppPO)BeanMapper.map((Object)appReqBO, AppPO.class);
            appPO.setHirerId(Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId()));
            appPO.setUpdateUserId(Long.parseLong(UserHolder.getUserId()));
            appPO.setUpdateTime(new Date());
            this.appMapper.updateAppByAppId(appPO);
            AppExtColumnReqBO appExtColumnReqBO = appReqBO.getAppExtColumnReqBO();
            if (appExtColumnReqBO != null) {
                AppExtColumnPO appExtColumnPO = (AppExtColumnPO)BeanMapper.map((Object)appExtColumnReqBO, AppExtColumnPO.class);
                appExtColumnPO.setAppId(appPO.getAppId());
                this.appExtColumnMapper.updateAppExtColumnByAppId(appExtColumnPO);
            }
            List clusterBOS = this.clusterApi.qryAllCluster();
            clusterBOS.forEach(params -> {
                AppSecretPO appSecretPO = new AppSecretPO();
                appSecretPO.setAppId(appPO.getAppId());
                appSecretPO.setClusterId(params.getClusterId());
                AppSecretPO tmp = this.appSecretMapper.selectByAppIdAndClusterId(appPO.getAppId(), params.getClusterId());
                try {
                    String remark = appReqBO.getRemark();
                    int size = 0;
                    if (remark.contains("RSA1024")) {
                        size = 1024;
                    } else if (remark.contains("RSA2048")) {
                        size = 2048;
                    }
                    if (size != 0 && (ObjectUtils.isEmpty((Object)tmp.getPublicKey()) || ObjectUtils.isEmpty((Object)tmp.getPrivateKey()))) {
                        Map keys = Sha256SingUtils.genKeyPair((int)size);
                        appSecretPO.setPublicKey((String)keys.get("RSAPublicKey"));
                        appSecretPO.setPrivateKey((String)keys.get("RSAPrivateKey"));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.appSecretMapper.update(appSecretPO);
            });
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={ZTBusinessException.class})
    public RspBO<Boolean> deleteApp(Long appId) throws ZTBusinessException {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        log.debug("AppServiceImpl.deleteApp:{}", (Object)appId);
        if (StringUtils.isEmpty((Object)appId)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        AppPO appPO = this.appMapper.queryByAppId(appId);
        AbilityAppPO abilityAppPO = new AbilityAppPO();
        abilityAppPO.setHirerId(tenantId);
        abilityAppPO.setAppCode(appPO.getAppCode());
        List<AbilityAppPO> abilityAppPOS = this.abilityAppMapper.queryByCond(abilityAppPO);
        if (abilityAppPOS != null && abilityAppPOS.size() > 0) {
            String collect = abilityAppPOS.stream().map(a -> {
                if (a.getRelationType() > 0) {
                    return "\u5b58\u5728\u63d0\u4f9b\u80fd\u529b\u5173\u7cfb-->" + a.getAbilityEname() + "_" + a.getAbilityVersion();
                }
                return "\u5b58\u5728\u8ba2\u8d2d\u80fd\u529b\u5173\u7cfb-->" + a.getAbilityEname() + "_" + a.getAbilityVersion();
            }).collect(Collectors.joining(","));
            throw new ZTBusinessException("\u5e94\u7528\u4e0d\u53ef\u5220\u9664\uff1a\u3010" + collect + "\u3011\u8bf7\u5148\u89e3\u9664\u7ed1\u5b9a\u5173\u7cfb");
        }
        try {
            List<AppRegionBO> appRegionPOList = this.appRegionMapper.queryByAppId(appId);
            if (CollectionUtils.isEmpty(appRegionPOList)) {
                log.warn("\u5e94\u7528\u5206\u533a\u5173\u7cfb\u8868\u4e0d\u5b58\u5728\u76f8\u5173\u8bb0\u5f55");
            } else {
                List<Long> regionIds = appRegionPOList.stream().map(po -> po.getRegionId()).distinct().collect(Collectors.toList());
                List<Long> appRegionIds = appRegionPOList.stream().map(po -> po.getAppRegionId()).collect(Collectors.toList());
                this.regionAddrMapper.deleteRegionAddrByRegionIds(regionIds);
                this.regionMapper.deleteRegionByIds(regionIds);
                this.appRegionMapper.deleteAppRegionByIds(appRegionIds);
            }
            this.appSecretMapper.deleteByAppId(appId);
            this.appExtColumnMapper.deleteAppExtColumnByAppId(appId);
            this.appMapper.deleteAppByAppId(appId);
            if (!CollectionUtils.isEmpty(appRegionPOList)) {
                this.abilityAppMapper.deleteAbilityAppByAppCodeAndHirerId(appRegionPOList.get(0).getAppCode(), appRegionPOList.get(0).getHirerId());
            }
            return RspBO.success((Object)true);
        }
        catch (Exception e) {
            log.error("AppServiceImpl.deleteApp:{}", (Object)CodeMsg.APP_DELETE_ERROR.getMessage(), (Object)e);
            throw new ZTBusinessException(CodeMsg.APP_DELETE_ERROR.getMessage());
        }
    }

    @Override
    public RspBO<RspPage<AppProviderRspBO>> qryAppProviderPageByCond(AppProviderReqBO appProviderReqBO) throws ZTBusinessException {
        log.debug("AppServiceImpl.qryAppProviderPageByCond:{}", (Object)appProviderReqBO);
        if (StringUtils.isEmpty((Object)appProviderReqBO.getAppId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        if (!StringUtils.isEmpty((Object)appProviderReqBO.getAbilityName())) {
            appProviderReqBO.setAbilityName("%" + appProviderReqBO.getAbilityName() + "%");
        }
        if (!StringUtils.isEmpty((Object)appProviderReqBO.getAbilityEname())) {
            appProviderReqBO.setAbilityEname("%" + appProviderReqBO.getAbilityEname() + "%");
        }
        if (!StringUtils.isEmpty((Object)appProviderReqBO.getInputProtocal())) {
            appProviderReqBO.setInputProtocal("%" + appProviderReqBO.getInputProtocal() + "%");
        }
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)appProviderReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)appProviderReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)appProviderReqBO.getSortOrder())) {
                order.append(" ").append(appProviderReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        int pageNo = appProviderReqBO.getPageNo();
        int pageSize = appProviderReqBO.getPageSize();
        appProviderReqBO.setHirerId(Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId()));
        Page page = !Objects.isNull(order) ? PageMethod.startPage((int)pageNo, (int)pageSize, (String)order.toString()) : PageMethod.startPage((int)pageNo, (int)pageSize);
        List<AppProviderRspBO> appProviderRspBOList = this.appMapper.queryAppProviderByCond(appProviderReqBO);
        appProviderRspBOList.stream().map(bo -> {
            ClusterPO clusterPO;
            SystemCodeValue attentStatus = SystemCodeMap.getSystemCode((String)"1000", (String)(bo.getAttendStatus() + ""));
            if (attentStatus != null) {
                bo.setAttendStatusName(attentStatus.getDicValue());
            }
            if ((clusterPO = this.clusterMapper.queryByClusterId(bo.getClusterId())) != null) {
                bo.setClusterName(clusterPO.getClusterName());
            }
            return bo;
        }).collect(Collectors.toList());
        RspPage rspPage = new RspPage(Integer.valueOf(pageSize), Integer.valueOf(pageNo), appProviderRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public List<AppForSelectRspBO> queryAllApp() {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AppPO appPO = new AppPO();
        appPO.setHirerId(tenantId);
        ValidBatchUtils.isNotEmpty((Object)appPO, (String[])new String[]{"hirerId"});
        List<AppRspBO> appPOList = this.appMapper.queryByCond(appPO);
        List<AppForSelectRspBO> appForSelectRspBOList = appPOList.stream().map(a -> new AppForSelectRspBO(a.getAppName(), a.getAppCode())).collect(Collectors.toList());
        return appForSelectRspBOList;
    }

    @Override
    public List<JSONObject> queryAllProvideApp() {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AppPO appPO = new AppPO();
        appPO.setHirerId(tenantId);
        ValidBatchUtils.isNotEmpty((Object)appPO, (String[])new String[]{"hirerId"});
        List<AppRspBO> appPOList = this.appMapper.queryByCond(appPO);
        List<AppRspBO> appForSelectRspBOList = appPOList.stream().filter(a -> Constants.ProvideType.PROVIDE_TYPE_TRUE.equals(a.getIsProvider())).collect(Collectors.toList());
        LinkedList<JSONObject> appRspBoList = new LinkedList<JSONObject>();
        appForSelectRspBOList.forEach(appRspBo -> {
            JSONObject rspBo = new JSONObject();
            rspBo.put("value", (Object)appRspBo.getAppId());
            rspBo.put("label", (Object)appRspBo.getAppName());
            rspBo.put("code", (Object)appRspBo.getAppCode());
            appRspBoList.add(rspBo);
        });
        return appRspBoList;
    }

    @Override
    public List<OptionGenerRspBO<String, String>> appProvideListWithCode() {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AppPO appPO = new AppPO();
        appPO.setHirerId(tenantId);
        ValidBatchUtils.isNotEmpty((Object)appPO, (String[])new String[]{"hirerId"});
        List<AppRspBO> appPOList = this.appMapper.queryByCond(appPO);
        List<OptionGenerRspBO<String, String>> appForSelectRspBOList = appPOList.stream().filter(a -> Constants.ProvideType.PROVIDE_TYPE_TRUE.equals(a.getIsProvider())).map(a -> new OptionGenerRspBO((Serializable)((Object)a.getAppName()), (Serializable)((Object)a.getAppCode()))).collect(Collectors.toList());
        return appForSelectRspBOList;
    }

    @Override
    public RspBO<Boolean> checkRegionCode(String regionCode) throws ZTBusinessException {
        if (StringUtils.isEmpty((Object)regionCode)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        RegionPO po = new RegionPO();
        po.setRegionCode(regionCode);
        RegionPO region = this.regionMapper.queryLimitOne(po);
        if (region == null) {
            return RspBO.success((Object)true);
        }
        return RspBO.success((Object)false);
    }

    @Override
    public RspBO<Boolean> checkAppCode(Long appId, String appCode) throws ZTBusinessException {
        if (StringUtils.isEmpty((Object)appCode)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        Long hirerId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AppPO app = null;
        if (appId != null) {
            app = this.appMapper.queryByAppId(appId);
            if (app == null) {
                throw new ZTBusinessException(CodeMsg.APP_ID_ERROR.getMessage());
            }
            app = this.appMapper.checkAppCode(hirerId, app.getAppCode(), appCode);
        } else {
            app = this.appMapper.checkAppCode(hirerId, null, appCode);
        }
        if (app == null) {
            return RspBO.success((Object)true);
        }
        return RspBO.success((Object)false);
    }

    @Override
    public RspBO<Boolean> checkAppName(Long appId, String appName) throws ZTBusinessException {
        if (StringUtils.isEmpty((Object)appName)) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        Long hirerId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        AppPO app = null;
        if (appId != null) {
            app = this.appMapper.queryByAppId(appId);
            if (app == null) {
                throw new ZTBusinessException(CodeMsg.APP_ID_ERROR.getMessage());
            }
            app = this.appMapper.checkAppName(hirerId, app.getAppName(), appName);
        } else {
            app = this.appMapper.checkAppName(hirerId, null, appName);
        }
        if (app == null) {
            return RspBO.success((Object)true);
        }
        return RspBO.success((Object)false);
    }

    private void notifyModify(List<Long> list, int status) {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        ModifyStatusBO modifyStatusBO = new ModifyStatusBO();
        modifyStatusBO.setHirerId(tenantId);
        modifyStatusBO.setFirstLevel(FisrtLevelEnum.APP.getCode());
        modifyStatusBO.setSecondLevel(SecondLevelEnum.APP.getCode());
        modifyStatusBO.setPrimaryIds(list);
        modifyStatusBO.setStatus(Integer.valueOf(status));
        this.pubSubMsgHandler.abilityStatus(modifyStatusBO, "CHECK_MODIFY");
    }

    @Override
    public RspBO qryAppProvideByTenantId() {
        Long tenantId = Long.parseLong(this.authorityService.getUserInfoByUserId(UserHolder.getUserId()).getTenantId());
        this.appMapper.queryAllApp();
        List<AppPO> appPOS = this.appMapper.qryAppProvideByTenantId(tenantId);
        List appForSelectRspBOList = appPOS.stream().map(a -> new AppForSelectRspBO(a.getAppName(), a.getAppId().toString())).collect(Collectors.toList());
        return RspBO.success(appForSelectRspBOList);
    }
}

