/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityadmin.ability.service.postman;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.ohaotian.abilityadmin.ability.model.bo.postman.AbilityModel;
import com.ohaotian.abilityadmin.ability.model.bo.postman.PostmanCollection;
import com.ohaotian.abilityadmin.ability.model.bo.postman.PostmanItem;
import com.ohaotian.abilityadmin.ability.model.bo.postman.PostmanQuery;
import com.ohaotian.abilityadmin.ability.service.postman.FactoryForSchema;
import com.ohaotian.abilityadmin.ability.service.postman.GenerateSchemaService;
import com.ohaotian.atp.base.util.GetFileContentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class ParseAbilityList {
    private static final Logger log = LoggerFactory.getLogger(ParseAbilityList.class);
    private static final String GET = "GET";
    private static final String POST = "POST";
    private List<AbilityModel> list = new ArrayList<AbilityModel>();

    public void addAbility(AbilityModel abilityModel) {
        this.list.add(abilityModel);
    }

    public List<AbilityModel> getAbilityList() {
        return this.list;
    }

    public void parsePostMan(PostmanItem postmanItem) {
        if (postmanItem.getRequest() != null) {
            try {
                AbilityModel abilityModel = new AbilityModel();
                abilityModel.setFlag(true);
                abilityModel.setAbilityVersion("v1");
                if (GET.equalsIgnoreCase(postmanItem.getRequest().getMethod())) {
                    this.paresGet(postmanItem, abilityModel);
                } else if (POST.equalsIgnoreCase(postmanItem.getRequest().getMethod())) {
                    this.parePost(postmanItem, abilityModel);
                } else {
                    abilityModel.setError("\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301\uff01\uff1a" + postmanItem.getRequest().getMethod());
                }
                if (!abilityModel.getFlag().booleanValue()) {
                    abilityModel.paresMsg();
                }
            }
            catch (Exception e) {
                this.pareException(postmanItem, e);
            }
        }
        if (postmanItem.getItems().size() > 0) {
            postmanItem.getItems().forEach(a -> this.parsePostMan((PostmanItem)a));
        }
    }

    private void pareException(PostmanItem postmanItem, Exception e) {
        log.error("\u670d\u52a1\u90e8\u7f72\u5931\u8d25\uff1a", (Throwable)e);
        AbilityModel abilityModel = new AbilityModel();
        abilityModel.setAbilityName(postmanItem.getName());
        abilityModel.setFlag(false);
        abilityModel.setMsg(e.getMessage());
        this.addAbility(abilityModel);
    }

    private void parePost(PostmanItem postmanItem, AbilityModel abilityModel) throws JsonProcessingException {
        GenerateSchemaService strategy = FactoryForSchema.getStrategy(postmanItem.getRequest().getBody().getMode());
        abilityModel.setOutputTransProtocal(POST);
        abilityModel.setMode(postmanItem.getRequest().getBody().getMode());
        strategy.invokGeenerateSchema(abilityModel, postmanItem);
        abilityModel.setAbilityName(postmanItem.getName());
        this.generateUrl(abilityModel, postmanItem);
        abilityModel.setRemark(postmanItem.getRequest().getDescription());
        this.addAbility(abilityModel);
    }

    private void paresGet(PostmanItem postmanItem, AbilityModel abilityModel) throws JsonProcessingException {
        List<PostmanQuery> queries = postmanItem.getRequest().getUrl().getQueries();
        abilityModel.setOutputTransProtocal(GET);
        if (queries.size() < 1) {
            log.error("\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5f02\u5e38");
            abilityModel.setError("\u80fd\u529b\u5e73\u53f0\u6682\u65f6\u4e0d\u652f\u6301\u65e0\u53c2get\u8bf7\u6c42");
        } else {
            HashMap map = new HashMap();
            JsonMapper jsonMapper = new JsonMapper();
            queries.forEach(a -> map.put(a.getKey(), a.getValue()));
            abilityModel.setReqJsonschema(jsonMapper.writeValueAsString(map));
            ClassPathResource classPathResource = new ClassPathResource("schema/defaultResponse.json");
            String fileContent = GetFileContentUtil.getFileContent((Resource)classPathResource);
            abilityModel.setRspJsonschema(fileContent);
        }
    }

    public void parsePostmanCollection(PostmanCollection postmanCollection) {
        postmanCollection.getItems().forEach(a -> this.parsePostMan((PostmanItem)a));
    }

    private void generateUrl(AbilityModel abilityModel, PostmanItem postmanItem) {
        String raw = postmanItem.getRequest().getUrl().getRaw();
        if (raw.contains("?")) {
            System.out.println();
            raw = raw.substring(0, raw.indexOf("?"));
        }
        if (raw.startsWith("${url}")) {
            String replace = raw.replace("${url}", "");
            this.generatePath(abilityModel, replace);
        } else if (raw.startsWith("http:")) {
            String replace = raw.replace("http://", "");
            this.generatePath(abilityModel, replace);
        } else if (raw.startsWith("https:")) {
            String replace = raw.replace("https://", "");
            this.generatePath(abilityModel, replace);
        } else {
            abilityModel.setError("\u670d\u52a1\u5730\u5740\u9519\u8bef\uff1a" + raw);
        }
    }

    private void generatePath(AbilityModel abilityModel, String replace) {
        abilityModel.setAbilityEname(Arrays.asList(replace.split("/")).stream().skip(1L).collect(Collectors.joining("_")));
        abilityModel.setEprPath(Arrays.asList(replace.split("/")).stream().skip(1L).collect(Collectors.joining("/", "/", "")));
    }
}

