/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.portalcommon.helper;

import com.ohaotian.portalcommon.util.SampleXmlUtil;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public abstract class XmlHelper {
    private static final String PRETTY_PRINT_STYLESHEET = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'  xmlns:xalan='http://xml.apache.org/xslt'  exclude-result-prefixes='xalan'>  <xsl:output method='xml' indent='yes' xalan:indent-amount='4'/>  <xsl:strip-space elements='*'/>  <xsl:template match='/'>    <xsl:apply-templates/>  </xsl:template>  <xsl:template match='node() | @*'>        <xsl:copy>          <xsl:apply-templates select='node() | @*'/>        </xsl:copy>  </xsl:template></xsl:stylesheet>";

    protected static String getXmlTemplate(String root, XmlObject[] schemas) throws Exception {
        if (schemas == null || schemas.length == 0) {
            // empty if block
        }
        SchemaTypeSystem sts = null;
        XmlOptions compileOptions = new XmlOptions();
        try {
            sts = XmlBeans.compileXsd((XmlObject[])schemas, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), (XmlOptions)compileOptions);
        }
        catch (Exception exception) {
            // empty catch block
        }
        assert (sts != null);
        SchemaType[] globalElems = sts.documentTypes();
        HashMap<String, SchemaType> schemaTypeMapping = new HashMap<String, SchemaType>(globalElems.length);
        for (SchemaType globalElem : globalElems) {
            schemaTypeMapping.put(globalElem.getDocumentElementName().getLocalPart(), globalElem);
        }
        return SampleXmlUtil.createSampleForType((SchemaType)schemaTypeMapping.get(root));
    }

    public static String xmlDumbPrettify(String str) {
        try {
            StringWriter sw = new StringWriter(str.length() * 2);
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setErrorListener(new ErrorListener(){

                @Override
                public void warning(TransformerException exception) throws TransformerException {
                }

                @Override
                public void error(TransformerException exception) throws TransformerException {
                }

                @Override
                public void fatalError(TransformerException exception) throws TransformerException {
                }
            });
            transformer.transform(new StreamSource(new StringReader(str)), new StreamResult(sw));
            return sw.getBuffer().length() != 0 ? sw.toString() : str;
        }
        catch (Throwable t) {
            return str;
        }
    }

    public static String parseXmlByMapperFile(String root, File file) throws Exception {
        XmlObject[] schemas = new XmlObject[]{XmlObject.Factory.parse((File)file, (XmlOptions)new XmlOptions().setLoadLineNumbers().setLoadMessageDigest())};
        return XmlHelper.xmlDumbPrettify(XmlHelper.getXmlTemplate(root, schemas));
    }
}

