/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.constant;

import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConstantBaseVersion {
    @Value(value="${ability.version:}")
    private String version;
    private String MASTER_NAME;
    private String WEB_NODES;
    private String WEB_NODES_HEARTBEAT;
    private String ATP;
    private String ABILITY_PLATFORM_ERROR;
    @Value(value="${redis.hashTags:false}")
    private Boolean hashTags;

    @Bean
    @PostConstruct
    public void initVersion() {
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            this.MASTER_NAME = "atp-admin-master-node-" + this.version;
            this.WEB_NODES = "atp-web-heartbeat-monitor-" + this.version;
            this.WEB_NODES_HEARTBEAT = "{atp-node-web-heartbeat}-" + this.version + "-";
            if (Boolean.FALSE.equals(this.hashTags)) {
                this.WEB_NODES_HEARTBEAT = this.WEB_NODES_HEARTBEAT.replace("{", "").replace("}", "");
            }
            this.ABILITY_PLATFORM_ERROR = "oap-error-" + this.version + "-";
            this.ATP = "atp-" + this.version + "-";
        } else {
            this.MASTER_NAME = "atp-admin-master-node";
            this.WEB_NODES = "atp-web-heartbeat-monitor";
            this.WEB_NODES_HEARTBEAT = "{atp-node-web-heartbeat}-";
            if (Boolean.FALSE.equals(this.hashTags)) {
                this.WEB_NODES_HEARTBEAT = this.WEB_NODES_HEARTBEAT.replace("{", "").replace("}", "");
            }
            this.ABILITY_PLATFORM_ERROR = "oap-error-";
            this.ATP = "atp-";
        }
    }

    public String getVersion() {
        return this.version;
    }

    public String getMASTER_NAME() {
        return this.MASTER_NAME;
    }

    public String getWEB_NODES() {
        return this.WEB_NODES;
    }

    public String getWEB_NODES_HEARTBEAT() {
        return this.WEB_NODES_HEARTBEAT;
    }

    public String getATP() {
        return this.ATP;
    }

    public String getABILITY_PLATFORM_ERROR() {
        return this.ABILITY_PLATFORM_ERROR;
    }

    public Boolean getHashTags() {
        return this.hashTags;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMASTER_NAME(String MASTER_NAME) {
        this.MASTER_NAME = MASTER_NAME;
    }

    public void setWEB_NODES(String WEB_NODES) {
        this.WEB_NODES = WEB_NODES;
    }

    public void setWEB_NODES_HEARTBEAT(String WEB_NODES_HEARTBEAT) {
        this.WEB_NODES_HEARTBEAT = WEB_NODES_HEARTBEAT;
    }

    public void setATP(String ATP) {
        this.ATP = ATP;
    }

    public void setABILITY_PLATFORM_ERROR(String ABILITY_PLATFORM_ERROR) {
        this.ABILITY_PLATFORM_ERROR = ABILITY_PLATFORM_ERROR;
    }

    public void setHashTags(Boolean hashTags) {
        this.hashTags = hashTags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConstantBaseVersion)) {
            return false;
        }
        ConstantBaseVersion other = (ConstantBaseVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$MASTER_NAME = this.getMASTER_NAME();
        String other$MASTER_NAME = other.getMASTER_NAME();
        if (this$MASTER_NAME == null ? other$MASTER_NAME != null : !this$MASTER_NAME.equals(other$MASTER_NAME)) {
            return false;
        }
        String this$WEB_NODES = this.getWEB_NODES();
        String other$WEB_NODES = other.getWEB_NODES();
        if (this$WEB_NODES == null ? other$WEB_NODES != null : !this$WEB_NODES.equals(other$WEB_NODES)) {
            return false;
        }
        String this$WEB_NODES_HEARTBEAT = this.getWEB_NODES_HEARTBEAT();
        String other$WEB_NODES_HEARTBEAT = other.getWEB_NODES_HEARTBEAT();
        if (this$WEB_NODES_HEARTBEAT == null ? other$WEB_NODES_HEARTBEAT != null : !this$WEB_NODES_HEARTBEAT.equals(other$WEB_NODES_HEARTBEAT)) {
            return false;
        }
        String this$ATP = this.getATP();
        String other$ATP = other.getATP();
        if (this$ATP == null ? other$ATP != null : !this$ATP.equals(other$ATP)) {
            return false;
        }
        String this$ABILITY_PLATFORM_ERROR = this.getABILITY_PLATFORM_ERROR();
        String other$ABILITY_PLATFORM_ERROR = other.getABILITY_PLATFORM_ERROR();
        if (this$ABILITY_PLATFORM_ERROR == null ? other$ABILITY_PLATFORM_ERROR != null : !this$ABILITY_PLATFORM_ERROR.equals(other$ABILITY_PLATFORM_ERROR)) {
            return false;
        }
        Boolean this$hashTags = this.getHashTags();
        Boolean other$hashTags = other.getHashTags();
        return !(this$hashTags == null ? other$hashTags != null : !((Object)this$hashTags).equals(other$hashTags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConstantBaseVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $MASTER_NAME = this.getMASTER_NAME();
        result = result * 59 + ($MASTER_NAME == null ? 43 : $MASTER_NAME.hashCode());
        String $WEB_NODES = this.getWEB_NODES();
        result = result * 59 + ($WEB_NODES == null ? 43 : $WEB_NODES.hashCode());
        String $WEB_NODES_HEARTBEAT = this.getWEB_NODES_HEARTBEAT();
        result = result * 59 + ($WEB_NODES_HEARTBEAT == null ? 43 : $WEB_NODES_HEARTBEAT.hashCode());
        String $ATP = this.getATP();
        result = result * 59 + ($ATP == null ? 43 : $ATP.hashCode());
        String $ABILITY_PLATFORM_ERROR = this.getABILITY_PLATFORM_ERROR();
        result = result * 59 + ($ABILITY_PLATFORM_ERROR == null ? 43 : $ABILITY_PLATFORM_ERROR.hashCode());
        Boolean $hashTags = this.getHashTags();
        result = result * 59 + ($hashTags == null ? 43 : ((Object)$hashTags).hashCode());
        return result;
    }

    public String toString() {
        return "ConstantBaseVersion(version=" + this.getVersion() + ", MASTER_NAME=" + this.getMASTER_NAME() + ", WEB_NODES=" + this.getWEB_NODES() + ", WEB_NODES_HEARTBEAT=" + this.getWEB_NODES_HEARTBEAT() + ", ATP=" + this.getATP() + ", ABILITY_PLATFORM_ERROR=" + this.getABILITY_PLATFORM_ERROR() + ", hashTags=" + this.getHashTags() + ")";
    }
}

