/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilitycommon.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.abilitycommon.util.Param;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class RiSunSignUtil {
    private static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT_DATETIME_SSS = "yyyy-MM-dd HH:mm:ss.SSS";

    public static String getSign(String appId, String appKey, String signType, Object bizContentObj) throws JsonProcessingException, UnsupportedEncodingException {
        String biz_content = RiSunSignUtil.getBizContent(bizContentObj);
        String timestamp = RiSunSignUtil.getTimeStamp();
        StringBuilder str = new StringBuilder();
        str.append("appId=");
        str.append(appId);
        str.append("&bizContent=");
        str.append(biz_content);
        str.append("&signType=");
        str.append(signType);
        str.append("&timestamp=");
        str.append(timestamp);
        String sign = null;
        switch (signType) {
            case "SHA256": {
                sign = RiSunSignUtil.SHA256(RiSunSignUtil.SHA256(str.toString()) + appKey);
                break;
            }
            case "MD5": {
                sign = RiSunSignUtil.MD5(RiSunSignUtil.MD5(str.toString()) + appKey);
                break;
            }
            case "SHA1": {
                sign = RiSunSignUtil.SHA1(RiSunSignUtil.SHA1(str.toString()) + appKey);
                break;
            }
        }
        assert (sign != null);
        sign = Base64.encodeBase64String((byte[])sign.getBytes(StandardCharsets.UTF_8));
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)new Param(appId, appKey, signType, timestamp, biz_content, sign));
    }

    private static String SHA1(String inStr) {
        MessageDigest sha = null;
        try {
            sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            System.out.println(e.toString());
            e.printStackTrace();
            return "";
        }
        byte[] byteArray = new byte[]{};
        try {
            byteArray = inStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        byte[] md5Bytes = sha.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    private static String MD5(String plainText) {
        byte[] secretBytes = null;
        try {
            secretBytes = MessageDigest.getInstance("md5").digest(plainText.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RuntimeException("\u6ca1\u6709\u8fd9\u4e2amd5\u7b97\u6cd5\uff01");
        }
        String md5code = new BigInteger(1, secretBytes).toString(16);
        for (int i = 0; i < 32 - md5code.length(); ++i) {
            md5code = "0" + md5code;
        }
        return md5code;
    }

    private static String SHA256(String str) {
        String encodestr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes("UTF-8"));
            encodestr = RiSunSignUtil.byte2Hex(messageDigest.digest());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encodestr;
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    private static String getBizContent(Object object) throws UnsupportedEncodingException, JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonObject = mapper.writeValueAsString(object);
        String encodedObject = URLEncoder.encode(jsonObject, "UTF-8");
        String params_str = Base64.encodeBase64String((byte[])encodedObject.getBytes("UTF-8"));
        return params_str;
    }

    private static String getTimeStamp() {
        Date date = new Date();
        SimpleDateFormat bf = new SimpleDateFormat(DATE_FORMAT_DATETIME);
        String format = bf.format(date);
        return format;
    }
}

