/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util;

import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.ohaotian.plugin.exception.InterfaceException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class FormatUtil {
    public static final String DATE_FORMAT_TIMESTAMP = "TimeStamp";
    public static final String DATE_FORMAT_DATE = "yyyy-MM-dd";
    public static final String DATE_FORMAT_DATETIME = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT_DATETIME_POINT_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_FORMAT_DATETIME_COLON_SSS = "yyyy-MM-dd HH:mm:ss:SSS";

    public static String xmlToJson(String xml) {
        JSONObject jsonObject = JSONUtil.parseFromXml((String)xml);
        return jsonObject.toString();
    }

    public static String jsonToXml(String jsonString) {
        JSONObject jsonObject = JSONUtil.parseObj((String)jsonString);
        return JSONUtil.toXmlStr((JSON)jsonObject);
    }

    public static String getTime() {
        return FormatUtil.getTimeWithFormat(DATE_FORMAT_DATETIME);
    }

    public static String getTimeWithFormat(String dateFormat) {
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static String getTimeStamp() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String timestampToDateFormat(String dateStr, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date(Long.parseLong(dateStr)));
    }

    public static String dateFormatToTimestamp(String dateStr, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            return String.valueOf(df.parse(dateStr).getTime());
        }
        catch (ParseException e) {
            throw new InterfaceException("\n\t\u65f6\u95f4\u4e0e\u6307\u5b9a\u683c\u5f0f\u4e0d\u5339\u914d!", e);
        }
    }
}

