/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.util.safety;

import com.ohaotian.plugin.util.safety.MD5Util;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class SignBuilder {
    public static final String TIMESTAMP_KEY = "timestamp";
    public static final String CLIENT_ID_KEY = "clientId";
    public static final String SIGN_KEY = "sign";
    public static final String SALT_KEY = "salt";
    private final String clientId;
    private final String clientSecret;
    private Long timestamp;
    private String salt;
    private String requestPath;
    private String requestMethod;
    private String sign;
    private final Map<String, Object> allParam = new TreeMap<String, Object>();

    private SignBuilder(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public static SignBuilder create(String clientId, String clientSecret) {
        return new SignBuilder(clientId, clientSecret);
    }

    public static SignBuilder createWithTimestampAndSalt(String clientId, String clientSecret) {
        SignBuilder result = new SignBuilder(clientId, clientSecret);
        return result.timestamp(System.currentTimeMillis()).salt();
    }

    public SignBuilder param(String key, Object value) {
        if (this.sign != null) {
            throw new RuntimeException("sign has been generated, can't change the param");
        }
        if (SIGN_KEY.equals(key)) {
            return this;
        }
        if (TIMESTAMP_KEY.equals(key)) {
            this.timestamp = Long.valueOf(String.valueOf(value));
        }
        if (SALT_KEY.equals(key)) {
            this.salt = String.valueOf(value);
        }
        this.allParam.put(key, value);
        return this;
    }

    public SignBuilder params(Map<String, Object> params) {
        if (params == null) {
            return this;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            this.param(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public SignBuilder timestamp(Long timestamp) {
        this.param(TIMESTAMP_KEY, timestamp);
        return this;
    }

    public SignBuilder requestPath(String requestPath) {
        if (this.sign != null) {
            throw new RuntimeException("sign has been generated, can't change the param");
        }
        this.requestPath = requestPath;
        return this;
    }

    public SignBuilder requestMethod(String requestMethod) {
        if (this.sign != null) {
            throw new RuntimeException("sign has been generated, can't change the param");
        }
        if (requestMethod != null) {
            this.requestMethod = requestMethod.toUpperCase();
        }
        return this;
    }

    public SignBuilder salt() {
        return this.salt(Math.random());
    }

    public SignBuilder salt(Object salt) {
        this.param(SALT_KEY, salt);
        return this;
    }

    public Map<String, Object> getQueryParamMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.allParam);
        result.put(SIGN_KEY, this.sign());
        return result;
    }

    public String getRawDataBeforeSign() {
        return this.rawDataBeforeSign() + "{clientSecret}";
    }

    private String rawDataBeforeSign() {
        this.allParam.put(CLIENT_ID_KEY, this.clientId);
        if (this.timestamp != null && !this.allParam.containsKey(TIMESTAMP_KEY)) {
            this.allParam.put(TIMESTAMP_KEY, this.timestamp);
        }
        StringBuilder sb = new StringBuilder();
        for (Object value : this.allParam.values()) {
            if (value == null) continue;
            sb.append(String.valueOf(value).trim());
        }
        if (this.requestPath != null) {
            sb.append(this.requestPath);
        }
        if (this.requestMethod != null) {
            sb.append(this.requestMethod.toUpperCase());
        }
        return sb.toString();
    }

    public String sign() {
        if (this.sign != null) {
            return this.sign;
        }
        this.sign = MD5Util.getMD5String(this.rawDataBeforeSign() + this.clientSecret);
        if (this.sign == null) {
            return "";
        }
        return this.sign.toUpperCase();
    }

    public String getSalt() {
        return this.salt;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }
}

