/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.FormatUtil;
import com.ohaotian.plugin.util.GeneralUtils;
import java.util.Iterator;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DateUtil")
public class DateUtilMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        String arg1Str = null;
        String arg2Str = null;
        Integer arg1Int = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (arg1Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg1Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (arg2Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                arg2Str = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (arg1Str == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_INTEGER.getCode())) {
                arg1Int = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                switch (method) {
                    case DateUtil_getTime: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), FormatUtil.getTime());
                    }
                    case DateUtil_getTimeWithDateFormat: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), FormatUtil.getTimeWithFormat(arg1Str));
                    }
                    case DateUtil_getTimestamp: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), FormatUtil.getTimeStamp());
                    }
                    case DateUtil_dateFormatToTimestamp: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), FormatUtil.dateFormatToTimestamp(arg1Str, arg2Str));
                    }
                    case DateUtil_timestampToDateFormat: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), FormatUtil.timestampToDateFormat(arg1Str, arg2Str));
                    }
                    case DateUtil_timeSleep: {
                        try {
                            Thread.sleep(arg1Int.intValue());
                            return true;
                        }
                        catch (InterruptedException e) {
                            return false;
                        }
                    }
                }
                throw new InterfaceException("\n\tDateUtil\u65b9\u6cd5\u4e2d\u4e0d\u5b58\u5728\u8be5\u65b9\u6cd5: " + method.getCode());
            }
            throw new InterfaceException("\n\tDateUtil." + method.getCode() + "\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:" + next.getName());
        }
        throw new InterfaceException("\n\tDateUtil\u65b9\u6cd5\u89e3\u6790\u9519\u8bef: " + method.getCode() + "\u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!");
    }
}

