/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.parse.tag.impl.methods;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.exception.InterfaceException;
import com.ohaotian.plugin.model.FaceMsgContext;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseObjects;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import com.ohaotian.plugin.model.bo.MethodAttributeBO;
import com.ohaotian.plugin.service.parse.tag.Methods;
import com.ohaotian.plugin.service.path.Upath;
import com.ohaotian.plugin.util.GeneralUtils;
import com.ohaotian.plugin.util.HttpUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.dom4j.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="Http")
public class HttpMethodsImpl
implements Methods {
    @Autowired
    private Upath upath;
    private static final int defaultConnectTimeoutSeconds = 5;
    private static final int defaultReadTimeoutSeconds = 10;
    private static final boolean defaultRetryFlag = Boolean.FALSE;

    @Override
    public <M> boolean doMethods(FaceMsgContext<M> faceMsgContext, Iterator iterator, String inPath, BaseMethods method) throws InterfaceException {
        String url = null;
        JSONObject headers = null;
        JSONObject params = null;
        Integer connectTimeoutSeconds = null;
        Integer readTimeoutSeconds = null;
        while (iterator.hasNext()) {
            Element next = (Element)iterator.next();
            MethodAttributeBO tagAttributes = GeneralUtils.getMethodAttribute(next);
            if (url == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_STRING.getCode())) {
                url = this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString();
                continue;
            }
            if (headers == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_JSONOBJECT.getCode())) {
                headers = (JSONObject)GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                continue;
            }
            if (params == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && tagAttributes.getType().equals(BaseObjects.OBJECT_JSONOBJECT.getCode())) {
                params = (JSONObject)GeneralUtils.getObjectByType(tagAttributes.getType(), this.upath.get(faceMsgContext, tagAttributes.getInPath()));
                continue;
            }
            if (connectTimeoutSeconds == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && (tagAttributes.getType().equals(BaseObjects.OBJECT_INTEGER.getCode()) || tagAttributes.getType().equals(BaseObjects.OBJECT_INT.getCode()))) {
                connectTimeoutSeconds = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (readTimeoutSeconds == null && next.getName().equals(BaseTags.TAG_PARAM.getCode()) && (tagAttributes.getType().equals(BaseObjects.OBJECT_INTEGER.getCode()) || tagAttributes.getType().equals(BaseObjects.OBJECT_INT.getCode()))) {
                readTimeoutSeconds = Integer.parseInt(this.upath.get(faceMsgContext, tagAttributes.getInPath()).toString());
                continue;
            }
            if (next.getName().equals(BaseTags.TAG_VALUATION.getCode()) && Boolean.FALSE.equals(tagAttributes.getReturnPath().isEmpty())) {
                connectTimeoutSeconds = connectTimeoutSeconds == null ? 5 : connectTimeoutSeconds;
                readTimeoutSeconds = readTimeoutSeconds == null ? 10 : readTimeoutSeconds;
                switch (method) {
                    case Http_GET: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), HttpUtil.sendGet(url, this.jsonObjectToMap(headers), this.jsonObjectToMap(params), connectTimeoutSeconds, readTimeoutSeconds, defaultRetryFlag)));
                    }
                    case Http_POST_Json: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), HttpUtil.sendPostJson(url, this.jsonObjectToMap(headers), params.toJSONString(), connectTimeoutSeconds, readTimeoutSeconds, defaultRetryFlag)));
                    }
                    case Http_POST_FormData: {
                        return this.upath.put(faceMsgContext, tagAttributes.getReturnPath(), GeneralUtils.getObjectByType(tagAttributes.getType(), HttpUtil.sendPostFormData(url, this.jsonObjectToMap(headers), this.jsonObjectToMap(params), connectTimeoutSeconds, readTimeoutSeconds, defaultRetryFlag)));
                    }
                }
                throw new InterfaceException("\n\tHttp\u65b9\u6cd5\u4e2d\u4e0d\u5b58\u5728\u8be5\u65b9\u6cd5: " + method.getCode());
            }
            throw new InterfaceException("\n\tHttp." + method.getCode() + "\u65b9\u6cd5\u51fa\u73b0\u4e86\u9519\u8bef\u53c2\u6570:" + next.getName());
        }
        throw new InterfaceException("\n\tHttp\u65b9\u6cd5\u89e3\u6790\u9519\u8bef: " + method.getCode() + " \u65b9\u6cd5\u6ca1\u6709\u8fdb\u884c\u8d4b\u503c\u64cd\u4f5c!");
    }

    public Map<String, String> jsonObjectToMap(JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), entry.getValue().toString());
        }
        return map;
    }
}

