/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.auth.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.auth.jwt.JwtTokenProvider;
import com.ohaotian.atp.auth.model.AuthRequestBo;
import com.ohaotian.atp.auth.model.UserAuthCacheBo;
import com.ohaotian.atp.auth.security.UserRepository;
import com.ohaotian.atp.auth.service.AbilityUserAuthService;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import java.util.Date;
import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AbilityUserAuthServiceImpl
implements AbilityUserAuthService {
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtTokenProvider jwtTokenProvider;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${ability.auth.limit.frequency:5}")
    private int frequency;
    @Value(value="${ability.auth.limit.time:30}")
    private int frequencyTime;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    @Override
    public RspBO<String> login(AuthRequestBo request, HttpServletResponse response) {
        String jwt;
        String username = request.getUsername();
        int expireTime = this.frequencyTime * 60;
        Object exist = this.cacheClient.get(this.constantBaseVersion.getBADDIE_AUTHS() + username);
        if (!ObjectUtils.isEmpty((Object)exist)) {
            response.setStatus(HttpStatus.BAD_GATEWAY.value());
            Long expire = this.cacheClient.getExpireTimeByKey(this.constantBaseVersion.getBADDIE_AUTHS() + username);
            return RspBO.error((String)("\u767b\u5f55\u9650\u5236," + expire / 60L + "\u5206" + expire % 60L + "\u79d2\u540e\u8fdb\u884c\u91cd\u8bd5!"));
        }
        try {
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)request.getPassword()));
            jwt = this.jwtTokenProvider.createToken(username, this.userRepository.findByUsername(username).orElseThrow(() -> new UsernameNotFoundException("Username " + username + "not found")).getRoles());
            this.cacheClient.delete(this.constantBaseVersion.getUSER_AUTHS() + username);
        }
        catch (UsernameNotFoundException e) {
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return RspBO.error((String)"\u767b\u5f55\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\uff01");
        }
        catch (Exception e) {
            exist = this.cacheClient.get(this.constantBaseVersion.getUSER_AUTHS() + username);
            if (!ObjectUtils.isEmpty((Object)exist)) {
                UserAuthCacheBo userAuthCacheBo = (UserAuthCacheBo)JSON.parseObject((String)((String)exist), UserAuthCacheBo.class);
                if (userAuthCacheBo.getNum() == 1) {
                    JSONObject data = JSON.parseObject((String)"{}");
                    data.put("addTime", (Object)DateUtil.formatDateWithMS((Date)new Date()));
                    data.put("endTime", (Object)DateUtil.formatDateWithMS((Date)new Date(System.currentTimeMillis() + (long)expireTime * 1000L)));
                    userAuthCacheBo.getMsg().put(String.valueOf(1), e.getMessage());
                    data.put("log", (Object)JSON.toJSONString(userAuthCacheBo.getMsg()));
                    this.cacheClient.set(this.constantBaseVersion.getBADDIE_AUTHS() + username, (Object)data.toJSONString(), expireTime);
                    this.cacheClient.delete(this.constantBaseVersion.getUSER_AUTHS() + username);
                    response.setStatus(HttpStatus.BAD_GATEWAY.value());
                    return RspBO.error((String)("\u767b\u5f55\u5f02\u5e38," + this.frequencyTime + "\u5206\u949f\u540e\u91cd\u8bd5\uff01"));
                }
                userAuthCacheBo.getMsg().put(String.valueOf(userAuthCacheBo.getNum()), e.getMessage());
                userAuthCacheBo.setNum(userAuthCacheBo.getNum() - 1);
                this.cacheClient.set(this.constantBaseVersion.getUSER_AUTHS() + username, (Object)JSON.toJSONString((Object)userAuthCacheBo), expireTime);
                response.setStatus(HttpStatus.UNAUTHORIZED.value());
                return RspBO.error((String)("\u767b\u5f55\u5f02\u5e38," + userAuthCacheBo.getNum() + "\u6b21\u767b\u5f55\u5931\u8d25\u540e\u9501\u5b9a" + this.frequencyTime + "\u5206\u949f\uff01"));
            }
            UserAuthCacheBo userAuthCacheBo = new UserAuthCacheBo();
            userAuthCacheBo.setNum(this.frequency - 1);
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(String.valueOf(this.frequency), e.getMessage());
            userAuthCacheBo.setMsg(map);
            this.cacheClient.set(this.constantBaseVersion.getUSER_AUTHS() + username, (Object)JSON.toJSONString((Object)userAuthCacheBo), expireTime);
            response.setStatus(HttpStatus.UNAUTHORIZED.value());
            return RspBO.error((String)"\u767b\u5f55\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u7528\u6237\u540d\u4e0e\u5bc6\u7801\uff0c\u8fd8\u67094\u6b21\u5c1d\u8bd5\uff01");
        }
        return RspBO.success((Object)jwt);
    }

    @Override
    public RspBO<String> logout(AuthRequestBo request) {
        this.cacheClient.delete(request.getToken());
        return RspBO.success((Object)"\u6ce8\u9500\u767b\u5f55\u6210\u529f");
    }
}

