/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.atp.auth.jwt;

import com.ohaotian.atp.auth.config.JwtProperties;
import com.ohaotian.atp.auth.exception.InvalidJwtAuthenticationException;
import com.ohaotian.atp.auth.service.impl.CustomUserDetailsServiceImpl;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.portalcommon.util.DateUtil;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class JwtTokenProvider {
    @Autowired
    private JwtProperties jwtProperties;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private CustomUserDetailsServiceImpl userDetailsService;
    private String secretKey;

    @PostConstruct
    protected void init() {
        this.secretKey = Base64.getEncoder().encodeToString(this.jwtProperties.getSecretKey().getBytes());
    }

    public String createToken(String username, List<String> roles) {
        Claims claims = Jwts.claims().setSubject(username);
        claims.put((Object)"roles", roles);
        Date now = new Date();
        Date validity = new Date(now.getTime() + this.jwtProperties.getValidityInMs());
        String jwt = Jwts.builder().setClaims(claims).setIssuedAt(now).setExpiration(validity).signWith(SignatureAlgorithm.HS256, this.secretKey).compact();
        int expire = Integer.parseInt(String.valueOf(this.jwtProperties.getValidityInMs())) / 1000;
        this.cacheClient.set(jwt, (Object)(username + "-" + DateUtil.formatDateWithMS((Date)validity)), expire);
        return jwt;
    }

    public Authentication getAuthentication(String token) {
        UserDetails userDetails = this.userDetailsService.loadUserByUsername(this.getUsername(token));
        return new UsernamePasswordAuthenticationToken((Object)userDetails, (Object)"", userDetails.getAuthorities());
    }

    public String getUsername(String token) {
        return ((Claims)Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token).getBody()).getSubject();
    }

    public String resolveToken(HttpServletRequest req) {
        String bearerToken = req.getHeader("Authorization");
        if (bearerToken != null && bearerToken.startsWith("Bearer ")) {
            return bearerToken.substring(7);
        }
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.jwtProperties.getHeadTokenKey())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public boolean validateToken(String token) {
        try {
            Jws claims = Jwts.parser().setSigningKey(this.secretKey).parseClaimsJws(token);
            Object cacheToken = this.cacheClient.get(token);
            if (ObjectUtils.isEmpty((Object)cacheToken)) {
                throw new JwtException("");
            }
            return !((Claims)claims.getBody()).getExpiration().before(new Date());
        }
        catch (JwtException | IllegalArgumentException e) {
            throw new InvalidJwtAuthenticationException("Expired or invalid JWT token");
        }
    }
}

