/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginContainHpartyCheckMapper;
import com.ohaotian.plugin.mapper.ContainHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.rsp.SyncContainHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.ContainHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginContainHpartyCheckPO;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.config.redis.PubSubRedisBaseClient;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginDataRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ContainTokenRefreshLogic {
    private static final Logger log = LogManager.getLogger(ContainTokenRefreshLogic.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doLogic(ContainHpartyCheckTokenMapper containHpartyCheckTokenMapper, AbilityPluginContainHpartyCheckMapper abilityPluginContainHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, PubSubRedisBaseClient pubSubRedisBaseClient, PluginContainHpartyCheckPO pluginContainHpartyCheckPO, ContainHpartyCheckTokenPO multiTokenPO, CacheClient cacheClient, PluginAPI pluginAPI) {
        PluginRspBO pluginRspBO = pluginAPI.getPluginInfo(pluginContainHpartyCheckPO.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname();
        log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### containTokenHPC ###### START", (Object)abilityNameAll);
        JSONObject jsonObject = JSON.parseObject((String)multiTokenPO.getReqMsg());
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        jsonObject.put("timestamp", (Object)now.format(ofPattern));
        jsonObject.put("grant_type", (Object)"access_token");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", pluginContainHpartyCheckPO.getTokenHeader());
        log.info("\u914d\u7f6e\u53c2\u6570\uff1a{}", (Object)GsonUtil.toJson((Object)pluginContainHpartyCheckPO));
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)GsonUtil.toJson(headerMap));
        try {
            if (pluginContainHpartyCheckPO.getCallProtocol() == 0) {
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostJson");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)jsonObject));
                HpartyCheckHttpUtil.doPostJson(pluginContainHpartyCheckPO.getTokenPath().trim(), GsonUtil.toJson((Object)jsonObject), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        ContainTokenRefreshLogic.updateErrorToken(containHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)map));
                    try {
                        Long duration;
                        JSONObject tokenRsp = JSONObject.parseObject((String)map);
                        List tokenGetField = Arrays.stream(pluginContainHpartyCheckPO.getTokenRule().split(":")).collect(Collectors.toList());
                        for (int i = 0; i < tokenGetField.size() - 1; ++i) {
                            tokenRsp = JSONObject.parseObject((String)String.valueOf(JSONObject.parseObject((String)((String)tokenRsp.get(tokenGetField.get(i))))));
                        }
                        String token = tokenRsp.getString((String)tokenGetField.get(tokenGetField.size() - 1));
                        multiTokenPO.setAccessToken(token);
                        JSONObject expiresRsp = JSONObject.parseObject((String)map);
                        if (StringUtils.isNotBlank((CharSequence)pluginContainHpartyCheckPO.getExpiresRule())) {
                            List expiresGetField = Arrays.stream(pluginContainHpartyCheckPO.getExpiresRule().split(":")).collect(Collectors.toList());
                            for (int i = 0; i < expiresGetField.size() - 1; ++i) {
                                expiresRsp = JSONObject.parseObject((String)String.valueOf(JSONObject.parseObject((String)((String)expiresRsp.get(expiresGetField.get(i))))));
                            }
                            duration = Long.parseLong(expiresRsp.getString((String)expiresGetField.get(expiresGetField.size() - 1)));
                        } else {
                            expiresRsp = (JSONObject)expiresRsp.get((Object)"result");
                            duration = expiresRsp.getLong("expires_in") * 1000L;
                        }
                        Date time = new Date();
                        ContainTokenRefreshLogic.updateToken(containHpartyCheckTokenMapper, multiTokenPO, new Date(time.getTime() + duration));
                        log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)multiTokenPO));
                        log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u503c:{}", (Object)token);
                        ContainTokenRefreshLogic.setRedis(abilityPluginContainHpartyCheckMapper, abilityPluginDeployApi, cacheClient, pluginContainHpartyCheckPO, multiTokenPO);
                        return status;
                    }
                    catch (Exception e) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        ContainTokenRefreshLogic.updateErrorToken(containHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                }, headerMap);
            } else {
                Map paramsMap = (Map)JSON.parseObject((String)jsonObject.toJSONString(), (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostForm");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)paramsMap));
                HttpUtil.doPost((String)pluginContainHpartyCheckPO.getTokenPath().trim(), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        ContainTokenRefreshLogic.updateErrorToken(containHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                    log.info("token\u5237\u65b0\u6210\u529f:\uff0c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)map));
                    try {
                        Long duration;
                        JSONObject tokenRsp = JSONObject.parseObject((String)map);
                        List tokenGetField = Arrays.stream(pluginContainHpartyCheckPO.getTokenRule().split(":")).collect(Collectors.toList());
                        for (int i = 0; i < tokenGetField.size() - 1; ++i) {
                            tokenRsp = JSONObject.parseObject((String)String.valueOf(JSONObject.parseObject((String)((String)tokenRsp.get(tokenGetField.get(i))))));
                        }
                        String token = tokenRsp.getString((String)tokenGetField.get(tokenGetField.size() - 1));
                        multiTokenPO.setAccessToken(token);
                        JSONObject expiresRsp = JSONObject.parseObject((String)map);
                        if (StringUtils.isNotBlank((CharSequence)pluginContainHpartyCheckPO.getExpiresRule())) {
                            List expiresGetField = Arrays.stream(pluginContainHpartyCheckPO.getExpiresRule().split(":")).collect(Collectors.toList());
                            for (int i = 0; i < expiresGetField.size() - 1; ++i) {
                                expiresRsp = JSONObject.parseObject((String)String.valueOf(JSONObject.parseObject((String)((String)expiresRsp.get(expiresGetField.get(i))))));
                            }
                            duration = Long.parseLong(expiresRsp.getString((String)expiresGetField.get(expiresGetField.size() - 1)));
                        } else {
                            expiresRsp = (JSONObject)expiresRsp.get((Object)"result");
                            duration = expiresRsp.getLong("expires_in") * 1000L;
                        }
                        Date time = new Date();
                        ContainTokenRefreshLogic.updateToken(containHpartyCheckTokenMapper, multiTokenPO, new Date(time.getTime() + duration));
                        log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)multiTokenPO));
                        log.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u503c:{}", (Object)token);
                        ContainTokenRefreshLogic.setRedis(abilityPluginContainHpartyCheckMapper, abilityPluginDeployApi, cacheClient, pluginContainHpartyCheckPO, multiTokenPO);
                        return status;
                    }
                    catch (Exception e) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)multiTokenPO));
                        ContainTokenRefreshLogic.updateErrorToken(containHpartyCheckTokenMapper, multiTokenPO);
                        return null;
                    }
                }, (Map)paramsMap);
            }
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5931\u8d25:\uff0ctoken\u8bb0\u5f55:{}", (Object)JSON.toJSONString((Object)multiTokenPO), (Object)e);
            ContainTokenRefreshLogic.updateErrorToken(containHpartyCheckTokenMapper, multiTokenPO);
        }
        finally {
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private static void updateToken(ContainHpartyCheckTokenMapper containHpartyCheckTokenMapper, ContainHpartyCheckTokenPO containHpartyCheckTokenPO, Date expiresIn) {
        containHpartyCheckTokenPO.setIsRunning(1);
        containHpartyCheckTokenPO.setExpiresIn(expiresIn);
        containHpartyCheckTokenPO.setUpdateTime(new Date());
        containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
    }

    private static void updateErrorToken(ContainHpartyCheckTokenMapper containHpartyCheckTokenMapper, ContainHpartyCheckTokenPO containHpartyCheckTokenPO) {
        containHpartyCheckTokenPO.setIsRunning(2);
        containHpartyCheckTokenPO.setUpdateTime(new Date());
        containHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(containHpartyCheckTokenPO);
    }

    public static void noticeForData(AbilityPluginContainHpartyCheckMapper abilityPluginContainHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, PubSubRedisBaseClient pubSubRedisBaseClient, PluginContainHpartyCheckPO pluginContainHpartyCheckPO, ContainHpartyCheckTokenPO containHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginContainHpartyCheckMapper.queryAllDeployIds();
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            List clusterIds = abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).collect(Collectors.toList());
            PluginDataRspBO pluginDataRspBO = new PluginDataRspBO();
            pluginDataRspBO.setClusterIds(clusterIds);
            pluginDataRspBO.setPluginType("multiTokenHPC");
            pluginDataRspBO.setOpr("refresh");
            SyncContainHpartyCheckTokenBO syncContainHpartyCheckTokenBO = (SyncContainHpartyCheckTokenBO)BeanMapper.map((Object)containHpartyCheckTokenPO, SyncContainHpartyCheckTokenBO.class);
            pluginDataRspBO.setData((Object)GsonUtil.toJson((Object)syncContainHpartyCheckTokenBO));
            log.debug("\u96c6\u7fa4\u901a\u77e5:{}", (Object)JSON.toJSONString((Object)pluginDataRspBO));
        }
    }

    public static void setRedis(AbilityPluginContainHpartyCheckMapper abilityPluginContainHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, CacheClient cacheClient, PluginContainHpartyCheckPO pluginContainHpartyCheckPO, ContainHpartyCheckTokenPO containHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginContainHpartyCheckMapper.queryAllDeployIds();
        SyncContainHpartyCheckTokenBO syncContainHpartyCheckTokenBO = (SyncContainHpartyCheckTokenBO)BeanMapper.map((Object)containHpartyCheckTokenPO, SyncContainHpartyCheckTokenBO.class);
        syncContainHpartyCheckTokenBO.setCallProtocol(pluginContainHpartyCheckPO.getCallProtocol());
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                String key = "atp-containTokenHPC-" + i + "-" + containHpartyCheckTokenPO.getPluginId() + "-" + containHpartyCheckTokenPO.getOrgId() + "-" + containHpartyCheckTokenPO.getAppKey();
                String value = GsonUtil.toJson((Object)syncContainHpartyCheckTokenBO);
                log.info("containTokenHPC Redis\u5199\u5165\uff1a{} -> {}", (Object)key, (Object)value);
                cacheClient.set(key, (Object)value);
            });
        }
    }
}

