/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.PluginG3PlusHpartyCheckReqBO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.PluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="g3PlusHPC", position=ExtensionPointPositionEnum.PLUGIN_POSITION)
public class G3PlusHpartyCheckPluginHandler
extends AbstractPluginHandler<Map> {
    private static final Logger logger = LogManager.getLogger(G3PlusHpartyCheckPluginHandler.class);
    @Value(value="classpath:data/HpartyCheckPlugin.json")
    private org.springframework.core.io.Resource extInfoRes;
    @Resource
    PluginG3PlusHpartyCheckMapper pluginG3PlusHpartyCheckMapper;
    @Resource
    G3PlusHpartyCheckAppendMapper g3PlusHpartyCheckAppendMapper;
    @Resource
    G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper;

    public RspBO handleGetInfo() throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u83b7\u53d6\u63d2\u4ef6\u4e2d\u7684\u6269\u5c55\u70b9");
        logger.debug("\u67e5\u8be2\u8def\u7531\u63d2\u4ef6\u4fe1\u606f");
        try {
            String extIfo = IOUtils.toString((InputStream)this.extInfoRes.getInputStream(), (Charset)StandardCharsets.UTF_8);
            Object parse = JSON.parse((String)extIfo);
            return RspBO.success((Object)parse);
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u83b7\u53d6route-plugin\u63d2\u4ef6\u6269\u5c55\u70b9\u6570\u636e\u5f02\u5e38");
        }
    }

    public RspBO handleAdd(Map pluginHpartyCheckMap) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5904\u7406\u63d2\u4ef6\u4fdd\u5b58\u64cd\u4f5c");
        Long userId = Long.valueOf(UserHolder.getUserId());
        try {
            PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO = (PluginG3PlusHpartyCheckReqBO)BeanMapper.map((Object)pluginHpartyCheckMap, PluginG3PlusHpartyCheckReqBO.class);
            ValidBatchUtils.isNotEmpty((Object)pluginG3PlusHpartyCheckReqBO, (String[])new String[]{"appRegion", "clientId", "clientSecret", "userName", "userPassword", "tokenPath", "refreshInterval", "callProtocol", "appendContents"});
            boolean isValid = CronCheckUtil.isValidExpression(pluginG3PlusHpartyCheckReqBO.getRefreshInterval());
            if (!isValid) {
                throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
            }
            Long pluginId = pluginG3PlusHpartyCheckReqBO.getPluginId();
            PluginG3PlusHpartyCheckPO pluginG3PlusHpartyCheckPO = (PluginG3PlusHpartyCheckPO)BeanMapper.map((Object)pluginG3PlusHpartyCheckReqBO, PluginG3PlusHpartyCheckPO.class);
            pluginG3PlusHpartyCheckPO.setRegionCode(pluginG3PlusHpartyCheckReqBO.getAppRegion()[1]);
            pluginG3PlusHpartyCheckPO.setCreateTime(new Date());
            pluginG3PlusHpartyCheckPO.setCreateUserId(userId);
            this.pluginG3PlusHpartyCheckMapper.insertSelective(pluginG3PlusHpartyCheckPO);
            List appends = pluginG3PlusHpartyCheckReqBO.getAppendContents();
            ArrayList<G3PlusHpartyCheckAppendPO> g3PlusHpartyCheckAppendPOS = new ArrayList<G3PlusHpartyCheckAppendPO>();
            for (String append : appends) {
                G3PlusHpartyCheckAppendPO g3PlusHpartyCheckAppendPO = new G3PlusHpartyCheckAppendPO();
                g3PlusHpartyCheckAppendPO.setPluginId(pluginId);
                g3PlusHpartyCheckAppendPO.setAppendContent(append);
                g3PlusHpartyCheckAppendPOS.add(g3PlusHpartyCheckAppendPO);
            }
            this.g3PlusHpartyCheckAppendMapper.insertRecords(g3PlusHpartyCheckAppendPOS);
            return RspBO.success(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Map pluginHpartyCheckMap) throws ZTBusinessException {
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u5904\u7406\u63d2\u4ef6\u5220\u9664\u64cd\u4f5c");
        try {
            PluginG3PlusHpartyCheckReqBO pluginG3PlusHpartyCheckReqBO = (PluginG3PlusHpartyCheckReqBO)BeanMapper.map((Object)pluginHpartyCheckMap, PluginG3PlusHpartyCheckReqBO.class);
            this.pluginG3PlusHpartyCheckMapper.deleteByPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
            this.g3PlusHpartyCheckAppendMapper.deleteByPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
            this.g3PlusHpartyCheckTokenMapper.deleteByPluginId(pluginG3PlusHpartyCheckReqBO.getPluginId());
            return RspBO.success(null);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

