/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginG3PlusHpartyCheckMapper;
import com.ohaotian.plugin.mapper.G3PlusAbilityProvideDeployMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.G3PlusHpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.req.G3PlusRefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.req.G3PlusTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.G3PlusRefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.G3PlusTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.SyncG3PlusHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.AbilityPluginG3PlusHpartyCheckPO;
import com.ohaotian.plugin.model.po.G3PlusAbilityProvideDeployPO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.G3PlusHpartyCheckTokenPO;
import com.ohaotian.plugin.model.vo.G3PlusHpartyCheckTokenVO;
import com.ohaotian.plugin.util.G3PlusHpartyCheckHttpUtil;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public abstract class G3PLusTokenRefreshLogic {
    private static final Logger logger = LogManager.getLogger(G3PLusTokenRefreshLogic.class);
    @Resource
    private G3PlusAbilityProvideDeployMapper AbilityProvideDeployMapper;

    public static void doLogic(G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper, AbilityPluginG3PlusHpartyCheckMapper abilityPluginG3PlusHpartyCheckMapper, G3PlusAbilityProvideDeployMapper g3PlusAbilityProvideDeployMapper, G3PlusHpartyCheckAppendMapper g3PlusHpartyCheckAppendMapper, CacheClient cacheClient, G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO, PluginAPI pluginAPI) {
        PluginRspBO pluginRspBO = pluginAPI.getPluginInfo(g3PlusHpartyCheckTokenVO.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname();
        logger.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### g3PlusHPC ###### START", (Object)abilityNameAll);
        G3PlusRefreshTokenReqBO g3PlusRefreshTokenReqBO = (G3PlusRefreshTokenReqBO)BeanMapper.map((Object)g3PlusHpartyCheckTokenVO, G3PlusRefreshTokenReqBO.class);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        g3PlusRefreshTokenReqBO.setTimestamp(now.format(ofPattern));
        g3PlusRefreshTokenReqBO.setGrantType("access_token");
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)g3PlusHpartyCheckTokenVO.getTokenHeader())) {
            String[] entitys;
            String header = g3PlusHpartyCheckTokenVO.getTokenHeader();
            for (String entity : entitys = header.split(",")) {
                String[] strs = entity.split(":");
                if (strs.length != 2) {
                    throw new ZTBusinessException("\u5237\u65b0\u8bf7\u6c42\u5934\u914d\u7f6e\u9519\u8bef\uff01");
                }
                headerMap.put(strs[0], strs[1]);
            }
        }
        try {
            if (g3PlusHpartyCheckTokenVO.getCallProtocol() == 0) {
                G3PlusTokenReqBO g3PlusTokenReqBO = new G3PlusTokenReqBO();
                g3PlusTokenReqBO.setClientId(g3PlusRefreshTokenReqBO.getClientId());
                g3PlusTokenReqBO.setAuthPassword(g3PlusRefreshTokenReqBO.getClientSecret());
                logger.info("\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)g3PlusHpartyCheckTokenVO));
                logger.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)g3PlusTokenReqBO));
                G3PlusHpartyCheckHttpUtil.doPostJson(g3PlusHpartyCheckTokenVO.getTokenPath().trim(), GsonUtil.toJson((Object)g3PlusTokenReqBO), (status, map) -> {
                    if (status != 200) {
                        logger.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id--> {}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                        return null;
                    }
                    G3PlusTokenRspBO g3PlusTokenRspBO = (G3PlusTokenRspBO)GsonUtil.fromJson((String)map, G3PlusTokenRspBO.class);
                    logger.info("G3Plus\u54cd\u5e94\u6570\u636e --> {}", (Object)g3PlusTokenRspBO);
                    if (g3PlusTokenRspBO.getCode() == null) {
                        g3PlusTokenRspBO.setCode(200);
                        g3PlusTokenRspBO.setMessage("\u8bf7\u6c42\u6210\u529f\uff01");
                    }
                    if (g3PlusTokenRspBO.getCode().equals(401)) {
                        logger.error("token\u5237\u65b0\u9519\u8bef:token\u8bb0\u5f55id--> {}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                        return null;
                    }
                    logger.info("token\u5237\u65b0\u6210\u529f:\u63d2\u4ef6\u5206\u533a--> {}", (Object)g3PlusHpartyCheckTokenVO.getRegionCode());
                    logger.info("token\u5237\u65b0\u6210\u529f:token\u8bb0\u5f55id--> {}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                    Long duration = g3PlusTokenRspBO.getExpiresIn() * 1000L;
                    Date time = new Date();
                    String token = g3PlusTokenRspBO.getAccessToken();
                    String regionCode = g3PlusHpartyCheckTokenVO.getRegionCode();
                    G3PlusAbilityProvideDeployPO g3PlusAbilityProvideDeployPO = new G3PlusAbilityProvideDeployPO();
                    g3PlusAbilityProvideDeployPO.setRegionCode(regionCode);
                    Long ClusterId = g3PlusAbilityProvideDeployMapper.queryLimitOne(g3PlusAbilityProvideDeployPO).getClusterId();
                    String key = "atp-g3PlusHPC-" + ClusterId + "-" + regionCode + "-token";
                    List<G3PlusHpartyCheckAppendPO> g3PlusHpartyCheckAppendPOS = g3PlusHpartyCheckAppendMapper.queryByCond(G3PlusHpartyCheckAppendPO.builder().pluginId(g3PlusHpartyCheckTokenVO.getPluginId()).build());
                    AbilityRedisTokenDataBo abilityRedisTokenDataBo = new AbilityRedisTokenDataBo();
                    abilityRedisTokenDataBo.setPluginId(g3PlusHpartyCheckTokenVO.getPluginId().toString());
                    abilityRedisTokenDataBo.setClientId(g3PlusRefreshTokenReqBO.getClientId());
                    abilityRedisTokenDataBo.setClientSecret(g3PlusHpartyCheckTokenVO.getClientSecret());
                    abilityRedisTokenDataBo.setAccName("");
                    abilityRedisTokenDataBo.setCallProtocol(g3PlusHpartyCheckTokenVO.getCallProtocol());
                    abilityRedisTokenDataBo.setTokenPath("");
                    abilityRedisTokenDataBo.setToken(token);
                    abilityRedisTokenDataBo.setRefreshInterval(g3PlusHpartyCheckTokenVO.getRefreshInterval());
                    abilityRedisTokenDataBo.setTokenPosition(Integer.valueOf(0));
                    abilityRedisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
                    abilityRedisTokenDataBo.setHsn("");
                    abilityRedisTokenDataBo.setOrgId("");
                    abilityRedisTokenDataBo.setCompanyName("");
                    abilityRedisTokenDataBo.setRegionCode(regionCode);
                    abilityRedisTokenDataBo.setAppends(String.join((CharSequence)",", g3PlusHpartyCheckAppendPOS.stream().map(G3PlusHpartyCheckAppendPO::getAppendContent).collect(Collectors.toList())));
                    cacheClient.set(key, (Object)GsonUtil.toJson((Object)abilityRedisTokenDataBo));
                    logger.info("redis token\u6570\u636e\u5237\u65b0\uff1a{} --> {}", (Object)key, (Object)abilityRedisTokenDataBo);
                    G3PLusTokenRefreshLogic.updateToken(g3PlusHpartyCheckTokenMapper, g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId(), token, new Date(time.getTime() + duration));
                    return status;
                }, headerMap);
            } else {
                logger.info("\u4e0d\u8be5\u6765\u8fd9\u513f\uff01\uff01\uff01\uff01");
                logger.info("form\u6a21\u5f0f ---->  \u6253\u5370\u8bf7\u6c42token\u6570\u636e\uff1a{}", (Object)g3PlusHpartyCheckTokenVO);
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("client_id", g3PlusRefreshTokenReqBO.getClientId());
                paramsMap.put("client_secret", g3PlusRefreshTokenReqBO.getClientSecret());
                paramsMap.put("username", g3PlusRefreshTokenReqBO.getUserName());
                paramsMap.put("password", g3PlusRefreshTokenReqBO.getUserPassword());
                paramsMap.put("grant_type", "access_token");
                paramsMap.put("timestamp", g3PlusRefreshTokenReqBO.getTimestamp());
                HttpUtil.doPost((String)g3PlusHpartyCheckTokenVO.getTokenPath().trim(), (status, map) -> {
                    if (status != 200) {
                        logger.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                        return null;
                    }
                    G3PlusRefreshTokenRspBO g3PlusRefreshTokenRspBO = (G3PlusRefreshTokenRspBO)GsonUtil.fromJson((String)map, G3PlusRefreshTokenRspBO.class);
                    if (!g3PlusRefreshTokenRspBO.isSuccess()) {
                        logger.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                        return null;
                    }
                    Long duration = g3PlusRefreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = g3PlusRefreshTokenRspBO.getResult().getAccess_token();
                    G3PLusTokenRefreshLogic.updateToken(g3PlusHpartyCheckTokenMapper, g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId(), token, new Date(time.getTime() + duration));
                    logger.info("token\u5237\u65b0\u6210\u529f:\uff0c\u63d2\u4ef6\u5206\u533a:{}", (Object)g3PlusHpartyCheckTokenVO.getRegionCode());
                    logger.info("token\u5237\u65b0\u6210\u529f:\uff0ctoken\u8bb0\u5f55id:{}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
                    return status;
                }, paramsMap);
            }
        }
        catch (Exception e) {
            logger.error("token\u5237\u65b0\u5f02\u5e38:\uff0ctoken\u8bb0\u5f55id:{}", (Object)g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId(), (Object)e);
            throw new ZTBusinessException("token\u5237\u65b0\u5f02\u5e38!");
        }
        finally {
            logger.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private static void updateToken(G3PlusHpartyCheckTokenMapper g3PlusHpartyCheckTokenMapper, Long hpartyCheckTokenId, String token, Date expiresIn) {
        G3PlusHpartyCheckTokenPO g3PlusHpartyCheckTokenPO = new G3PlusHpartyCheckTokenPO();
        g3PlusHpartyCheckTokenPO.setHpartyCheckTokenId(hpartyCheckTokenId);
        g3PlusHpartyCheckTokenPO.setAccessToken(token);
        g3PlusHpartyCheckTokenPO.setExpiresIn(expiresIn);
        g3PlusHpartyCheckTokenPO.setUpdateTime(new Date());
        g3PlusHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(g3PlusHpartyCheckTokenPO);
    }

    public static void noticeForData(AbilityPluginG3PlusHpartyCheckMapper abilityPluginG3PlusHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, CacheClient cacheClient, G3PlusHpartyCheckTokenVO g3PlusHpartyCheckTokenVO, String token) {
        List abilityPluginDeployIds;
        List abilityPluginDeployRspBOS;
        logger.debug("G3PlusHpartyCheckPlugin--admin: \u901a\u77e5\u76f8\u5173\u96c6\u7fa4\u8fdb\u884c\u540c\u6b65\u5185\u5e93\u5b58");
        AbilityPluginG3PlusHpartyCheckPO abilityPluginG3PlusHpartyCheckPO = new AbilityPluginG3PlusHpartyCheckPO();
        abilityPluginG3PlusHpartyCheckPO.setHpartyCheckTokenId(g3PlusHpartyCheckTokenVO.getHpartyCheckTokenId());
        List<AbilityPluginG3PlusHpartyCheckPO> abilityPluginG3PlusHpartyCheckPOS = abilityPluginG3PlusHpartyCheckMapper.queryByCond(abilityPluginG3PlusHpartyCheckPO);
        if (abilityPluginG3PlusHpartyCheckPOS != null && abilityPluginG3PlusHpartyCheckPOS.size() != 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds = abilityPluginG3PlusHpartyCheckPOS.stream().map(AbilityPluginG3PlusHpartyCheckPO::getAbilityPluginDeployId).collect(Collectors.toList()))) != null && abilityPluginDeployRspBOS.size() != 0) {
            abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                SyncG3PlusHpartyCheckTokenBO syncG3PlusHpartyCheckTokenBO = (SyncG3PlusHpartyCheckTokenBO)BeanMapper.map((Object)g3PlusHpartyCheckTokenVO, SyncG3PlusHpartyCheckTokenBO.class);
                syncG3PlusHpartyCheckTokenBO.setAccessToken(token);
                String key = "hpartyCheck-" + i + "-" + g3PlusHpartyCheckTokenVO.getRegionCode();
                cacheClient.set(key, (Object)GsonUtil.toJson((Object)syncG3PlusHpartyCheckTokenBO));
            });
        }
    }
}

