/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.enums.AppendEnum;
import com.ohaotian.plugin.enums.CallProtocolEnum;
import com.ohaotian.plugin.model.bo.req.PluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.rsp.AppendRspBO;
import com.ohaotian.plugin.model.bo.rsp.CallProtocolRspBO;
import com.ohaotian.plugin.model.bo.rsp.PluginHpartyCheckRspBO;
import com.ohaotian.plugin.service.PluginHpartyCheckService;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/hpartyCheck"})
public class HpartyCheckController {
    private static final Logger log = LoggerFactory.getLogger(HpartyCheckController.class);
    @Resource
    PluginAPI pluginApi;
    private static final String INPUT = "\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}";
    private static final String UNSPECIFIED = "\u672a\u6307\u5b9a\u62fc\u88c5\u5185\u5bb9";
    @Autowired
    private PluginHpartyCheckService pluginHpartyCheckService;

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO<PluginRspBO> getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        log.debug(INPUT, (Object)pluginReqBO);
        if (ObjectUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginApi.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        log.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO<PluginHpartyCheckRspBO> getPluginExtInfo(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        log.debug(INPUT, (Object)pluginHpartyCheckReqBO);
        return this.pluginHpartyCheckService.pluginExtInfo(pluginHpartyCheckReqBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO<String> modPluginExt(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        log.debug(INPUT, (Object)pluginHpartyCheckReqBO);
        if (ObjectUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginHpartyCheckReqBO.getAppRegion() == null || pluginHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginHpartyCheckReqBO.getAppendContents() == null || pluginHpartyCheckReqBO.getAppendContents().isEmpty()) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (ObjectUtils.isEmpty((Object)pluginHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        return this.pluginHpartyCheckService.modPluginExt(pluginHpartyCheckReqBO);
    }

    @PostMapping(value={"allCallProtocol"})
    @BusiResponseBody
    public RspBO<List<CallProtocolRspBO>> allCallProtocol() {
        ArrayList<CallProtocolRspBO> callProtocolRspBos = new ArrayList<CallProtocolRspBO>();
        CallProtocolRspBO callProtocolRspBoJson = new CallProtocolRspBO("json", CallProtocolEnum.JSON.getCode());
        CallProtocolRspBO callProtocolRspBoForm = new CallProtocolRspBO("form", CallProtocolEnum.FROM.getCode());
        callProtocolRspBos.add(callProtocolRspBoJson);
        callProtocolRspBos.add(callProtocolRspBoForm);
        return RspBO.success(callProtocolRspBos);
    }

    @PostMapping(value={"allAppend"})
    @BusiResponseBody
    public RspBO<List<AppendRspBO>> allAppend() {
        ArrayList<AppendRspBO> appendRspBos = new ArrayList<AppendRspBO>();
        AppendRspBO appendRspBoToken = new AppendRspBO("token", AppendEnum.TOKEN.getCode());
        AppendRspBO appendRspBoType = new AppendRspBO("\u56fa\u5b9a\u503c", AppendEnum.TYPE.getCode());
        AppendRspBO appendRspBoAppkey = new AppendRspBO("clientId", AppendEnum.APPKEY.getCode());
        AppendRspBO appendRspBoUsername = new AppendRspBO("username", AppendEnum.USERNAME.getCode());
        appendRspBos.add(appendRspBoToken);
        appendRspBos.add(appendRspBoType);
        appendRspBos.add(appendRspBoAppkey);
        appendRspBos.add(appendRspBoUsername);
        return RspBO.success(appendRspBos);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO<Boolean> execute(@RequestBody PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        if (ObjectUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginHpartyCheckReqBO.getAppRegion() == null || pluginHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getUserName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getUserPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u5bc6\u7801");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)pluginHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginHpartyCheckReqBO.getAppendContents() == null || pluginHpartyCheckReqBO.getAppendContents().isEmpty()) {
            throw new ZTBusinessException(UNSPECIFIED);
        }
        if (ObjectUtils.isEmpty((Object)pluginHpartyCheckReqBO.getCallProtocol())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u534f\u8bae");
        }
        if (pluginHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        return this.pluginHpartyCheckService.execute(pluginHpartyCheckReqBO);
    }
}

