/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.PluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.po.HpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.PluginHpartyCheckPO;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="hpartyCheck", position=ExtensionPointPositionEnum.PLUGIN_POSITION)
public class HpartyCheckPluginHandler
extends AbstractPluginHandler<Map> {
    private static final Logger log = LogManager.getLogger(HpartyCheckPluginHandler.class);
    @Value(value="classpath:static/data/HpartyCheckPlugin.json")
    private org.springframework.core.io.Resource extInfoRes;
    @Resource
    PluginHpartyCheckMapper pluginHpartyCheckMapper;
    @Resource
    HpartyCheckAppendMapper hpartyCheckAppendMapper;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;

    public RspBO handleGetInfo() throws ZTBusinessException {
        log.debug("\u67e5\u8be2\u8def\u7531\u63d2\u4ef6\u4fe1\u606f");
        try {
            String extIfo = IOUtils.toString((InputStream)this.extInfoRes.getInputStream(), (Charset)Charset.forName("UTF-8"));
            Object parse = JSON.parse((String)extIfo);
            return RspBO.success((Object)parse);
        }
        catch (IOException e) {
            throw new ZTBusinessException("\u83b7\u53d6route-plugin\u63d2\u4ef6\u6269\u5c55\u70b9\u6570\u636e\u5f02\u5e38");
        }
    }

    public RspBO handleAdd(Map pluginHpartyCheckMap) throws ZTBusinessException {
        Long userId = Long.valueOf(UserHolder.getUserId());
        try {
            PluginHpartyCheckReqBO pluginHpartyCheckReqBO = (PluginHpartyCheckReqBO)BeanMapper.map((Object)pluginHpartyCheckMap, PluginHpartyCheckReqBO.class);
            ValidBatchUtils.isNotEmpty((Object)pluginHpartyCheckReqBO, (String[])new String[]{"appRegion", "clientId", "clientSecret", "userName", "userPassword", "tokenPath", "refreshInterval", "callProtocol", "appendContents"});
            boolean isValid = CronCheckUtil.isValidExpression(pluginHpartyCheckReqBO.getRefreshInterval());
            if (!isValid) {
                throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
            }
            Long pluginId = pluginHpartyCheckReqBO.getPluginId();
            PluginHpartyCheckPO pluginHpartyCheckPO = (PluginHpartyCheckPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, PluginHpartyCheckPO.class);
            pluginHpartyCheckPO.setRegionCode(pluginHpartyCheckReqBO.getAppRegion()[1]);
            pluginHpartyCheckPO.setCreateTime(new Date());
            pluginHpartyCheckPO.setCreateUserId(userId);
            this.pluginHpartyCheckMapper.insertSelective(pluginHpartyCheckPO);
            List appends = pluginHpartyCheckReqBO.getAppendContents();
            ArrayList<HpartyCheckAppendPO> hpartyCheckAppendPOS = new ArrayList<HpartyCheckAppendPO>();
            for (String append : appends) {
                HpartyCheckAppendPO hpartyCheckAppendPO = new HpartyCheckAppendPO();
                hpartyCheckAppendPO.setPluginId(pluginId);
                hpartyCheckAppendPO.setAppendContent(append);
                hpartyCheckAppendPOS.add(hpartyCheckAppendPO);
            }
            this.hpartyCheckAppendMapper.insertRecords(hpartyCheckAppendPOS);
            return RspBO.success(null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public RspBO handleDelete(Map pluginHpartyCheckMap) throws ZTBusinessException {
        try {
            PluginHpartyCheckReqBO pluginHpartyCheckReqBO = (PluginHpartyCheckReqBO)BeanMapper.map((Object)pluginHpartyCheckMap, PluginHpartyCheckReqBO.class);
            this.pluginHpartyCheckMapper.deleteByPluginId(pluginHpartyCheckReqBO.getPluginId());
            this.hpartyCheckAppendMapper.deleteByPluginId(pluginHpartyCheckReqBO.getPluginId());
            this.hpartyCheckTokenMapper.deleteByPluginId(pluginHpartyCheckReqBO.getPluginId());
            return RspBO.success(null);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ZTBusinessException(e.getMessage());
        }
    }
}

