/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.PluginHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.rsp.PluginHpartyCheckRspBO;
import com.ohaotian.plugin.model.po.HpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginHpartyCheckPO;
import com.ohaotian.plugin.service.AbilityHpartyCheckHandler;
import com.ohaotian.plugin.service.PluginHpartyCheckService;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.ClusterApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.bo.ClusterBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import com.ohaotian.portalcommon.util.GsonUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class PluginHpartyCheckServiceImpl
implements PluginHpartyCheckService {
    private static final Logger log = LoggerFactory.getLogger(PluginHpartyCheckServiceImpl.class);
    @Resource
    private AppAPI appApi;
    @Resource
    private RegionAPI regionApi;
    @Resource
    private ClusterApi clusterApi;
    @Resource
    private PluginAPI pluginApi;
    @Autowired
    private CacheClient cacheClient;
    @Resource
    private PluginHpartyCheckMapper pluginHpartyCheckMapper;
    @Resource
    private HpartyCheckAppendMapper hpartyCheckAppendMapper;
    @Resource
    private HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    AbilityHpartyCheckHandler abilityHpartyCheckHandler;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Resource
    private AuthorityService authorityService;
    @Autowired
    private RefreshTokenPath refreshTokenPath;
    @Value(value="${server.port}")
    private Integer port;

    @Override
    public RspBO<String> modPluginExt(PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        PluginHpartyCheckPO oldPo = new PluginHpartyCheckPO();
        oldPo.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        oldPo = this.pluginHpartyCheckMapper.queryLimitOne(oldPo);
        PluginHpartyCheckPO pluginHpartyCheckPo = (PluginHpartyCheckPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, PluginHpartyCheckPO.class);
        pluginHpartyCheckPo.setRegionCode(pluginHpartyCheckReqBO.getAppRegion()[1]);
        this.pluginHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginHpartyCheckPo);
        PluginHpartyCheckPO pluginHpartyCheckPO1 = new PluginHpartyCheckPO();
        pluginHpartyCheckPO1.setPluginHpartyCheckId(pluginHpartyCheckPo.getPluginHpartyCheckId());
        pluginHpartyCheckPO1 = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO1);
        Long pluginId = pluginHpartyCheckPO1.getPluginId();
        this.hpartyCheckAppendMapper.deleteByPluginId(pluginId);
        List appends = pluginHpartyCheckReqBO.getAppendContents();
        ArrayList<HpartyCheckAppendPO> hpartyCheckAppendPOS = new ArrayList<HpartyCheckAppendPO>();
        for (String append : appends) {
            HpartyCheckAppendPO hpartyCheckAppendPO = new HpartyCheckAppendPO();
            hpartyCheckAppendPO.setPluginId(pluginId);
            hpartyCheckAppendPO.setAppendContent(append);
            hpartyCheckAppendPOS.add(hpartyCheckAppendPO);
        }
        this.hpartyCheckAppendMapper.insertRecords(hpartyCheckAppendPOS);
        HpartyCheckTokenPO hpartyCheckTokenPO = new HpartyCheckTokenPO();
        hpartyCheckTokenPO.setPluginId(pluginId);
        hpartyCheckTokenPO.setClientId(oldPo.getClientId());
        hpartyCheckTokenPO.setUserName(oldPo.getUserName());
        hpartyCheckTokenPO.setUserPassword(oldPo.getUserPassword());
        hpartyCheckTokenPO.setTokenPath(oldPo.getTokenPath());
        hpartyCheckTokenPO.setClientSecret(oldPo.getClientSecret());
        HpartyCheckTokenPO oldTokenPO = this.hpartyCheckTokenMapper.queryLimitOne(hpartyCheckTokenPO);
        hpartyCheckTokenPO = (HpartyCheckTokenPO)BeanMapper.map((Object)pluginHpartyCheckReqBO, HpartyCheckTokenPO.class);
        hpartyCheckTokenPO.setHpartyCheckTokenId(oldTokenPO.getHpartyCheckTokenId());
        this.hpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenPO);
        this.pluginApi.updateReginCodeByPluginId(pluginId, pluginHpartyCheckPO1.getRegionCode());
        this.abilityHpartyCheckHandler.dealTask(pluginHpartyCheckReqBO);
        return RspBO.success((Object)"\u4fee\u6539\u6210\u529f");
    }

    @Override
    public RspBO<PluginHpartyCheckRspBO> pluginExtInfo(PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        if (ObjectUtils.isEmpty((Object)pluginHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginHpartyCheckPO pluginHpartyCheckPO = new PluginHpartyCheckPO();
        pluginHpartyCheckPO.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        pluginHpartyCheckPO = this.pluginHpartyCheckMapper.queryLimitOne(pluginHpartyCheckPO);
        PluginHpartyCheckRspBO pluginHpartyCheckRspBO = (PluginHpartyCheckRspBO)BeanMapper.map((Object)pluginHpartyCheckPO, PluginHpartyCheckRspBO.class);
        AppBO appBO = this.appApi.queryAppByRegionCode(tenantId, pluginHpartyCheckPO.getRegionCode());
        RegionBO regionBO = this.regionApi.queryRegionByAppIdAndRegionCode(appBO.getAppId(), pluginHpartyCheckPO.getRegionCode());
        pluginHpartyCheckRspBO.setAppId(appBO.getAppId());
        pluginHpartyCheckRspBO.setAppRegionName(appBO.getAppName() + "/" + regionBO.getRegionName());
        String[] appRegion = new String[]{appBO.getAppId().toString(), regionBO.getRegionCode()};
        pluginHpartyCheckRspBO.setAppRegion(appRegion);
        List<HpartyCheckAppendPO> hpartyCheckAppendPos = this.hpartyCheckAppendMapper.queryByPluginId(pluginHpartyCheckReqBO.getPluginId());
        ArrayList<String> appends = new ArrayList<String>();
        for (HpartyCheckAppendPO hpartyCheckAppendPo : hpartyCheckAppendPos) {
            appends.add(hpartyCheckAppendPo.getAppendContent());
        }
        pluginHpartyCheckRspBO.setAppendContents(appends);
        HpartyCheckTokenPO entity = new HpartyCheckTokenPO();
        entity.setPluginId(pluginHpartyCheckReqBO.getPluginId());
        entity = this.hpartyCheckTokenMapper.queryLimitOne(entity);
        List clusterBOList = this.clusterApi.qryAllCluster();
        LinkedList<String> keyStatus = new LinkedList<String>();
        for (ClusterBO clusterBO : clusterBOList) {
            String key = this.constantBaseVersion.getATP() + "hpartyCheck-" + clusterBO.getClusterId() + "-" + pluginHpartyCheckRspBO.getRegionCode();
            Object value = this.cacheClient.get(key);
            if (ObjectUtils.isEmpty((Object)value)) continue;
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)value.toString(), AbilityRedisTokenDataBo.class);
            Long expireTime = this.cacheClient.getExpireTimeByKey(key);
            String desc = clusterBO.getClusterName() + "(" + expireTime + "\u79d2\u540e\u5931\u6548)";
            if (ObjectUtils.isEmpty((Object)entity)) {
                desc = desc + " token\u8bb0\u5f55\u8868\u67e5\u8be2\u5f02\u5e38\uff01";
            } else if (!abilityRedisTokenDataBo.getToken().equals(entity.getAccessToken())) {
                desc = desc + " " + entity.getAccessToken();
            }
            keyStatus.add(desc);
        }
        pluginHpartyCheckRspBO.setKeyStatus(String.join((CharSequence)",", keyStatus));
        String tokenPathAll = this.refreshTokenPath.getIpPort(pluginHpartyCheckRspBO.getTokenPath(), "/plat/template/noauth/hpartyCheck/accessToken", pluginHpartyCheckPO.getRegionCode());
        pluginHpartyCheckRspBO.setTokenAddress(tokenPathAll);
        return RspBO.success((Object)pluginHpartyCheckRspBO);
    }

    @Override
    public RspBO<Boolean> execute(PluginHpartyCheckReqBO pluginHpartyCheckReqBO) {
        pluginHpartyCheckReqBO.setTokenPath(pluginHpartyCheckReqBO.getTokenPath().replace("http://127.0.0.1:" + this.port, ""));
        this.abilityHpartyCheckHandler.execute(pluginHpartyCheckReqBO);
        return RspBO.success((Object)true);
    }
}

