/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginHpartyCheckMapper;
import com.ohaotian.plugin.mapper.HpartyCheckAppendMapper;
import com.ohaotian.plugin.mapper.HpartyCheckTokenMapper;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.DaYaoErpRefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.plugin.model.po.AbilityPluginHpartyCheckPO;
import com.ohaotian.plugin.model.po.HpartyCheckAppendPO;
import com.ohaotian.plugin.model.po.HpartyCheckTokenPO;
import com.ohaotian.plugin.model.vo.HpartyCheckTokenVO;
import com.ohaotian.plugin.util.HpartyCheckHttpUtil;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import com.ohaotian.portalcommon.util.JDToken;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class TokenRefreshLogic {
    private static final Logger log = LoggerFactory.getLogger(TokenRefreshLogic.class);
    private static final String DAYAO = "dayao_erp_";
    @Autowired
    private RefreshTokenPath refreshTokenPath;
    @Resource
    HpartyCheckTokenMapper hpartyCheckTokenMapper;
    @Resource
    AbilityPluginHpartyCheckMapper abilityPluginHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    HpartyCheckAppendMapper hpartyCheckAppendMapper;
    @Resource
    CacheClient cacheClient;
    @Resource
    private PluginAPI pluginAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private AbilityGeminiService abilityGeminiService;

    public void doLogic(HpartyCheckTokenVO hpartyCheckTokenVO) {
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(hpartyCheckTokenVO.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname() + "|" + pluginRspBO.getPluginNotice();
        log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### hpartyCheck ###### START", (Object)abilityNameAll);
        RefreshTokenReqBO refreshTokenReqBO = (RefreshTokenReqBO)BeanMapper.map((Object)hpartyCheckTokenVO, RefreshTokenReqBO.class);
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        refreshTokenReqBO.setTimestamp(now.format(ofPattern));
        refreshTokenReqBO.setTimeStampSpare(now.format(ofPattern));
        HashMap<String, String> headerMap = new HashMap<String, String>();
        if (!StringUtils.isEmpty((Object)hpartyCheckTokenVO.getTokenHeader())) {
            String[] entitys;
            String header = hpartyCheckTokenVO.getTokenHeader();
            for (String entity : entitys = header.split(",")) {
                String[] strs = entity.split(":");
                if (strs.length != 2) {
                    throw new ZTBusinessException("\u5237\u65b0\u8bf7\u6c42\u5934\u914d\u7f6e\u9519\u8bef\uff01");
                }
                headerMap.put(strs[0], strs[1]);
            }
        }
        log.info("\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)hpartyCheckTokenVO));
        log.info("\u8bf7\u6c42\u5934\uff1a{}", (Object)GsonUtil.toJson(headerMap));
        if (pluginRspBO.getPluginEname().contains(DAYAO)) {
            this.dayaoErpPluginHandler(hpartyCheckTokenVO, refreshTokenReqBO, headerMap, abilityNameAll);
        } else {
            this.defaultPluginHandler(hpartyCheckTokenVO, refreshTokenReqBO, headerMap, abilityNameAll);
        }
    }

    private void defaultPluginHandler(HpartyCheckTokenVO hpartyCheckTokenVO, RefreshTokenReqBO refreshTokenReqBO, Map<String, String> headerMap, String abilityNameAll) {
        refreshTokenReqBO.setGrantType("access_token");
        AbilityGeminiSendMsgReqBo abilityGeminiSendMsgReqBo = new AbilityGeminiSendMsgReqBo();
        int rspHttpStatus = 200;
        try {
            abilityGeminiSendMsgReqBo.setPluginName(abilityNameAll.split("\\|")[0]);
            String url = this.refreshTokenPath.getAll(hpartyCheckTokenVO.getTokenPath().trim(), "/plat/template/noauth/hpartyCheck/accessToken", hpartyCheckTokenVO.getRegionCode());
            log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
            if (hpartyCheckTokenVO.getCallProtocol() == 0) {
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostJson");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)refreshTokenReqBO));
                rspHttpStatus = HpartyCheckHttpUtil.doPostJson(url, GsonUtil.toJson((Object)refreshTokenReqBO), (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8fd4\u56de\u62a5\u6587: {}", map);
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                        abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
                        abilityGeminiSendMsgReqBo.setErrorMsg(map);
                        this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), map.length() < 500 ? map : map.substring(0, 500), null);
                        return status;
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                        this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), map.length() < 500 ? map : map.substring(0, 500), null);
                        abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
                        abilityGeminiSendMsgReqBo.setErrorMsg(map);
                        return Math.negateExact(200);
                    }
                    log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)hpartyCheckTokenVO.getRegionCode());
                    log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                    Long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), token, new Date(time.getTime() + duration));
                    this.setRedis(hpartyCheckTokenVO, token, Math.toIntExact(refreshTokenRspBO.getResult().getExpires_in()));
                    abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                    return status;
                }, headerMap);
            } else {
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("client_id", refreshTokenReqBO.getClientId());
                paramsMap.put("client_secret", refreshTokenReqBO.getClientSecret());
                paramsMap.put("username", refreshTokenReqBO.getUserName());
                paramsMap.put("password", refreshTokenReqBO.getUserPassword());
                paramsMap.put("timestamp", String.valueOf(new Date()));
                paramsMap.put("grant_type", "access_token");
                if (hpartyCheckTokenVO.getRegionCode().contains("jd")) {
                    paramsMap.put("timestamp", refreshTokenReqBO.getTimestamp());
                    String password = JDToken.getMD5Str((String)refreshTokenReqBO.getUserPassword());
                    String sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + "access_token" + refreshTokenReqBO.getClientSecret();
                    sign = JDToken.getMD5Str((String)sign).toUpperCase();
                    paramsMap.put("sign", sign);
                    paramsMap.put("password", password);
                    paramsMap.remove("client_secret");
                }
                log.info("\u8bf7\u6c42\u65b9\u5f0f\uff1adoPostForm");
                log.info("\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson(paramsMap));
                rspHttpStatus = (Integer)HttpUtil.doPost((String)url, (status, map) -> {
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8fd4\u56de\u62a5\u6587: {}", map);
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                        this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), map.length() < 500 ? map : map.substring(0, 500), null);
                        abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
                        abilityGeminiSendMsgReqBo.setErrorMsg(map);
                        return status;
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                        this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), map.length() < 500 ? map : map.substring(0, 500), null);
                        abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
                        abilityGeminiSendMsgReqBo.setErrorMsg(map);
                        return Math.negateExact(200);
                    }
                    Long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), token, new Date(time.getTime() + duration));
                    log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)hpartyCheckTokenVO.getRegionCode());
                    log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                    this.setRedis(hpartyCheckTokenVO, token, Math.toIntExact(refreshTokenRspBO.getResult().getExpires_in()));
                    abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                    return status;
                }, paramsMap);
            }
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5f02\u5e38:\uff0ctoken\u8bb0\u5f55id:{},ex:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId(), (Object)e);
            abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
            abilityGeminiSendMsgReqBo.setErrorMsg(e.getMessage());
            throw new ZTBusinessException("token\u5237\u65b0\u5f02\u5e38! ex:" + e.getMessage());
        }
        finally {
            if (Objects.equals(abilityNameAll.split("\\|")[2], String.valueOf(1))) {
                JSONObject rspBO = this.abilityGeminiService.sendMessage(abilityGeminiSendMsgReqBo);
                log.info("\u901a\u77e5\u7ed3\u679c\uff1a{}", (Object)rspBO);
            }
        }
        if (!Objects.equals(200, rspHttpStatus)) {
            HpartyCheckTokenPO entity = new HpartyCheckTokenPO();
            entity.setHpartyCheckTokenId(hpartyCheckTokenVO.getHpartyCheckTokenId());
            entity = this.hpartyCheckTokenMapper.queryLimitOne(entity);
            throw new ZTBusinessException("\u5237\u65b0\u5f02\u5e38\uff01Status:" + Math.abs(rspHttpStatus) + " RSP:" + entity.getAccessToken());
        }
        log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
    }

    private void dayaoErpPluginHandler(HpartyCheckTokenVO hpartyCheckTokenVO, RefreshTokenReqBO refreshTokenReqBO, Map<String, String> headerMap, String abilityNameAll) {
        try {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("username", refreshTokenReqBO.getUserName());
            paramsMap.put("password", refreshTokenReqBO.getUserPassword());
            paramsMap.put("grant_type", "password");
            HpartyCheckHttpUtil.doPost(hpartyCheckTokenVO.getTokenPath().trim(), (status, map) -> {
                if (status != 200) {
                    log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                    return null;
                }
                DaYaoErpRefreshTokenRspBO refreshTokenRspBO = (DaYaoErpRefreshTokenRspBO)GsonUtil.fromJson((String)map, DaYaoErpRefreshTokenRspBO.class);
                log.info("\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                if (!refreshTokenRspBO.isSuccess()) {
                    log.error("token\u5237\u65b0\u9519\u8bef:\uff0ctoken\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                    return null;
                }
                log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)hpartyCheckTokenVO.getRegionCode());
                log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId());
                Long duration = refreshTokenRspBO.getData().getExpires_in() * 1000L;
                Date time = new Date();
                String token = "Bearer " + refreshTokenRspBO.getData().getAccess_token();
                this.updateToken(hpartyCheckTokenVO.getHpartyCheckTokenId(), token, new Date(time.getTime() + duration));
                this.setRedis(hpartyCheckTokenVO, token, Math.toIntExact(refreshTokenRspBO.getData().getExpires_in()));
                return status;
            }, paramsMap, headerMap);
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5f02\u5e38:\uff0ctoken\u8bb0\u5f55id:{}", (Object)hpartyCheckTokenVO.getHpartyCheckTokenId(), (Object)e);
            throw new ZTBusinessException("token\u5237\u65b0\u5f02\u5e38!");
        }
        finally {
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private void updateToken(Long hpartyCheckTokenId, String token, Date expiresIn) {
        HpartyCheckTokenPO hpartyCheckTokenPO = new HpartyCheckTokenPO();
        hpartyCheckTokenPO.setHpartyCheckTokenId(hpartyCheckTokenId);
        hpartyCheckTokenPO.setAccessToken(token);
        hpartyCheckTokenPO.setExpiresIn(expiresIn);
        hpartyCheckTokenPO.setUpdateTime(new Date());
        this.hpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(hpartyCheckTokenPO);
    }

    public void setRedis(HpartyCheckTokenVO hpartyCheckTokenVO, String token, int expires) {
        List abilityPluginDeployIds;
        List abilityPluginDeployRspBOS;
        AbilityPluginHpartyCheckPO abilityPluginHpartyCheckPO = new AbilityPluginHpartyCheckPO();
        abilityPluginHpartyCheckPO.setHpartyCheckTokenId(hpartyCheckTokenVO.getHpartyCheckTokenId());
        List<AbilityPluginHpartyCheckPO> abilityPluginHpartyCheckPOS = this.abilityPluginHpartyCheckMapper.queryByCond(abilityPluginHpartyCheckPO);
        if (abilityPluginHpartyCheckPOS != null && abilityPluginHpartyCheckPOS.size() != 0 && (abilityPluginDeployRspBOS = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds = abilityPluginHpartyCheckPOS.stream().map(AbilityPluginHpartyCheckPO::getAbilityPluginDeployId).collect(Collectors.toList()))) != null && abilityPluginDeployRspBOS.size() != 0) {
            abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).distinct().forEach(i -> {
                AbilityRedisTokenDataBo abilityRedisTokenDataBo = new AbilityRedisTokenDataBo();
                abilityRedisTokenDataBo.setPluginId(hpartyCheckTokenVO.getPluginId().toString());
                abilityRedisTokenDataBo.setClientId(hpartyCheckTokenVO.getClientId());
                abilityRedisTokenDataBo.setClientSecret("");
                abilityRedisTokenDataBo.setAccName(hpartyCheckTokenVO.getUserName());
                abilityRedisTokenDataBo.setCallProtocol(hpartyCheckTokenVO.getCallProtocol());
                abilityRedisTokenDataBo.setTokenPath("");
                abilityRedisTokenDataBo.setToken(token);
                abilityRedisTokenDataBo.setRefreshInterval("");
                abilityRedisTokenDataBo.setTokenPosition(Integer.valueOf(0));
                abilityRedisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
                abilityRedisTokenDataBo.setHsn("");
                abilityRedisTokenDataBo.setOrgId("");
                abilityRedisTokenDataBo.setCompanyName("");
                abilityRedisTokenDataBo.setRegionCode(hpartyCheckTokenVO.getRegionCode());
                List<HpartyCheckAppendPO> hpartyCheckAppendPOS = this.hpartyCheckAppendMapper.queryByCond(HpartyCheckAppendPO.builder().pluginId(hpartyCheckTokenVO.getPluginId()).build());
                abilityRedisTokenDataBo.setAppends(hpartyCheckAppendPOS.stream().map(HpartyCheckAppendPO::getAppendContent).collect(Collectors.joining(",")));
                String key = this.constantBaseVersion.getATP() + "hpartyCheck-" + i + "-" + hpartyCheckTokenVO.getRegionCode();
                log.info("token\u5237\u65b0\u6210\u529f: \u5199\u5165Redis->" + key);
                this.cacheClient.set(key, (Object)GsonUtil.toJson((Object)abilityRedisTokenDataBo), expires);
            });
        }
    }
}

