/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginExtIpMapper;
import com.ohaotian.plugin.model.bo.req.AbilityPluginExtIpReqBO;
import com.ohaotian.plugin.model.bo.req.SaveExtIpReqBO;
import com.ohaotian.plugin.model.bo.rsp.AbilityPluginExtIpRspBO;
import com.ohaotian.plugin.model.po.AbilityPluginExtIpPO;
import com.ohaotian.plugin.service.AbilityPluginExtIpService;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.ClusterApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.PluginEnum;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.bo.ClusterBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.AppInfoUtil;
import com.ohaotian.portalcommon.util.IpCheckUtil;
import com.ohaotian.portalcommon.util.SqlUtil;
import com.ohaotian.portalcommon.util.StrUtil;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class AbilityPluginExtIpServiceImpl
implements AbilityPluginExtIpService {
    private static Logger logger = LogManager.getLogger(AbilityPluginExtIpServiceImpl.class);
    @Resource
    AbilityPluginExtIpMapper abilityPluginExtIpMapper;
    @Resource
    private AppAPI appAPI;
    @Resource
    private ClusterApi clusterApi;
    @Resource
    private PluginAPI pluginAPI;
    @Resource
    private AuthorityService authorityService;

    @Override
    public Long insertSelective(AbilityPluginExtIpPO entity) {
        return this.abilityPluginExtIpMapper.insertSelective(entity);
    }

    @Override
    public int insertRecords(List<AbilityPluginExtIpPO> records) {
        return this.abilityPluginExtIpMapper.insertRecords(records);
    }

    @Override
    public AbilityPluginExtIpPO queryLimitOne(AbilityPluginExtIpPO entity) {
        return this.abilityPluginExtIpMapper.queryLimitOne(entity);
    }

    @Override
    public List<AbilityPluginExtIpPO> queryByPluginIpIds(List<Long> pluginIpIds) {
        return this.abilityPluginExtIpMapper.queryByPluginIpIds(pluginIpIds);
    }

    @Override
    public List<AbilityPluginExtIpPO> queryByCond(AbilityPluginExtIpPO entity) {
        return this.abilityPluginExtIpMapper.queryByCond(entity);
    }

    @Override
    public AbilityPluginExtIpPO queryByPluginIpId(Long pluginIpId) {
        return this.abilityPluginExtIpMapper.queryByPluginIpId(pluginIpId);
    }

    @Override
    public int updateAbilityPluginExtIpByPluginIpId(AbilityPluginExtIpPO entity) {
        return this.abilityPluginExtIpMapper.updateAbilityPluginExtIpByPluginIpId(entity);
    }

    @Override
    public int deleteAbilityPluginExtIpByPluginIpId(Long pluginIpId) {
        return this.abilityPluginExtIpMapper.deleteAbilityPluginExtIpByPluginIpId(pluginIpId);
    }

    @Override
    public int deleteAbilityPluginExtIpByIds(List<Long> pluginIpIds) {
        return this.abilityPluginExtIpMapper.deleteAbilityPluginExtIpByIds(pluginIpIds);
    }

    @Override
    public List<AbilityPluginExtIpRspBO> queryIpWhiteList(Long pluginId, Long clusterId, List<AppBO> appBOList) {
        AppInfoUtil.AppInfo appInfo = AppInfoUtil.getAppMap(appBOList);
        Map appBOMap = appInfo.getAppBOMap();
        List appCodes = appInfo.getAppCodes();
        List<AbilityPluginExtIpPO> abilityPluginExtIpPOList = this.abilityPluginExtIpMapper.queryIpWhiteList(pluginId, clusterId, appCodes);
        ArrayList<AbilityPluginExtIpRspBO> abilityPluginExtIpRspBOList = new ArrayList<AbilityPluginExtIpRspBO>();
        for (AbilityPluginExtIpPO abilityPluginExtIpPO : abilityPluginExtIpPOList) {
            AbilityPluginExtIpRspBO abilityPluginExtIpRspBO = (AbilityPluginExtIpRspBO)BeanMapper.map((Object)abilityPluginExtIpPO, AbilityPluginExtIpRspBO.class);
            abilityPluginExtIpRspBO.setAppName(((AppBO)appBOMap.get(abilityPluginExtIpPO.getAppCode())).getAppName());
            abilityPluginExtIpRspBO.setAppCode(abilityPluginExtIpPO.getAppCode());
            ClusterBO clusterBO = this.clusterApi.qryClusterById(abilityPluginExtIpPO.getClusterId());
            abilityPluginExtIpRspBO.setClusterName(clusterBO.getClusterName());
            abilityPluginExtIpRspBOList.add(abilityPluginExtIpRspBO);
        }
        return abilityPluginExtIpRspBOList;
    }

    @Override
    public RspBO<RspPage<AbilityPluginExtIpRspBO>> qryIpListPage(AbilityPluginExtIpReqBO abilityPluginExtIpReqBO) {
        if (StringUtils.isEmpty((Object)abilityPluginExtIpReqBO.getAppId())) {
            throw new ZTBusinessException(CodeMsg.APP_ARG_ERROR.getMessage());
        }
        AppBO appBO = this.appAPI.queryAppByAppId(abilityPluginExtIpReqBO.getAppId());
        StringBuilder order = new StringBuilder();
        if (!StringUtils.isEmpty((Object)abilityPluginExtIpReqBO.getSortName())) {
            order.append(StrUtil.CamelToUnderline((String)abilityPluginExtIpReqBO.getSortName()));
            if (!StringUtils.isEmpty((Object)abilityPluginExtIpReqBO.getSortOrder())) {
                order.append(" ").append(abilityPluginExtIpReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = !StringUtils.isEmpty((Object)order) ? PageHelper.startPage((int)abilityPluginExtIpReqBO.getPageNo(), (int)abilityPluginExtIpReqBO.getPageSize(), (String)order.toString()) : PageHelper.startPage((int)abilityPluginExtIpReqBO.getPageNo(), (int)abilityPluginExtIpReqBO.getPageSize());
        AbilityPluginExtIpPO abilityPluginJwtExtPO = new AbilityPluginExtIpPO();
        abilityPluginJwtExtPO.setAppCode(appBO.getAppCode());
        List<AbilityPluginExtIpPO> abilityPluginJwtExtPOList = this.abilityPluginExtIpMapper.queryByCond(abilityPluginJwtExtPO);
        ArrayList abilityPluginJwtExtRspBOList = new ArrayList();
        abilityPluginJwtExtPOList.forEach(param -> {
            AbilityPluginExtIpRspBO abilityPluginJwtExtRspBO = (AbilityPluginExtIpRspBO)BeanMapper.map((Object)param, AbilityPluginExtIpRspBO.class);
            abilityPluginJwtExtRspBO.setAppName(appBO.getAppName());
            abilityPluginJwtExtRspBO.setAppCode(appBO.getAppCode());
            ClusterBO clusterBO = this.clusterApi.qryClusterById(abilityPluginJwtExtRspBO.getClusterId());
            abilityPluginJwtExtRspBO.setClusterName(clusterBO.getClusterName());
            abilityPluginJwtExtRspBOList.add(abilityPluginJwtExtRspBO);
        });
        RspPage rspPage = new RspPage(Integer.valueOf(abilityPluginExtIpReqBO.getPageSize()), Integer.valueOf(abilityPluginExtIpReqBO.getPageNo()), abilityPluginJwtExtRspBOList, Long.valueOf(page.getTotal()));
        return RspBO.success((Object)rspPage);
    }

    @Override
    public AbilityPluginExtIpRspBO queryPluginExtInfo(Long pluginIpId) {
        AbilityPluginExtIpPO abilityPluginExtIpPO = this.abilityPluginExtIpMapper.queryByPluginIpId(pluginIpId);
        if (abilityPluginExtIpPO == null) {
            throw new ZTBusinessException("\u8be5\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        AbilityPluginExtIpRspBO abilityPluginExtIpRspBO = (AbilityPluginExtIpRspBO)BeanMapper.map((Object)abilityPluginExtIpPO, AbilityPluginExtIpRspBO.class);
        return abilityPluginExtIpRspBO;
    }

    @Override
    public RspBO<Boolean> addPluginExt(SaveExtIpReqBO saveExtIpReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)saveExtIpReqBO);
        ValidBatchUtils.isNotEmpty((Object)saveExtIpReqBO, (String[])new String[]{"appCode", "ipWhileList", "clusterId"});
        if (!IpCheckUtil.isIPAddress((String[])saveExtIpReqBO.getIpWhileList().split(","))) {
            throw new ZTBusinessException("ip\u683c\u5f0f\u9519\u8bef");
        }
        List boList = this.pluginAPI.qryPluginIdByPluginType(PluginEnum.IP_PLUGIN.getCode());
        if (CollectionUtils.isEmpty((Collection)boList)) {
            throw new ZTBusinessException("ip\u63d2\u4ef6\u672a\u5b9e\u4f8b\u5316");
        }
        AbilityPluginExtIpPO po = new AbilityPluginExtIpPO();
        po.setPluginId(((PluginRspBO)boList.get(0)).getPluginId());
        po.setAppCode(saveExtIpReqBO.getAppCode());
        po.setClusterId(saveExtIpReqBO.getClusterId());
        po = this.abilityPluginExtIpMapper.queryLimitOne(po);
        if (po != null) {
            throw new ZTBusinessException("\u5f53\u524d\u5e94\u7528\u4e0b\u5f53\u524d\u96c6\u7fa4\u5df2\u914d\u7f6e\u767d\u540d\u5355\uff01");
        }
        AbilityPluginExtIpPO abilityPluginExtIpPO = (AbilityPluginExtIpPO)BeanMapper.map((Object)saveExtIpReqBO, AbilityPluginExtIpPO.class);
        abilityPluginExtIpPO.setPluginId(((PluginRspBO)boList.get(0)).getPluginId());
        abilityPluginExtIpPO.setCreateTime(new Date());
        abilityPluginExtIpPO.setCreateUserId(userId);
        this.abilityPluginExtIpMapper.insertSelective(abilityPluginExtIpPO);
        return RspBO.success((Object)true);
    }

    @Override
    public RspBO<Boolean> modPluginExt(SaveExtIpReqBO saveExtIpReqBO) {
        Long userId = Long.valueOf(UserHolder.getUserId());
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)saveExtIpReqBO);
        ValidBatchUtils.isNotEmpty((Object)saveExtIpReqBO, (String[])new String[]{"pluginIpId", "appCode", "ipWhileList", "clusterId"});
        if (!IpCheckUtil.isIPAddress((String[])saveExtIpReqBO.getIpWhileList().split(","))) {
            throw new ZTBusinessException("ip\u683c\u5f0f\u9519\u8bef");
        }
        AbilityPluginExtIpPO abilityPluginExtIpPO = (AbilityPluginExtIpPO)BeanMapper.map((Object)saveExtIpReqBO, AbilityPluginExtIpPO.class);
        abilityPluginExtIpPO.setUpdateTime(new Date());
        abilityPluginExtIpPO.setUpdateUserId(userId);
        Integer count = this.abilityPluginExtIpMapper.updateAbilityPluginExtIpByPluginIpId(abilityPluginExtIpPO);
        if (count < 1) {
            throw new ZTBusinessException("\u66f4\u65b0\u5931\u8d25");
        }
        return RspBO.success((Object)true);
    }
}

