/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import cn.hutool.core.util.ObjectUtil;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.AbilityPluginExtIpMapper;
import com.ohaotian.plugin.service.IpSyncDataService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.enums.FisrtLevelEnum;
import com.ohaotian.portalcommon.enums.SecondLevelEnum;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.bo.SyncDataReqBO;
import com.ohaotian.portalcommon.util.ValidBatchUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IpSyncDataServiceImpl
implements IpSyncDataService {
    private Logger log = LogManager.getLogger(IpSyncDataServiceImpl.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    private AbilityPluginExtIpMapper abilityPluginExtIpMapper;
    private static final String PLUGIN_IP = "ability_plugin_ext_ip";

    @Override
    public RspBO syncAllData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 0);
        return RspBO.success(map);
    }

    private Map<String, Object> qryPlugin(SyncDataReqBO syncDataBO, int type) {
        HashMap map = Maps.newHashMap();
        String firstLevel = syncDataBO.getFirstLevel();
        String secondLevel = syncDataBO.getSecondLevel();
        Long primaryId = syncDataBO.getPrimaryId();
        if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN.getCode().equals(secondLevel)) {
            List pluginIds = this.pluginAPI.getPluginIds(syncDataBO);
            if (type == 0) {
                this.log.info("\u5168\u91cf\u67e5\u8be2{}\u8868\u6570\u636e", (Object)PLUGIN_IP);
            } else {
                this.log.info("\u589e\u91cf\u67e5\u8be2{}\u8868\u6570\u636e\uff0c\u4e3b\u952eid\uff1a{}", (Object)PLUGIN_IP, (Object)primaryId);
            }
            List<Object> abilityPluginExtIpBOList = new ArrayList();
            if (!CollectionUtils.isEmpty((Collection)pluginIds)) {
                abilityPluginExtIpBOList = this.abilityPluginExtIpMapper.queryPluginExtIpByPluginIds(pluginIds);
            }
            if (!ObjectUtil.isNull(abilityPluginExtIpBOList)) {
                map.put(PLUGIN_IP, abilityPluginExtIpBOList);
            }
        } else if (FisrtLevelEnum.PLUGIN.getCode().equals(firstLevel) && SecondLevelEnum.PLUGIN_PLUGIN_EXT.getCode().equals(secondLevel)) {
            this.log.info("IP\u63d2\u4ef6\u6ca1\u6709\u7ed1\u5b9a\u6269\u5c55\u4fe1\u606f");
        } else {
            this.log.error("\u8bf7\u586b\u5199\u6b63\u786e\u7684\u540c\u6b65\u6a21\u5757,\u5f53\u524d\u6a21\u5757\u4e3a:{}", (Object)firstLevel);
            throw new ZTBusinessException(CodeMsg.SYNC_ERROR.fillArgs(new Object[]{firstLevel}).getMessage());
        }
        return map;
    }

    @Override
    public RspBO syncIncrementData(SyncDataReqBO syncDataBO) {
        ValidBatchUtils.isNotEmpty((Object)syncDataBO, (String[])new String[]{"clusterId", "hirerId", "firstLevel", "secondLevel", "primaryId"});
        Map<String, Object> map = this.qryPlugin(syncDataBO, 1);
        return RspBO.success(map);
    }
}

