/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.config.QuartzScheduleManager;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.JdHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginJdHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.JdHpartyCheckTokenRspBo;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.plugin.service.JdHpartyCheckService;
import com.ohaotian.plugin.task.JdTokenRefreshLogic;
import com.ohaotian.plugin.task.JdTokenRefreshTask;
import com.ohaotian.portalcommon.api.ClusterApi;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.ClusterBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import com.ohaotian.portalcommon.util.SqlUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class JdHpartyCheckServiceImpl
implements JdHpartyCheckService {
    private Logger log = LogManager.getLogger(JdHpartyCheckServiceImpl.class);
    @Resource
    private PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    private JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    QuartzScheduleManager quartzScheduleManager;
    @Autowired
    private JdTokenRefreshLogic jdTokenRefreshLogic;
    @Resource
    private ClusterApi clusterApi;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    @Override
    public RspBO executeAll(PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        CompletableFuture<Void> runFuture = CompletableFuture.runAsync(() -> {
            HashMap cacheJdToken = new HashMap();
            HashMap cacheJdTokenDuration = new HashMap();
            PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginJdHpartyCheckTaskReqBO.getPluginId());
            JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setPluginId(pluginJdHpartyCheckTaskReqBO.getPluginId());
            List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPOS = this.jdHpartyCheckTokenMapper.queryByCond(jdHpartyCheckTokenPO);
            ((Stream)jdHpartyCheckTokenPOS.stream().parallel()).filter(jd -> 1 == jd.getIsRunning() || 2 == jd.getIsRunning()).forEach(jdToken -> this.jdTokenRefreshLogic.doLogic(cacheJdToken, cacheJdTokenDuration, pluginJdHpartyCheckPO, (JdHpartyCheckTokenPO)jdToken));
        });
        runFuture.whenComplete((result, e) -> {
            this.log.error("\u624b\u52a8\u89e6\u53d1 JD Token \u5f02\u6b65\u6267\u884c\u5f02\u5e38\uff01 ex:{}", (Object)e.getMessage());
            e.printStackTrace();
        });
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO execute(PluginJdHpartyCheckTokenTaskReqBO pluginJdHpartyCheckTokenTaskReqBO) {
        JdHpartyCheckTokenPO jdToken = this.jdHpartyCheckTokenMapper.queryByHpartyCheckTokenId(pluginJdHpartyCheckTokenTaskReqBO.getJdHpartyCheckTokenId());
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        this.jdTokenRefreshLogic.doLogic(new HashMap<String, String>(), new HashMap<String, Long>(), pluginJdHpartyCheckPO, jdToken);
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO start(PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginJdHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(pluginJdHpartyCheckPO.getClientId());
        if (!aBoolean.booleanValue()) {
            pluginJdHpartyCheckPO.setTaskSwitch(1);
            this.pluginJdHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginJdHpartyCheckPO);
            this.quartzScheduleManager.addJob(pluginJdHpartyCheckPO.getClientId(), JdTokenRefreshTask.class, pluginJdHpartyCheckPO.getRefreshInterval(), pluginJdHpartyCheckPO.getPluginId());
        } else {
            pluginJdHpartyCheckPO.setTaskSwitch(1);
            this.pluginJdHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginJdHpartyCheckPO);
            this.quartzScheduleManager.removeJob(pluginJdHpartyCheckPO.getClientId());
            this.quartzScheduleManager.addJob(pluginJdHpartyCheckPO.getClientId(), JdTokenRefreshTask.class, pluginJdHpartyCheckPO.getRefreshInterval(), pluginJdHpartyCheckPO.getPluginId());
        }
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO stop(PluginJdHpartyCheckTaskReqBO pluginJdHpartyCheckTaskReqBO) {
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(pluginJdHpartyCheckTaskReqBO.getPluginId());
        Boolean aBoolean = this.quartzScheduleManager.checkJob(pluginJdHpartyCheckPO.getClientId());
        if (aBoolean.booleanValue()) {
            pluginJdHpartyCheckPO.setTaskSwitch(0);
            this.pluginJdHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginJdHpartyCheckPO);
            this.quartzScheduleManager.removeJob(pluginJdHpartyCheckPO.getClientId());
        } else {
            pluginJdHpartyCheckPO.setTaskSwitch(0);
            this.pluginJdHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginJdHpartyCheckPO);
        }
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO getPluginExtInfoList(PluginJdHpartyCheckTokenReqBO pluginJdHpartyCheckTokenReqBO) {
        PluginJdHpartyCheckPO pluginJdHpartyCheckPo = new PluginJdHpartyCheckPO();
        pluginJdHpartyCheckPo.setPluginId(pluginJdHpartyCheckTokenReqBO.getPluginId());
        pluginJdHpartyCheckPo = this.pluginJdHpartyCheckMapper.queryLimitOne(pluginJdHpartyCheckPo);
        StringBuilder order = new StringBuilder();
        if (pluginJdHpartyCheckTokenReqBO.getSortName() != null) {
            order.append(pluginJdHpartyCheckTokenReqBO.getSortName());
            if (pluginJdHpartyCheckTokenReqBO.getSortOrder() != null) {
                order.append(" ");
                order.append(pluginJdHpartyCheckTokenReqBO.getSortOrder());
            }
        } else {
            order.append(SqlUtil.getDefaultOrderBy());
        }
        Page page = PageMethod.startPage((int)pluginJdHpartyCheckTokenReqBO.getPageNo(), (int)pluginJdHpartyCheckTokenReqBO.getPageSize(), (String)order.toString());
        List<JdHpartyCheckTokenPO> jdHpartyCheckTokenPOS = this.jdHpartyCheckTokenMapper.queryByFuzzyCond(pluginJdHpartyCheckTokenReqBO);
        LinkedList jdHpartyCheckTokenRspBos = new LinkedList();
        PluginJdHpartyCheckPO finalPluginJdHpartyCheckPo = pluginJdHpartyCheckPo;
        jdHpartyCheckTokenPOS.forEach(jdHpartyCheckTokenPO -> {
            JdHpartyCheckTokenRspBo oneRspBo = (JdHpartyCheckTokenRspBo)BeanMapper.map((Object)jdHpartyCheckTokenPO, JdHpartyCheckTokenRspBo.class);
            List clusterBOList = this.clusterApi.qryAllCluster();
            LinkedList<String> keyStatus = new LinkedList<String>();
            for (ClusterBO clusterBO : clusterBOList) {
                String key = this.constantBaseVersion.getATP() + "jdHpartyCheck-" + clusterBO.getClusterId() + "-" + jdHpartyCheckTokenPO.getOrgid() + "-" + finalPluginJdHpartyCheckPo.getRegionCode();
                if (ObjectUtils.isEmpty((Object)this.cacheClient.get(key))) continue;
                keyStatus.add(clusterBO.getClusterName() + "(\u5b58\u5728)");
            }
            oneRspBo.setKeyStatus(String.join((CharSequence)",", keyStatus));
            jdHpartyCheckTokenRspBos.add(oneRspBo);
        });
        RspPage rspPage = new RspPage(Integer.valueOf(pluginJdHpartyCheckTokenReqBO.getPageSize()), Integer.valueOf(pluginJdHpartyCheckTokenReqBO.getPageNo()), jdHpartyCheckTokenRspBos, Long.valueOf(page.getTotal()));
        RspBO rspBO = RspBO.success((Object)rspPage);
        this.log.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @Override
    public ResponseVO put(JdHpartyCheckTokenReqBO jdHpartyCheckTokenReqBO) {
        List<PluginJdHpartyCheckPO> pluginJdHpartyCheckPOS = this.pluginJdHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginJdHpartyCheckPOS.get(0).getPluginId();
        JdHpartyCheckTokenPO jdHpartyCheckTokenPO = this.jdHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, jdHpartyCheckTokenReqBO.getOrgid());
        if (jdHpartyCheckTokenPO != null) {
            jdHpartyCheckTokenPO.setUpdateTime(new Date());
            jdHpartyCheckTokenPO.setUserName(jdHpartyCheckTokenReqBO.getUsername());
            jdHpartyCheckTokenPO.setUserPassword(jdHpartyCheckTokenReqBO.getPassword());
            jdHpartyCheckTokenPO.setCompanyName(jdHpartyCheckTokenReqBO.getCompanyName());
            jdHpartyCheckTokenPO.setIsRunning(1);
            this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
        } else {
            jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setPluginId(pluginId);
            jdHpartyCheckTokenPO.setCreateTime(new Date());
            jdHpartyCheckTokenPO.setUserName(jdHpartyCheckTokenReqBO.getUsername());
            jdHpartyCheckTokenPO.setUserPassword(jdHpartyCheckTokenReqBO.getPassword());
            jdHpartyCheckTokenPO.setOrgid(jdHpartyCheckTokenReqBO.getOrgid());
            jdHpartyCheckTokenPO.setCompanyName(jdHpartyCheckTokenReqBO.getCompanyName());
            jdHpartyCheckTokenPO.setIsRunning(1);
            this.jdHpartyCheckTokenMapper.insertSelective(jdHpartyCheckTokenPO);
        }
        JdHpartyCheckTokenPO jdToken = this.jdHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, jdHpartyCheckTokenReqBO.getOrgid());
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        this.jdTokenRefreshLogic.doLogic(new HashMap<String, String>(), new HashMap<String, Long>(), pluginJdHpartyCheckPO, jdToken);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO modify(JdHpartyCheckTokenReqBO jdHpartyCheckTokenReqBO) {
        List<PluginJdHpartyCheckPO> pluginJdHpartyCheckPOS = this.pluginJdHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginJdHpartyCheckPOS.get(0).getPluginId();
        JdHpartyCheckTokenPO jdHpartyCheckTokenPO = this.jdHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, jdHpartyCheckTokenReqBO.getOrgid());
        if (jdHpartyCheckTokenPO != null) {
            jdHpartyCheckTokenPO.setUpdateTime(new Date());
            jdHpartyCheckTokenPO.setUserName(jdHpartyCheckTokenReqBO.getUsername());
            jdHpartyCheckTokenPO.setUserPassword(jdHpartyCheckTokenReqBO.getPassword());
            jdHpartyCheckTokenPO.setCompanyName(jdHpartyCheckTokenReqBO.getCompanyName());
            this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
        } else {
            jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setPluginId(pluginId);
            jdHpartyCheckTokenPO.setCreateTime(new Date());
            jdHpartyCheckTokenPO.setUserName(jdHpartyCheckTokenReqBO.getUsername());
            jdHpartyCheckTokenPO.setUserPassword(jdHpartyCheckTokenReqBO.getPassword());
            jdHpartyCheckTokenPO.setOrgid(jdHpartyCheckTokenReqBO.getOrgid());
            jdHpartyCheckTokenPO.setCompanyName(jdHpartyCheckTokenReqBO.getCompanyName());
            jdHpartyCheckTokenPO.setIsRunning(1);
            this.jdHpartyCheckTokenMapper.insertSelective(jdHpartyCheckTokenPO);
        }
        JdHpartyCheckTokenPO jdToken = this.jdHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, jdHpartyCheckTokenReqBO.getOrgid());
        PluginJdHpartyCheckPO pluginJdHpartyCheckPO = this.pluginJdHpartyCheckMapper.queryByPluginId(jdToken.getPluginId());
        this.jdTokenRefreshLogic.doLogic(new HashMap<String, String>(), new HashMap<String, Long>(), pluginJdHpartyCheckPO, jdToken);
        return ResponseVO.success();
    }

    @Override
    public ResponseVO delete(JdHpartyCheckTokenReqBO jdHpartyCheckTokenReqBO) {
        List<PluginJdHpartyCheckPO> pluginJdHpartyCheckPOS = this.pluginJdHpartyCheckMapper.queryAllScheduleTask();
        Long pluginId = pluginJdHpartyCheckPOS.get(0).getPluginId();
        JdHpartyCheckTokenPO jdHpartyCheckTokenPO = this.jdHpartyCheckTokenMapper.queryByPluginIdAndOrgid(pluginId, jdHpartyCheckTokenReqBO.getOrgid());
        if (jdHpartyCheckTokenPO != null) {
            jdHpartyCheckTokenPO.setUpdateTime(new Date());
            jdHpartyCheckTokenPO.setIsRunning(3);
            this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
        }
        return ResponseVO.success();
    }

    @Override
    public RspBO checkIn(PluginJdHpartyCheckTokenListTaskReqBO pluginJdHpartyCheckTokenListTaskReqBO) {
        pluginJdHpartyCheckTokenListTaskReqBO.getJdHpartyCheckTokenIds().stream().forEach(k -> {
            JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setIsRunning(1);
            jdHpartyCheckTokenPO.setJdHpartyCheckTokenId((Long)k);
            this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
        });
        return RspBO.success((Object)Boolean.TRUE);
    }

    @Override
    public RspBO checkOut(PluginJdHpartyCheckTokenListTaskReqBO pluginJdHpartyCheckTokenListTaskReqBO) {
        pluginJdHpartyCheckTokenListTaskReqBO.getJdHpartyCheckTokenIds().stream().forEach(k -> {
            JdHpartyCheckTokenPO jdHpartyCheckTokenPO = new JdHpartyCheckTokenPO();
            jdHpartyCheckTokenPO.setIsRunning(0);
            jdHpartyCheckTokenPO.setJdHpartyCheckTokenId((Long)k);
            this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
        });
        return RspBO.success((Object)Boolean.TRUE);
    }
}

