/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.atp.base.gemini.model.AbilityGeminiSendMsgReqBo;
import com.ohaotian.atp.base.gemini.service.AbilityGeminiService;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.AbilityPluginJdHpartyCheckMapper;
import com.ohaotian.plugin.mapper.JdHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginJdHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBO;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBO;
import com.ohaotian.plugin.model.bo.rsp.SyncJdHpartyCheckTokenBO;
import com.ohaotian.plugin.model.po.JdHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginJdHpartyCheckPO;
import com.ohaotian.portalcommon.api.AbilityPluginDeployApi;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.ConstantBaseVersion;
import com.ohaotian.portalcommon.model.bo.AbilityPluginDeployRspBO;
import com.ohaotian.portalcommon.model.bo.PluginDataRspBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.service.RefreshTokenPath;
import com.ohaotian.portalcommon.util.DateUtil;
import com.ohaotian.portalcommon.util.GetRandomPwd;
import com.ohaotian.portalcommon.util.GsonUtil;
import com.ohaotian.portalcommon.util.HttpUtil;
import com.ohaotian.portalcommon.util.JDToken;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class JdTokenRefreshLogic {
    private static final Logger log = LoggerFactory.getLogger(JdTokenRefreshLogic.class);
    private static final String ACCESS_TOKEN = "access_token";
    @Resource
    JdHpartyCheckTokenMapper jdHpartyCheckTokenMapper;
    @Resource
    PluginJdHpartyCheckMapper pluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper;
    @Resource
    AbilityPluginDeployApi abilityPluginDeployApi;
    @Resource
    CacheClient cacheClient;
    @Resource
    PluginAPI pluginAPI;
    @Resource
    RegionAPI regionAPI;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;
    @Autowired
    private AbilityGeminiService abilityGeminiService;
    @Autowired
    private RefreshTokenPath refreshTokenPath;
    @Value(value="${jd.token.encryption.method:MD5}")
    private String encryptionMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLogic(Map<String, String> cacheJdToken, Map<String, Long> cacheJdTokenDuration, PluginJdHpartyCheckPO pluginJdHpartyCheckPO, JdHpartyCheckTokenPO jdToken) {
        AbilityGeminiSendMsgReqBo abilityGeminiSendMsgReqBo = new AbilityGeminiSendMsgReqBo();
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginJdHpartyCheckPO.getPluginId());
        String abilityNameAll = pluginRspBO.getPluginName() + "|" + pluginRspBO.getPluginEname() + "|" + pluginRspBO.getPluginNotice();
        abilityGeminiSendMsgReqBo.setPluginName(abilityNameAll.split("\\|")[0] + " " + jdToken.getOrgid());
        try {
            log.info("########> {} <######### (..\u2022\u02d8_\u02d8\u2022..) ####### jdHpartyCheck ###### START", (Object)abilityNameAll);
            if (ObjectUtils.isEmpty((Object)cacheJdToken.get(jdToken.getUserName()))) {
                String sign;
                String password;
                RefreshTokenReqBO refreshTokenReqBO = (RefreshTokenReqBO)BeanMapper.map((Object)pluginJdHpartyCheckPO, RefreshTokenReqBO.class);
                refreshTokenReqBO.setUserName(jdToken.getUserName());
                refreshTokenReqBO.setUserPassword(jdToken.getUserPassword());
                LocalDateTime now = LocalDateTime.now();
                DateTimeFormatter ofPattern = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                refreshTokenReqBO.setTimestamp(now.format(ofPattern));
                refreshTokenReqBO.setGrantType(ACCESS_TOKEN);
                HashMap<String, String> headerMap = new HashMap<String, String>();
                headerMap.put("Content-Type", "application/x-www-form-urlencoded");
                HashMap<String, String> paramsMap = new HashMap<String, String>();
                paramsMap.put("client_id", refreshTokenReqBO.getClientId());
                paramsMap.put("client_secret", refreshTokenReqBO.getClientSecret());
                paramsMap.put("username", refreshTokenReqBO.getUserName());
                paramsMap.put("grant_type", ACCESS_TOKEN);
                paramsMap.put("timestamp", refreshTokenReqBO.getTimestamp());
                if (Objects.equals(this.encryptionMethod, "MD5")) {
                    password = JDToken.getMD5Str((String)refreshTokenReqBO.getUserPassword());
                    sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + ACCESS_TOKEN + refreshTokenReqBO.getClientSecret();
                    sign = JDToken.getMD5Str((String)sign).toUpperCase();
                    paramsMap.put("signType", "0");
                } else if (Objects.equals(this.encryptionMethod, "SM3")) {
                    password = refreshTokenReqBO.getUserPassword();
                    sign = refreshTokenReqBO.getClientSecret() + refreshTokenReqBO.getTimestamp() + refreshTokenReqBO.getClientId() + refreshTokenReqBO.getUserName() + password + ACCESS_TOKEN + refreshTokenReqBO.getClientSecret();
                    sign = JDToken.sm3Hash((String)sign).toUpperCase();
                    paramsMap.put("signType", "1");
                } else {
                    throw new RuntimeException("\u4eac\u4e1c\u9274\u6743\u52a0\u5bc6\u53ea\u652f\u6301MD5,SM3\u52a0\u5bc6");
                }
                paramsMap.put("sign", sign);
                paramsMap.put("password", password);
                paramsMap.put("reStr", GetRandomPwd.makeRandomPwd((int)8));
                log.info("\u914d\u7f6e\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson((Object)pluginJdHpartyCheckPO));
                log.info("\u8bf7\u6c42\u6570\u636e\uff1a{}", (Object)GsonUtil.toJson(paramsMap));
                String url = this.refreshTokenPath.getAll(pluginJdHpartyCheckPO.getTokenPath().trim(), "/plat/template/noauth/jdHpartyCheck/accessToken", pluginJdHpartyCheckPO.getRegionCode());
                log.info("\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)url);
                HttpUtil.doPost((String)url, (status, map) -> {
                    List abilityPluginDeployRspBOList;
                    if (status != 200) {
                        log.error("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0ctoken\u8bb0\u5f55id: {}", (Object)GsonUtil.toJson((Object)jdToken));
                        throw new RuntimeException("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0c\u72b6\u6001\uff1a" + status + " \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c\uff1a" + map);
                    }
                    RefreshTokenRspBO refreshTokenRspBO = (RefreshTokenRspBO)GsonUtil.fromJson((String)map, RefreshTokenRspBO.class);
                    log.info("token\u5237\u65b0\u6210\u529f: \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c{}", (Object)GsonUtil.toJson((Object)refreshTokenRspBO));
                    if (!refreshTokenRspBO.isSuccess()) {
                        log.error("token\u5237\u65b0\u9519\u8bef: token\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                        throw new RuntimeException("token\u5237\u65b0\u8c03\u7528\u5931\u8d25\uff0c\u72b6\u6001\uff1a" + status + " \u4eac\u4e1c\u8fd4\u56de\u7ed3\u679c\uff1a" + map);
                    }
                    long duration = refreshTokenRspBO.getResult().getExpires_in() * 1000L;
                    Date time = new Date();
                    String token = refreshTokenRspBO.getResult().getAccess_token();
                    cacheJdToken.put(jdToken.getUserName(), token);
                    cacheJdTokenDuration.put(jdToken.getUserName(), duration);
                    jdToken.setAccessToken(token);
                    this.updateToken(jdToken, new Date(time.getTime() + duration));
                    log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)pluginJdHpartyCheckPO.getRegionCode());
                    log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)jdToken));
                    log.info("token\u5237\u65b0\u6210\u529f: token\u503c:{}", (Object)token);
                    JdTokenRefreshLogic.setRedis(this.abilityPluginJdHpartyCheckMapper, this.abilityPluginDeployApi, this.cacheClient, this.constantBaseVersion, pluginJdHpartyCheckPO, jdToken);
                    List<Long> abilityPluginDeployIds = this.abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
                    if (!abilityPluginDeployIds.isEmpty() && (abilityPluginDeployRspBOList = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && !abilityPluginDeployRspBOList.isEmpty()) {
                        abilityPluginDeployRspBOList.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                            String key = this.constantBaseVersion.getATP() + "jdHpartyCheck-" + i + "-" + jdToken.getOrgid() + "-" + pluginJdHpartyCheckPO.getRegionCode();
                            if (ObjectUtils.isEmpty((Object)this.cacheClient.get(key))) {
                                log.error("redis\u5237\u65b0\u9519\u8bef:\u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                                throw new RuntimeException("redis\u5237\u65b0\u9519\u8bef: \u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e key: " + key);
                            }
                        });
                    }
                    abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
                    return status;
                }, paramsMap);
            } else {
                List abilityPluginDeployRspBOList;
                String token = cacheJdToken.get(jdToken.getUserName());
                long duration = cacheJdTokenDuration.get(jdToken.getUserName());
                log.info("token\u7f13\u5b58\u83b7\u53d6\u6210\u529f\uff0ctoken\u503c:{}", (Object)token);
                jdToken.setAccessToken(token);
                Date time = new Date();
                this.updateToken(jdToken, new Date(time.getTime() + duration));
                log.info("token\u5237\u65b0\u6210\u529f: \u63d2\u4ef6\u5206\u533a:{}", (Object)pluginJdHpartyCheckPO.getRegionCode());
                log.info("token\u5237\u65b0\u6210\u529f: token\u8bb0\u5f55:{}", (Object)JSONObject.toJSONString((Object)jdToken));
                JdTokenRefreshLogic.setRedis(this.abilityPluginJdHpartyCheckMapper, this.abilityPluginDeployApi, this.cacheClient, this.constantBaseVersion, pluginJdHpartyCheckPO, jdToken);
                List<Long> abilityPluginDeployIds = this.abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
                if (!abilityPluginDeployIds.isEmpty() && (abilityPluginDeployRspBOList = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && !abilityPluginDeployRspBOList.isEmpty()) {
                    abilityPluginDeployRspBOList.stream().map(AbilityPluginDeployRspBO::getClusterId).forEach(i -> {
                        String key = this.constantBaseVersion.getATP() + "jdHpartyCheck-" + i + "-" + jdToken.getOrgid() + "-" + pluginJdHpartyCheckPO.getRegionCode();
                        if (ObjectUtils.isEmpty((Object)this.cacheClient.get(key))) {
                            log.error("redis\u5237\u65b0\u9519\u8bef:\u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e\uff0ctoken\u8bb0\u5f55id:{}", (Object)GsonUtil.toJson((Object)jdToken));
                            throw new RuntimeException("redis\u5237\u65b0\u9519\u8bef: \u65e0\u6cd5\u83b7\u53d6\u5237\u5165\u6570\u636e key: " + key);
                        }
                    });
                }
                abilityGeminiSendMsgReqBo.setStatus(Boolean.TRUE.booleanValue());
            }
        }
        catch (Exception e) {
            log.error("token\u5237\u65b0\u5f02\u5e38: token\u8bb0\u5f55id:{},ex:{}", (Object)JSON.toJSONString((Object)jdToken), (Object)e);
            jdToken.setAccessToken(e.getMessage());
            this.updateErrorToken(jdToken);
            if (Objects.equals(abilityNameAll.split("\\|")[2], String.valueOf(1))) {
                abilityGeminiSendMsgReqBo.setStatus(Boolean.FALSE.booleanValue());
                abilityGeminiSendMsgReqBo.setErrorMsg(e.getMessage());
                JSONObject rspBO = this.abilityGeminiService.sendMessage(abilityGeminiSendMsgReqBo);
                log.info("\u901a\u77e5\u7ed3\u679c\uff1a{}", (Object)rspBO);
            }
        }
        finally {
            log.info("########> {} <######### \u250c(;\uffe3\u25c7\uffe3)\u2518 ###################### END", (Object)abilityNameAll);
        }
    }

    private void updateToken(JdHpartyCheckTokenPO jdHpartyCheckTokenPO, Date expiresIn) {
        jdHpartyCheckTokenPO.setIsRunning(1);
        jdHpartyCheckTokenPO.setExpiresIn(expiresIn);
        jdHpartyCheckTokenPO.setUpdateTime(new Date());
        this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
    }

    private void updateErrorToken(JdHpartyCheckTokenPO jdHpartyCheckTokenPO) {
        jdHpartyCheckTokenPO.setIsRunning(2);
        jdHpartyCheckTokenPO.setUpdateTime(new Date());
        jdHpartyCheckTokenPO.setCreateTime(new Date());
        this.jdHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(jdHpartyCheckTokenPO);
    }

    private void noticeForData(PluginJdHpartyCheckPO pluginJdHpartyCheckPO, JdHpartyCheckTokenPO jdHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = this.abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = this.abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            List clusterIds = abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).collect(Collectors.toList());
            PluginDataRspBO pluginDataRspBO = new PluginDataRspBO();
            pluginDataRspBO.setClusterIds(clusterIds);
            pluginDataRspBO.setPluginType("jdHpartyCheck");
            pluginDataRspBO.setOpr("refresh");
            SyncJdHpartyCheckTokenBO syncJdHpartyCheckTokenBO = (SyncJdHpartyCheckTokenBO)BeanMapper.map((Object)jdHpartyCheckTokenPO, SyncJdHpartyCheckTokenBO.class);
            syncJdHpartyCheckTokenBO.setClientId(pluginJdHpartyCheckPO.getClientId());
            syncJdHpartyCheckTokenBO.setRegionCode(pluginJdHpartyCheckPO.getRegionCode());
            pluginDataRspBO.setData((Object)GsonUtil.toJson((Object)syncJdHpartyCheckTokenBO));
            log.info("\u96c6\u7fa4\u901a\u77e5{}", (Object)JSON.toJSONString((Object)pluginDataRspBO));
        }
    }

    public static void setRedis(AbilityPluginJdHpartyCheckMapper abilityPluginJdHpartyCheckMapper, AbilityPluginDeployApi abilityPluginDeployApi, CacheClient cacheClient, ConstantBaseVersion constantBaseVersion, PluginJdHpartyCheckPO pluginJdHpartyCheckPO, JdHpartyCheckTokenPO jdHpartyCheckTokenPO) {
        List abilityPluginDeployRspBOS;
        List<Long> abilityPluginDeployIds = abilityPluginJdHpartyCheckMapper.queryAllDeployIds();
        SyncJdHpartyCheckTokenBO syncJdHpartyCheckTokenBO = (SyncJdHpartyCheckTokenBO)BeanMapper.map((Object)jdHpartyCheckTokenPO, SyncJdHpartyCheckTokenBO.class);
        syncJdHpartyCheckTokenBO.setClientId(pluginJdHpartyCheckPO.getClientId());
        syncJdHpartyCheckTokenBO.setRegionCode(pluginJdHpartyCheckPO.getRegionCode());
        if (abilityPluginDeployIds.size() > 0 && (abilityPluginDeployRspBOS = abilityPluginDeployApi.qryAbilityPluginDeployById(abilityPluginDeployIds)) != null && abilityPluginDeployRspBOS.size() != 0) {
            abilityPluginDeployRspBOS.stream().map(AbilityPluginDeployRspBO::getClusterId).distinct().forEach(i -> {
                String key = constantBaseVersion.getATP() + "jdHpartyCheck-" + i + "-" + jdHpartyCheckTokenPO.getOrgid() + "-" + pluginJdHpartyCheckPO.getRegionCode();
                AbilityRedisTokenDataBo abilityRedisTokenDataBo = new AbilityRedisTokenDataBo();
                abilityRedisTokenDataBo.setPluginId(syncJdHpartyCheckTokenBO.getPluginId().toString());
                abilityRedisTokenDataBo.setClientId(syncJdHpartyCheckTokenBO.getClientId());
                abilityRedisTokenDataBo.setClientSecret("");
                abilityRedisTokenDataBo.setAccName("");
                abilityRedisTokenDataBo.setCallProtocol(pluginJdHpartyCheckPO.getCallProtocol());
                abilityRedisTokenDataBo.setTokenPath("");
                abilityRedisTokenDataBo.setToken(syncJdHpartyCheckTokenBO.getAccessToken());
                abilityRedisTokenDataBo.setRefreshInterval("");
                abilityRedisTokenDataBo.setTokenPosition(Integer.valueOf(0));
                abilityRedisTokenDataBo.setTime(DateUtil.formatDateWithMS((Date)new Date()));
                abilityRedisTokenDataBo.setHsn("");
                abilityRedisTokenDataBo.setOrgId(jdHpartyCheckTokenPO.getOrgid());
                abilityRedisTokenDataBo.setCompanyName("");
                abilityRedisTokenDataBo.setRegionCode(syncJdHpartyCheckTokenBO.getRegionCode());
                abilityRedisTokenDataBo.setAppends("");
                String value = GsonUtil.toJson((Object)abilityRedisTokenDataBo);
                cacheClient.set(key, (Object)value);
                cacheClient.expire(key, 86400);
                log.info("redis\u5199\u5165\uff0ckey\uff1a{}", (Object)key);
            });
        }
    }
}

