/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.util;

import com.aliyun.oss.ClientBuilderConfiguration;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.plugin.file.oss.OssContentType;
import com.ohaotian.plugin.file.util.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OssUtils {
    private static final Logger log = LoggerFactory.getLogger(OssUtils.class);
    private static OSS ossClient;
    private static String DELIMITER;

    public static OSS getOSS(OssConfig ossConfig) {
        if (ossClient == null) {
            ClientBuilderConfiguration conf = new ClientBuilderConfiguration();
            conf.setSupportCname(false);
            ossClient = new OSSClientBuilder().build(ossConfig.getEndpoint(), ossConfig.getAccessKeyId(), ossConfig.getAccessKeySecret());
        }
        return ossClient;
    }

    @PreDestroy
    public void shutdownOssClient() {
        if (ossClient != null) {
            ossClient.shutdown();
        }
    }

    public static List<String> listObjects(String prefix, OssConfig ossConfig) {
        ossClient = OssUtils.getOSS(ossConfig);
        ListObjectsRequest listObjectsRequest = new ListObjectsRequest(ossConfig.getBucketName()).withPrefix(prefix).withDelimiter(DELIMITER);
        List result = ossClient.listObjects(listObjectsRequest).getCommonPrefixes();
        return result;
    }

    public static List<String> listFileObjects(String prefix, OssConfig ossConfig) {
        ossClient = OssUtils.getOSS(ossConfig);
        ArrayList<String> result = new ArrayList<String>();
        ObjectListing objectListing = ossClient.listObjects(ossConfig.getBucketName(), prefix);
        for (OSSObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            result.add(objectSummary.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String uploadFileByInputStream(String uploadFilePath, String fileName, InputStream inputStream, OssConfig ossConfig) {
        byte[] bytes = FileUtils.input2byte((InputStream)inputStream);
        String fileExtName = FileUtils.ext((String)fileName);
        if (!StringUtils.hasText((String)fileExtName)) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u65e0\u7c7b\u578b\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        if (!("mp4".equals(fileExtName) || "json".equals(fileExtName) || "txt".equals(fileExtName) || "p12".equals(fileExtName) || "pfx".equals(fileExtName) || "cer".equals(fileExtName))) {
            throw new ZTBusinessException("\u7981\u6b62\u4e0a\u4f20\u8be5\u6587\u4ef6\uff0c\u8bf7\u66f4\u6362\u540e\u91cd\u65b0\u4e0a\u4f20");
        }
        String filePath = OssUtils.getFilePath(uploadFilePath, fileName);
        try {
            OSS ossClient = OssUtils.getOSS(ossConfig);
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentType(OssContentType.of((String)fileExtName));
            ossClient.putObject(ossConfig.getBucketName(), filePath, (InputStream)new ByteArrayInputStream(bytes), objectMetadata);
        }
        catch (OSSException var8) {
            log.error("\u8fde\u63a5\u8fdc\u7a0boss\u670d\u52a1\u5668\u51fa\u9519\uff01", (Throwable)var8);
        }
        catch (ClientException var9) {
            log.error("\u8fde\u63a5oss\u5ba2\u6237\u7aef\u51fa\u9519\uff01", (Throwable)var9);
        }
        return filePath;
    }

    public static String getFilePath(String uploadFilePath, String fileName) {
        if (!uploadFilePath.endsWith("/")) {
            uploadFilePath = uploadFilePath + "/";
        }
        return uploadFilePath + fileName;
    }

    public static Integer deleteFiles(List<String> filePathList, OssConfig ossConfig) {
        OSS ossClient = OssUtils.getOSS(ossConfig);
        int size = 0;
        try {
            int i = 0;
            while (i < filePathList.size()) {
                int end = Math.min(i + 1000, filePathList.size());
                List<String> subList = filePathList.subList(i, end);
                DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(ossConfig.getBucketName()).withKeys(subList);
                DeleteObjectsResult deleteObjectsResult = ossClient.deleteObjects(deleteObjectsRequest);
                size += deleteObjectsResult.getDeletedObjects().size();
                i = end;
            }
        }
        catch (OSSException var8) {
            log.error("Caught an OSSException, which means your request made it to OSS, but was rejected with an error response for some reason.");
        }
        catch (ClientException var9) {
            log.error("Caught an ClientException, which means the client encountered a serious internal problem while trying to communicate with OSS, such as not being able to access the network.");
        }
        return size;
    }

    static {
        DELIMITER = "/";
    }
}

