/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.controller;

import com.ohaotian.logplatform.model.req.QueryDataReqBO;
import com.ohaotian.logplatform.service.LogTransactionService;
import com.ohaotian.logplatform.service.impl.ExceptionType;
import com.ohaotian.logplatform.service.impl.LogErrorEnum;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/eslog"})
public class LogPlatformServiceController {
    private static final Logger logger = LogManager.getLogger(LogPlatformServiceController.class);
    @Autowired
    LogTransactionService logTransactionService;
    @Value(value="${log.platform.es.ability.use:false}")
    private boolean abilityLogUse;
    @Value(value="${log.platform.es.abnormal.use:false}")
    private boolean abnormalStatisticsLogUse;

    @PostMapping(value={"/getAbilityLogUse"})
    @BusiResponseBody
    public RspBO getAbilityLogUse(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return RspBO.success((Object)this.abilityLogUse);
    }

    @PostMapping(value={"/getAbnormalLogUse"})
    @BusiResponseBody
    public RspBO getAbnormalLogUse(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return RspBO.success((Object)this.abnormalStatisticsLogUse);
    }

    @PostMapping(value={"/getIndexData"})
    @BusiResponseBody
    public RspBO getIndexData(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        logger.info((Object)queryDataReqBO);
        return this.logTransactionService.getIndex("ability-*", queryDataReqBO);
    }

    @CrossOrigin(origins={"*"}, maxAge=3600L)
    @PostMapping(value={"/getReqIn"})
    @BusiResponseBody
    public RspBO getReqIn(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        logger.info((Object)queryDataReqBO);
        return this.logTransactionService.getReqIn(queryDataReqBO);
    }

    @PostMapping(value={"/getReqOut"})
    @BusiResponseBody
    public RspBO getReqOut(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getReqOut(queryDataReqBO);
    }

    @PostMapping(value={"/getRspIn"})
    @BusiResponseBody
    public RspBO getRspIn(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getRspIn(queryDataReqBO);
    }

    @PostMapping(value={"/getRspOut"})
    @BusiResponseBody
    public RspBO getRspOut(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getRspOut(queryDataReqBO);
    }

    @PostMapping(value={"/getCalculatingTime"})
    @BusiResponseBody
    public RspBO getCalculatingTime(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.calculatingTime(queryDataReqBO.getTraceId());
    }

    @PostMapping(value={"/getLogData"})
    @BusiResponseBody
    public RspBO getLogData(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getLogData(queryDataReqBO);
    }

    @PostMapping(value={"getAvgTime"})
    @BusiResponseBody
    public RspBO getAvgTime(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getAvgTime(queryDataReqBO);
    }

    @PostMapping(value={"/getErrorData"})
    @BusiResponseBody
    public RspBO getErrorData(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.getErrorData(queryDataReqBO);
    }

    @PostMapping(value={"/queryExcept"})
    @BusiResponseBody
    public RspBO queryExcept(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.queryExcept(queryDataReqBO);
    }

    @PostMapping(value={"/getExceptionList"})
    @BusiResponseBody
    public RspBO getExceptionList(@RequestBody QueryDataReqBO queryDataReqBO) {
        return this.logTransactionService.getExceptionLogData(queryDataReqBO);
    }

    @PostMapping(value={"/errorSortType"})
    @BusiResponseBody
    public RspBO errorSortType() {
        LogErrorEnum[] logErrorEnums = LogErrorEnum.values();
        ArrayList list = new ArrayList();
        for (LogErrorEnum v : logErrorEnums) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", v.getName());
            list.add(map);
        }
        RspBO rspBO = RspBO.success(list);
        return rspBO;
    }

    @PostMapping(value={"/exceptionType"})
    @BusiResponseBody
    public RspBO exceptionType() {
        ExceptionType[] exceptionTypes = ExceptionType.values();
        ArrayList list = new ArrayList();
        for (ExceptionType v : exceptionTypes) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("label", v.getName());
            list.add(map);
        }
        RspBO rspBO = RspBO.success(list);
        return rspBO;
    }

    @CrossOrigin(origins={"*"}, maxAge=3600L)
    @PostMapping(value={"/getCalculatingTimeList"})
    @BusiResponseBody
    public RspBO getCalculatingTimeList(@RequestBody QueryDataReqBO queryDataReqBO) throws Exception {
        return this.logTransactionService.calculatingTimeList(queryDataReqBO);
    }
}

