/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.config;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ohaotian.logplatform.config.ElasticSearchConfig;
import com.ohaotian.logplatform.mapper.EsArchiveFileMapper;
import com.ohaotian.logplatform.model.po.EsArchiveFilePo;
import com.ohaotian.logplatform.service.LogTransactionService;
import com.ohaotian.logplatform.util.OssUtils;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.oss.OssConfig;
import com.ohaotian.portalcommon.util.UUIDUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.core.CountResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ObjectUtils;

@ConditionalOnProperty(prefix="log.platform.es.monitor", name={"archive"}, havingValue="true")
@Configuration
public class EsMonitorConfig {
    private static final Logger log = LoggerFactory.getLogger(EsMonitorConfig.class);
    @Resource
    OssConfig ossConfig;
    @Autowired
    private RestHighLevelClient client;
    @Autowired
    private ElasticSearchConfig elasticSearchConfig;
    @Autowired
    LogTransactionService logTransactionService;
    @Resource
    private EsArchiveFileMapper esArchiveFileMapper;
    public String[] indexName;
    @Value(value="${log.platform.es.esMaxWeek:5}")
    public int esMaxWeek;
    @Value(value="${log.platform.es.indexSize:3}")
    public double indexSize;
    @Value(value="${log.platform.es.fileMaxWeek:10}")
    public int fileMaxWeek;
    @Value(value="${log.platform.es.pageSize:5000}")
    public int pageSize;
    public final String ROOT_PREFIX = "ability/";

    public void indexNameInit() {
        if (ObjectUtils.isEmpty((Object[])this.indexName)) {
            this.indexName = new String[]{this.elasticSearchConfig.getReqInIndexName(), this.elasticSearchConfig.getRspInIndexName(), this.elasticSearchConfig.getReqOutIndexName(), this.elasticSearchConfig.getRspOutIndexName(), this.elasticSearchConfig.getExceptionIndexName()};
        }
    }

    @Scheduled(cron="${log.platform.es.checkWeekCorn:0 0 1 * * ?}")
    public String checkEsWeek() {
        EsArchiveFilePo esArchiveFilePo = this.getEsArchiveFilePo("\u8fdb\u884c\u7d22\u5f15\u5468\u6570\u626b\u63cf\u8fdb\u884c\u5f52\u6863\uff0c\u6b63\u5728\u6267\u884c\u83b7\u53d6\u7d22\u5f15\u64cd\u4f5c\u4e2d\u3002");
        this.checkRunning();
        if (!this.checkIndexWithWeek(esArchiveFilePo)) {
            return "\u65e0es\u7d22\u5f15\u5f52\u6863\uff0c\u65e0\u9700\u6267\u884c\u6587\u4ef6\u626b\u63cf\u64cd\u4f5c";
        }
        this.checkFileWithWeek(esArchiveFilePo);
        return "\u6267\u884c\u5f52\u6863\u6210\u529f";
    }

    @Scheduled(cron="${log.platform.es.checkSizeCorn:0 0 5 * * ?}")
    public String checkEsSize() {
        EsArchiveFilePo esArchiveFilePo = this.getEsArchiveFilePo("\u8fdb\u884c\u7d22\u5f15\u5927\u5c0f\u626b\u63cf\u8fdb\u884c\u5f52\u6863\uff0c\u6b63\u5728\u6267\u884c\u83b7\u53d6\u7d22\u5f15\u64cd\u4f5c\u4e2d\u3002");
        this.checkRunning();
        if (!this.checkIndexWithSize(esArchiveFilePo)) {
            return "\u65e0\u9700\u6267\u884c\u5f52\u6863\u64cd\u4f5c";
        }
        this.checkFileWithWeek(esArchiveFilePo);
        return "\u6267\u884c\u5f52\u6863\u6210\u529f";
    }

    public void checkRunning() {
        this.indexNameInit();
        EsArchiveFilePo esArchiveFilePo = new EsArchiveFilePo();
        esArchiveFilePo.setStatus(2);
        List<EsArchiveFilePo> esArchiveFilePos = this.esArchiveFileMapper.queryByCond(esArchiveFilePo);
        if (Boolean.FALSE.equals(esArchiveFilePos.isEmpty())) {
            List runningList = esArchiveFilePos.stream().map(e -> "\u6267\u884c\u6d41\u6c34\u53f7:" + e.getTraceId() + "\u3002\u521b\u5efa\u65f6\u95f4:" + e.getCreateTime() + "\u3002\u5f52\u6863\u539f\u56e0:" + e.getCreateDescription()).collect(Collectors.toList());
            log.error("\u5728\u6267\u884c\u5468\u6570\u5f52\u6863\u65f6\uff0c\u53d1\u73b0\u6709\u6b63\u5728\u6267\u884c\u5f52\u6863\u7684\u6570\u636e{}", runningList);
            throw new ZTBusinessException("\u5728\u6267\u884c\u5468\u6570\u5f52\u6863\u65f6\uff0c\u53d1\u73b0\u6709\u6b63\u5728\u6267\u884c\u5f52\u6863\u7684\u6570\u636e:" + runningList);
        }
    }

    public void getIndexNameListWithPrefix(Map<String, List<String>> indexMap) throws IOException {
        for (String s : this.indexName) {
            Request request = new Request("GET", "/_cat/indices/" + s + "?h=i");
            String indicesListStr = EntityUtils.toString((HttpEntity)this.client.getLowLevelClient().performRequest(request).getEntity());
            List indicesList = Arrays.stream(indicesListStr.trim().split("\\n")).collect(Collectors.toList());
            indexMap.put(s, indicesList);
        }
    }

    public EsArchiveFilePo getEsArchiveFilePo(String createDescription) {
        EsArchiveFilePo esArchiveFilePo = new EsArchiveFilePo();
        String traceId = UUIDUtil.generateUuid();
        esArchiveFilePo.setTraceId(traceId);
        esArchiveFilePo.setCreateTime(new Date());
        esArchiveFilePo.setCreateDescription(createDescription);
        esArchiveFilePo.setStatus(2);
        return esArchiveFilePo;
    }

    public void doGetEsIndexListError(EsArchiveFilePo esArchiveFilePo, Throwable e) {
        esArchiveFilePo.setStatus(1);
        esArchiveFilePo.setOverTime(new Date());
        esArchiveFilePo.setOverDescription("\u5728\u6267\u884ces\u7d22\u5f15\u83b7\u53d6\u65f6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        this.esArchiveFileMapper.insert(esArchiveFilePo);
        log.error("\u5728\u6267\u884ces\u7d22\u5f15\u83b7\u53d6\u65f6\u5931\u8d25", e);
        throw new ZTBusinessException("\u5728\u6267\u884ces\u7d22\u5f15\u83b7\u53d6\u65f6\u5931\u8d25\uff1a" + e);
    }

    public boolean checkIndexWithWeek(EsArchiveFilePo esArchiveFilePo) {
        HashMap<String, List<String>> indexMap = new HashMap<String, List<String>>();
        try {
            this.getIndexNameListWithPrefix(indexMap);
        }
        catch (Exception e) {
            this.doGetEsIndexListError(esArchiveFilePo, e);
        }
        ArrayList<String> archiveIndexNameList = new ArrayList<String>();
        for (String s : this.indexName) {
            List indexNameList = (List)indexMap.get(s);
            int indexCount = indexNameList.size() - this.esMaxWeek;
            if (indexCount <= 0) continue;
            Collections.sort(indexNameList);
            indexNameList.subList(indexCount, indexNameList.size()).clear();
            archiveIndexNameList.addAll(indexNameList);
        }
        return this.archiveIndex(archiveIndexNameList, esArchiveFilePo.getTraceId(), esArchiveFilePo);
    }

    public boolean checkIndexWithSize(EsArchiveFilePo esArchiveFilePo) {
        HashMap<String, List<String>> indexMap = new HashMap<String, List<String>>();
        try {
            this.getIndexNameListWithPrefix(indexMap);
        }
        catch (Exception e) {
            this.doGetEsIndexListError(esArchiveFilePo, e);
        }
        ArrayList<String> archiveIndexNameList = new ArrayList<String>();
        try {
            for (String s : this.indexName) {
                List indexNameList = (List)indexMap.get(s);
                RestClient lowLevelClient = this.client.getLowLevelClient();
                Response response = lowLevelClient.performRequest(new Request("GET", "/" + s + "/_stats"));
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                JsonNode jsonNode = new ObjectMapper().readTree(responseBody);
                long totalSize = jsonNode.path("_all").path("total").path("store").path("size_in_bytes").asLong();
                if (!((double)totalSize > this.indexSize * 1024.0 * 1024.0 * 1024.0)) continue;
                Collections.sort(indexNameList);
                indexNameList.subList(1, indexNameList.size()).clear();
                archiveIndexNameList.addAll(indexNameList);
            }
        }
        catch (Exception e) {
            this.doGetEsIndexListError(esArchiveFilePo, e);
        }
        return this.archiveIndex(archiveIndexNameList, esArchiveFilePo.getTraceId(), esArchiveFilePo);
    }

    public boolean deleteEsIndex(String indexName) throws IOException {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        AcknowledgedResponse deleteIndexResponse = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return deleteIndexResponse.isAcknowledged();
    }

    public long countIndex(String indexName) throws IOException {
        CountRequest countRequest = new CountRequest(new String[]{indexName});
        countRequest.query((QueryBuilder)QueryBuilders.matchAllQuery());
        CountResponse countResponse = this.client.count(countRequest, RequestOptions.DEFAULT);
        return countResponse.getCount();
    }

    public void setEsMaxResult(List<String> indexList) throws Exception {
        for (String indexName : indexList) {
            long count = this.countIndex(indexName);
            UpdateSettingsRequest request = new UpdateSettingsRequest(new String[]{indexName});
            request.settings(Settings.builder().put("index.max_result_window", count + 10000L));
            this.client.indices().putSettings(request, RequestOptions.DEFAULT);
        }
        log.info("\u8bbe\u7f6e\u7d22\u5f15\u67e5\u8be2\u6700\u5927\u503c\u6210\u529f\uff01");
    }

    public boolean pushIndexDataWithName(String indexName, String archiveId) throws IOException {
        boolean deleteFlag = Boolean.TRUE;
        Scroll scroll = new Scroll(TimeValue.timeValueMinutes((long)1L));
        SearchRequest searchRequest = new SearchRequest(new String[]{indexName});
        searchRequest.scroll(scroll);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        searchSourceBuilder.size(this.pageSize);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
        String scrollId = searchResponse.getScrollId();
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        int queryCount = 1;
        while (searchHits != null && searchHits.length > 0) {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId);
            scrollRequest.scroll(scroll);
            try {
                searchResponse = this.client.scroll(scrollRequest, RequestOptions.DEFAULT);
            }
            catch (Exception e) {
                log.error("es\u67e5\u8be2\u8fc7\u7a0b\u4e2d\u5f02\u5e38", (Throwable)e);
                throw new ZTBusinessException("\u67e5\u8be2es\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff0c\u7d22\u5f15\u540d\u4e3a\uff1a" + indexName + "; pageNo\u4e3a\uff1a" + queryCount + "pageSize\u4e3a\uff1a" + this.pageSize + "\u3002\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e);
            }
            scrollId = searchResponse.getScrollId();
            searchHits = searchResponse.getHits().getHits();
            if (!this.storeToFile(searchHits, indexName + "-" + archiveId)) {
                deleteFlag = Boolean.FALSE;
            }
            ++queryCount;
        }
        ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
        clearScrollRequest.addScrollId(scrollId);
        ClearScrollResponse clearScrollResponse = this.client.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
        boolean succeeded = clearScrollResponse.isSucceeded();
        if (!succeeded) {
            log.info("\u6e05\u9664" + indexName + "\u7d22\u5f15\u7684Scroll\u5931\u8d25");
        }
        return deleteFlag;
    }

    public boolean archiveIndex(List<String> archiveIndexNameList, String archiveId, EsArchiveFilePo esArchiveFilePo) {
        try {
            if (Boolean.FALSE.equals(archiveIndexNameList.isEmpty())) {
                esArchiveFilePo.setCreateDescription(esArchiveFilePo.getCreateDescription() + "\u83b7\u53d6\u7d22\u5f15\u5b8c\u6210\uff0c\u6267\u884c\u5f52\u6863\u4e2d\uff0c\u5f52\u6863\u7d22\u5f15\u4e3a\uff1a" + archiveIndexNameList);
                this.esArchiveFileMapper.insert(esArchiveFilePo);
                for (String indexName : archiveIndexNameList) {
                    if (!this.pushIndexDataWithName(indexName, archiveId) || !Boolean.FALSE.equals(this.deleteEsIndex(indexName))) continue;
                    throw new ZTBusinessException("\u5220\u9664\u7d22\u5f15" + indexName + "\u5931\u8d25");
                }
                esArchiveFilePo.setStatus(0);
                esArchiveFilePo.setOverTime(new Date());
                esArchiveFilePo.setOverDescription("\u6267\u884c\u5f52\u6863\u6210\u529f");
                this.esArchiveFileMapper.update(esArchiveFilePo);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        catch (Exception e) {
            esArchiveFilePo.setStatus(1);
            esArchiveFilePo.setOverTime(new Date());
            esArchiveFilePo.setOverDescription("\u5728\u6267\u884c\u5f52\u6863\u8fc7\u7a0b\u4e2d\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            this.esArchiveFileMapper.update(esArchiveFilePo);
            log.error("\u5728\u6267\u884c\u5f52\u6863\u8fc7\u7a0b\u4e2d\u5931\u8d25", (Throwable)e);
            throw new ZTBusinessException("\u5728\u6267\u884c\u5f52\u6863\u8fc7\u7a0b\u4e2d\u5931\u8d25: " + e);
        }
    }

    public boolean storeToFile(SearchHit[] searchHits, String threeDirName) {
        HashMap abilityMap = new HashMap();
        try {
            for (SearchHit searchHit : searchHits) {
                Map row = searchHit.getSourceAsMap();
                if (row.get("abilityEname") != null && row.get("traceId") != null) {
                    String abilityEname = row.get("abilityEname").toString();
                    List<Map> indexList = abilityMap.containsKey(abilityEname) ? (List)abilityMap.get(abilityEname) : new ArrayList();
                    indexList.add(row);
                    abilityMap.put(abilityEname, indexList);
                    continue;
                }
                log.warn("\u5f52\u6863es\u8fc7\u7a0b\u4e2d\u53d1\u73b0\u5f02\u5e38\u7684\u884c\u6570\u636e(\u53ef\u80fdabilityEname\u6216\u8005traceId\u4e3a\u7a7a)\uff0c\u5bf9\u5e94\u4fe1\u606f\u96c6\u5408\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)row));
            }
            for (Map.Entry entry : abilityMap.entrySet()) {
                List value = (List)entry.getValue();
                List sortedValue = value.stream().sorted(Comparator.comparing(m -> new BigInteger(((String)m.get("traceId")).substring(3)))).collect(Collectors.toList());
                String fileName = ((Map)sortedValue.get(0)).get("traceId").toString() + "To" + ((Map)sortedValue.get(sortedValue.size() - 1)).get("traceId").toString() + ".json";
                String uploadFilePath = "ability/" + (String)entry.getKey() + "/" + threeDirName + "/";
                ByteArrayInputStream inputValue = new ByteArrayInputStream(JSON.toJSONString((Object)value).getBytes(StandardCharsets.UTF_8));
                OssUtils.uploadFileByInputStream(uploadFilePath, fileName, inputValue, this.ossConfig);
            }
        }
        catch (Exception e) {
            log.error("\u5728\u5f52\u6863\u7d22\u5f15\u8fc7\u7a0b\u4e2d\u53d1\u751f\u5f02\u5e38\uff01", (Throwable)e);
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String checkFileWithWeek(EsArchiveFilePo esArchiveFilePo) {
        int deleteCount;
        ArrayList deleteDirList;
        block21: {
            this.checkRunning();
            String traceId = "";
            if (esArchiveFilePo.getTraceId() == null) {
                esArchiveFilePo.setStatus(2);
                esArchiveFilePo.setCreateTime(new Date());
                esArchiveFilePo.setCreateDescription("\u624b\u52a8\u6267\u884c\u6587\u4ef6\u5f52\u6863\u64cd\u4f5c");
                traceId = UUIDUtil.generateUuid();
            }
            deleteDirList = new ArrayList();
            deleteCount = 0;
            ArrayList<String> filePathList = new ArrayList<String>();
            try {
                int tempCount;
                for (int i = 0; i < this.indexName.length; ++i) {
                    this.indexName[i] = this.indexName[i].substring(0, this.indexName[i].length() - 1);
                }
                HashMap abilityIndexMap = new HashMap();
                List<String> abilityDirList = OssUtils.listObjects("ability/", this.ossConfig);
                ArrayList<String> dirList = new ArrayList<String>();
                for (String string : abilityDirList) {
                    dirList.addAll(OssUtils.listObjects(string, this.ossConfig));
                }
                for (String string : dirList) {
                    List<String> indexNamePrefixList;
                    Map indexMap;
                    String[] abilityDir = string.split("/");
                    String string2 = abilityDir[1];
                    if (abilityIndexMap.get(string2) == null) {
                        indexMap = new HashMap();
                        for (String indexNamePrefix : this.indexName) {
                            if (((String)abilityDir[2]).startsWith(indexNamePrefix)) {
                                indexNamePrefixList = new ArrayList<String>();
                                indexNamePrefixList.add((String)abilityDir[0] + "/" + (String)abilityDir[1] + "/" + (String)abilityDir[2]);
                                indexMap.put(indexNamePrefix, indexNamePrefixList);
                                continue;
                            }
                            indexMap.put(indexNamePrefix, new ArrayList());
                        }
                        abilityIndexMap.put(string2, indexMap);
                        continue;
                    }
                    indexMap = (Map)abilityIndexMap.get(string2);
                    for (String indexNamePrefix : this.indexName) {
                        if (!((String)abilityDir[2]).startsWith(indexNamePrefix)) continue;
                        indexNamePrefixList = indexMap.get(indexNamePrefix) == null ? new ArrayList() : (List)indexMap.get(indexNamePrefix);
                        indexNamePrefixList.add((String)abilityDir[0] + "/" + (String)abilityDir[1] + "/" + (String)abilityDir[2]);
                        indexMap.put(indexNamePrefix, indexNamePrefixList);
                    }
                }
                for (Map.Entry entry : abilityIndexMap.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        List indexNameList = (List)entry2.getValue();
                        int indexCount = indexNameList.size() - this.fileMaxWeek;
                        if (indexCount <= 0) continue;
                        Collections.sort(indexNameList);
                        indexNameList.subList(indexCount, indexNameList.size()).clear();
                        deleteDirList.addAll(indexNameList);
                    }
                }
                do {
                    filePathList = new ArrayList();
                    for (String deleteIndexName : deleteDirList) {
                        List<String> list = OssUtils.listFileObjects(deleteIndexName + "/", this.ossConfig);
                        filePathList.addAll(list);
                    }
                    tempCount = OssUtils.deleteFiles(filePathList, this.ossConfig);
                    deleteCount += tempCount;
                } while (tempCount != 0);
                if (deleteCount == 0) break block21;
                if (esArchiveFilePo.getTraceId() == null) {
                    esArchiveFilePo.setTraceId(traceId);
                    esArchiveFilePo.setStatus(0);
                    esArchiveFilePo.setOverDescription("\u624b\u52a8\u6267\u884cOSS\u6587\u4ef6\u626b\u63cf\u64cd\u4f5c\u5b8c\u6210\uff0c\u5171\u5220\u9664\u6587\u4ef6" + deleteCount + "\u4e2a\uff0c\u5220\u9664\u7684\u76ee\u5f55\u6709\uff1a" + deleteDirList);
                    esArchiveFilePo.setOverTime(new Date());
                    this.esArchiveFileMapper.insert(esArchiveFilePo);
                    break block21;
                }
                esArchiveFilePo.setOverDescription(esArchiveFilePo.getOverDescription() + "\n\u5b58\u5728\u81ea\u52a8\u6267\u884cOSS\u6587\u4ef6\u626b\u63cf\u64cd\u4f5c\u3002\u5220\u9664\u65f6\u95f4\u4e3a\uff1a" + new Date() + "\uff0c\u5171\u5220\u9664\u6587\u4ef6" + deleteCount + "\u4e2a\uff0c\u5220\u9664\u7684\u76ee\u5f55\u6709:" + deleteDirList);
                this.esArchiveFileMapper.update(esArchiveFilePo);
            }
            catch (Exception e) {
                try {
                    if (esArchiveFilePo.getTraceId() == null) {
                        esArchiveFilePo.setTraceId(traceId);
                        esArchiveFilePo.setStatus(1);
                        esArchiveFilePo.setOverDescription("\u624b\u52a8\u6267\u884cOSS\u6587\u4ef6\u626b\u63cf\u64cd\u4f5c\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e);
                        esArchiveFilePo.setOverTime(new Date());
                        this.esArchiveFileMapper.insert(esArchiveFilePo);
                    } else {
                        esArchiveFilePo.setStatus(1);
                        esArchiveFilePo.setOverDescription(esArchiveFilePo.getOverDescription() + "\n\u5b58\u5728\u81ea\u52a8\u6267\u884cOSS\u6587\u4ef6\u5f52\u6863\u64cd\u4f5c\u4f46\u53d1\u751f\u5f02\u5e38\u3002\u5f02\u5e38\u65f6\u95f4\u4e3a: " + new Date() + "\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e);
                        this.esArchiveFileMapper.update(esArchiveFilePo);
                    }
                    throw new ZTBusinessException("\u6267\u884cOSS\u6587\u4ef6\u626b\u63cf\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\u4e3a\uff1a" + e);
                }
                catch (Throwable throwable) {
                    for (int i = 0; i < this.indexName.length; ++i) {
                        this.indexName[i] = this.indexName[i] + "*";
                    }
                    throw throwable;
                }
            }
        }
        for (int i = 0; i < this.indexName.length; ++i) {
            this.indexName[i] = this.indexName[i] + "*";
        }
        return "\u6267\u884cOSS\u6587\u4ef6\u626b\u63cf\u540e\uff0c\u5171\u5220\u9664\u6587\u4ef6" + deleteCount + "\u4e2a\uff0c\u5220\u9664\u7684\u6587\u4ef6\u96c6\u5408\u4e3a\uff1a" + deleteDirList;
    }
}

