/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.logplatform.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";

    public static byte[] compress(String str, String encoding) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(encoding));
            gzip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static byte[] compress(String str) throws IOException {
        return GzipUtil.compress(str, GZIP_ENCODE_UTF_8);
    }

    public static byte[] uncompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            ungzip.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    public static String uncompressToString(byte[] bytes, String encoding) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            in.close();
            ungzip.close();
            return out.toString(encoding);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String uncompressToString(byte[] bytes) {
        return GzipUtil.uncompressToString(bytes, GZIP_ENCODE_UTF_8);
    }

    public static void main(String[] args) throws IOException {
        String s1 = "aaaaaaaa\u53d1\u6765\u5927\u5bb6\u5206\u5398\u5361\u6c28\u57fa\u9178aaaaaaaaaaaaaaaaaaaaaaaaaaf\u6253\u5927\u5e08\u770b\u5230\u5566\u7684\u5566\u5927\u5783\u573e\u888b\u57c3\u91cc\u514b\u9644\u4ef6\u662f\u963f\u745f\u4e1cJFKaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        String s = null;
        for (int i = 0; i < 20; ++i) {
            s = s + s1;
        }
        System.out.println("\u5b57\u7b26\u4e32\u957f\u5ea6\uff1a" + s.length());
        System.out.println(GzipUtil.compress(s));
        System.out.println("\u538b\u7f29\u540e\uff1a\uff1a" + GzipUtil.compress(s).length);
        System.out.println("\u89e3\u538b\u540e\uff1a" + GzipUtil.uncompress(GzipUtil.compress(s)).length);
        System.out.println("\u89e3\u538b\u5b57\u7b26\u4e32\u540e\uff1a\uff1a" + GzipUtil.uncompressToString(GzipUtil.compress(s)).length());
    }
}

