/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.ohaotian.authority.holder.UserHolder;
import com.ohaotian.authority.model.AuthorityUserInfoBO;
import com.ohaotian.authority.service.AuthorityService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.BeanMapper;
import com.ohaotian.plugin.mapper.MultiHpartyCheckTokenMapper;
import com.ohaotian.plugin.mapper.PluginMultiHpartyCheckMapper;
import com.ohaotian.plugin.model.bo.req.MultiHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenListTaskReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenReqBO;
import com.ohaotian.plugin.model.bo.req.PluginMultiHpartyCheckTokenTaskReqBO;
import com.ohaotian.plugin.model.bo.rsp.PluginMultiHpartyCheckRspBO;
import com.ohaotian.plugin.model.bo.rsp.ResponseVO;
import com.ohaotian.plugin.model.po.MultiHpartyCheckTokenPO;
import com.ohaotian.plugin.model.po.PluginMultiHpartyCheckPO;
import com.ohaotian.plugin.service.MultiHpartyCheckService;
import com.ohaotian.plugin.util.CronCheckUtil;
import com.ohaotian.portalcommon.api.AppAPI;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.api.RegionAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.AppBO;
import com.ohaotian.portalcommon.model.RegionBO;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import java.util.Date;
import javax.annotation.Resource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/multiTokenHPC"})
public class MultiHpartyCheckController {
    private static Logger logger = LogManager.getLogger(MultiHpartyCheckController.class);
    @Resource
    PluginAPI pluginAPI;
    @Resource
    AppAPI appAPI;
    @Resource
    RegionAPI regionAPI;
    @Resource
    PluginMultiHpartyCheckMapper pluginMultiHpartyCheckMapper;
    @Resource
    MultiHpartyCheckTokenMapper multiHpartyCheckTokenMapper;
    @Resource
    private AuthorityService authorityService;
    @Resource
    private MultiHpartyCheckService multiHpartyCheckService;

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginReqBO);
        if (StringUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/pluginExtInfo"})
    @BusiResponseBody
    public RspBO getPluginExtInfo(@RequestBody PluginMultiHpartyCheckReqBO pluginMultiHpartyCheckReqBO) {
        AuthorityUserInfoBO authorityUserInfoBO = this.authorityService.getUserInfoByUserId(UserHolder.getUserId());
        Long tenantId = Long.valueOf(authorityUserInfoBO.getTenantId());
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginMultiHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = new PluginMultiHpartyCheckPO();
        pluginMultiHpartyCheckPO.setPluginId(pluginMultiHpartyCheckReqBO.getPluginId());
        pluginMultiHpartyCheckPO = this.pluginMultiHpartyCheckMapper.queryLimitOne(pluginMultiHpartyCheckPO);
        PluginMultiHpartyCheckRspBO pluginMultiHpartyCheckRspBO = (PluginMultiHpartyCheckRspBO)BeanMapper.map((Object)pluginMultiHpartyCheckPO, PluginMultiHpartyCheckRspBO.class);
        AppBO appBO = this.appAPI.queryAppByRegionCode(tenantId, pluginMultiHpartyCheckPO.getRegionCode());
        RegionBO regionBO = this.regionAPI.queryRegionByAppIdAndRegionCode(appBO.getAppId(), pluginMultiHpartyCheckPO.getRegionCode());
        pluginMultiHpartyCheckRspBO.setAppId(appBO.getAppId());
        pluginMultiHpartyCheckRspBO.setAppRegionName(appBO.getAppName() + "/" + regionBO.getRegionName());
        String[] appRegion = new String[]{appBO.getAppId().toString(), regionBO.getRegionCode()};
        pluginMultiHpartyCheckRspBO.setAppRegion(appRegion);
        return RspBO.success((Object)pluginMultiHpartyCheckRspBO);
    }

    @PostMapping(value={"/pluginExtInfoList"})
    @BusiResponseBody
    public RspBO getPluginExtInfoList(@RequestBody PluginMultiHpartyCheckTokenReqBO pluginMultiHpartyCheckTokenReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginMultiHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckTokenReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        return this.multiHpartyCheckService.getPluginExtInfoList(pluginMultiHpartyCheckTokenReqBO);
    }

    @PostMapping(value={"/modPluginExt"})
    @BusiResponseBody
    public RspBO modPluginExt(@RequestBody PluginMultiHpartyCheckReqBO pluginMultiHpartyCheckReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginMultiHpartyCheckReqBO);
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getPluginHpartyCheckId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (pluginMultiHpartyCheckReqBO.getAppRegion() == null || pluginMultiHpartyCheckReqBO.getAppRegion().length != 2) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5206\u533a");
        }
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aefid");
        }
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atoken\u5237\u65b0\u8def\u5f84");
        }
        boolean isValid = CronCheckUtil.isValidExpression(pluginMultiHpartyCheckReqBO.getRefreshInterval());
        if (!isValid) {
            throw new ZTBusinessException("\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff01");
        }
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5b9a\u65f6\u5237\u65b0\u8868\u8fbe\u5f0f");
        }
        if (pluginMultiHpartyCheckReqBO.getTaskSwitch() == null) {
            throw new ZTBusinessException("\u672a\u5237\u65b0\u4efb\u52a1\u5f00\u5173");
        }
        PluginMultiHpartyCheckPO pluginMultiHpartyCheckPO = (PluginMultiHpartyCheckPO)BeanMapper.map((Object)pluginMultiHpartyCheckReqBO, PluginMultiHpartyCheckPO.class);
        pluginMultiHpartyCheckPO.setRegionCode(pluginMultiHpartyCheckReqBO.getAppRegion()[1]);
        this.pluginMultiHpartyCheckMapper.updatePluginHpartyCheckByPluginHpartyCheckId(pluginMultiHpartyCheckPO);
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/modTokenExt"})
    @BusiResponseBody
    public RspBO modTokenExt(@RequestBody MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)multiHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getHpartyCheckTokenId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getCompanyName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7\u540d");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getOrgId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7Id");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getUsername())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5bc6\u7801");
        }
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = (MultiHpartyCheckTokenPO)BeanMapper.map((Object)multiHpartyCheckTokenReqBO, MultiHpartyCheckTokenPO.class);
        multiHpartyCheckTokenPO.setUpdateTime(new Date());
        multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
        this.multiHpartyCheckTokenMapper.updateHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO);
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/addTokenExt"})
    @BusiResponseBody
    public RspBO addTokenExt(@RequestBody MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)multiHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getClientId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aefid");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getClientSecret())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5ba2\u6237\u7aef\u79d8\u94a5");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getTokenPath())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u8c03\u7528\u8def\u5f84");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getCompanyName())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7\u540d");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getOrgId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7ec4\u7ec7Id");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getUsername())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u7528\u6237\u540d");
        }
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getPassword())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u5bc6\u7801");
        }
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = (MultiHpartyCheckTokenPO)BeanMapper.map((Object)multiHpartyCheckTokenReqBO, MultiHpartyCheckTokenPO.class);
        multiHpartyCheckTokenPO.setUserPassword(multiHpartyCheckTokenReqBO.getPassword());
        MultiHpartyCheckTokenPO judgeOrgId = new MultiHpartyCheckTokenPO();
        judgeOrgId.setOrgId(multiHpartyCheckTokenPO.getOrgId());
        MultiHpartyCheckTokenPO judge = this.multiHpartyCheckTokenMapper.queryLimitOne(judgeOrgId);
        logger.debug((Object)judge);
        if (judge == null) {
            multiHpartyCheckTokenPO.setCreateTime(new Date());
            this.multiHpartyCheckTokenMapper.insertSelective(multiHpartyCheckTokenPO);
            RspBO rspBO = RspBO.success(null);
            logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
            return rspBO;
        }
        return RspBO.error((String)"\u5df2\u5b58\u5728");
    }

    @PostMapping(value={"/delTokenExt"})
    @BusiResponseBody
    public RspBO delTokenExt(@RequestBody MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        logger.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)multiHpartyCheckTokenReqBO);
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getHpartyCheckTokenId())) {
            return RspBO.error((String)"\u672a\u6307\u5b9a\u9700\u8981\u4fee\u6539\u7684\u8bb0\u5f55");
        }
        MultiHpartyCheckTokenPO multiHpartyCheckTokenPO = new MultiHpartyCheckTokenPO();
        multiHpartyCheckTokenPO.setHpartyCheckTokenId(multiHpartyCheckTokenReqBO.getHpartyCheckTokenId());
        MultiHpartyCheckTokenPO judge = this.multiHpartyCheckTokenMapper.queryLimitOne(multiHpartyCheckTokenPO);
        logger.debug((Object)judge);
        if (judge == null) {
            return RspBO.error((String)"\u4e0d\u5b58\u5728");
        }
        this.multiHpartyCheckTokenMapper.deleteHpartyCheckTokenByHpartyCheckTokenId(multiHpartyCheckTokenPO.getHpartyCheckTokenId());
        RspBO rspBO = RspBO.success(null);
        logger.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"executeAll"})
    @BusiResponseBody
    public RspBO executeAll(@RequestBody PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.multiHpartyCheckService.executeAll(pluginMultiHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"execute"})
    @BusiResponseBody
    public RspBO execute(@RequestBody PluginMultiHpartyCheckTokenTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.multiHpartyCheckService.execute(pluginMultiHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"start"})
    @BusiResponseBody
    public RspBO start(@RequestBody PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.multiHpartyCheckService.start(pluginMultiHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"stop"})
    @BusiResponseBody
    public RspBO stop(@RequestBody PluginMultiHpartyCheckTaskReqBO pluginMultiHpartyCheckTaskReqBO) {
        if (StringUtils.isEmpty((Object)pluginMultiHpartyCheckTaskReqBO.getPluginId())) {
            throw new ZTBusinessException("\u672a\u6307\u5b9a\u63d2\u4ef6id");
        }
        return this.multiHpartyCheckService.stop(pluginMultiHpartyCheckTaskReqBO);
    }

    @PostMapping(value={"modifycompanymsg"})
    @BusiResponseBody
    public ResponseVO modifycompanymsg(@RequestBody MultiHpartyCheckTokenReqBO multiHpartyCheckTokenReqBO) {
        if (StringUtils.isEmpty((Object)multiHpartyCheckTokenReqBO.getOrgId())) {
            return ResponseVO.error("\u672a\u6307\u5b9aOrgid");
        }
        if (StringUtils.isEmpty((Object)((Object)multiHpartyCheckTokenReqBO.getType()))) {
            return ResponseVO.error("\u672a\u6307\u5b9atype");
        }
        switch (multiHpartyCheckTokenReqBO.getType()) {
            case put: {
                return this.multiHpartyCheckService.put(multiHpartyCheckTokenReqBO);
            }
            case delete: {
                return this.multiHpartyCheckService.delete(multiHpartyCheckTokenReqBO);
            }
            case modify: {
                return this.multiHpartyCheckService.modify(multiHpartyCheckTokenReqBO);
            }
        }
        throw new ZTBusinessException("\u672a\u6307\u5b9atype");
    }

    @PostMapping(value={"checkIn"})
    @BusiResponseBody
    public RspBO checkIn(@RequestBody PluginMultiHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        if (pluginMultiHpartyCheckTokenTaskReqBO == null || pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.multiHpartyCheckService.checkIn(pluginMultiHpartyCheckTokenTaskReqBO);
    }

    @PostMapping(value={"checkOut"})
    @BusiResponseBody
    public RspBO checkOut(@RequestBody PluginMultiHpartyCheckTokenListTaskReqBO pluginMultiHpartyCheckTokenTaskReqBO) {
        if (pluginMultiHpartyCheckTokenTaskReqBO == null || pluginMultiHpartyCheckTokenTaskReqBO.getHpartyCheckTokenIds().size() < 1) {
            throw new ZTBusinessException("\u672a\u6307\u5b9atokenid");
        }
        return this.multiHpartyCheckService.checkOut(pluginMultiHpartyCheckTokenTaskReqBO);
    }
}

