/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.model.bo.req.AbilityProvideOauth2ReqBo;
import com.ohaotian.plugin.model.bo.req.Oauth2ModifyUserReqBo;
import com.ohaotian.plugin.model.bo.req.Oauth2addUserReqBo;
import com.ohaotian.plugin.model.bo.req.RefreshTokenReqBo;
import com.ohaotian.plugin.model.bo.rsp.AbilityProvideOauth2RspBo;
import com.ohaotian.plugin.model.bo.rsp.Oauth2ModifyUserRspBo;
import com.ohaotian.plugin.model.bo.rsp.Oauth2addUserRspBo;
import com.ohaotian.plugin.model.bo.rsp.RefreshTokenRspBo;
import com.ohaotian.plugin.service.Oauth2PluginUserService;
import com.ohaotian.portalcommon.api.PluginAPI;
import com.ohaotian.portalcommon.constant.CodeMsg;
import com.ohaotian.portalcommon.model.bo.PluginReqBO;
import com.ohaotian.portalcommon.model.bo.PluginRspBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.model.page.RspPage;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/plugin/oauth2"})
public class Oauth2Controller {
    private static final Logger log = LoggerFactory.getLogger(Oauth2Controller.class);
    @Resource
    PluginAPI pluginAPI;
    @Autowired
    private Oauth2PluginUserService oauth2PluginUserService;

    @PostMapping(value={"/pluginInfo"})
    @BusiResponseBody
    public RspBO getPluginInfo(@RequestBody PluginReqBO pluginReqBO) {
        log.debug("\u300b\u300b\u300b\u300b\u300b\u300b\u5165\u53c2\uff1a{}", (Object)pluginReqBO);
        if (ObjectUtils.isEmpty((Object)pluginReqBO.getPluginId())) {
            throw new ZTBusinessException(CodeMsg.QUERY_COND_EMPTY.getMessage());
        }
        PluginRspBO pluginRspBO = this.pluginAPI.getPluginInfo(pluginReqBO.getPluginId());
        RspBO rspBO = RspBO.success((Object)pluginRspBO);
        log.debug("\u300a\u300a\u300a\u300a\u300a\u300a\u51fa\u53c2\uff1a{}", (Object)rspBO);
        return rspBO;
    }

    @PostMapping(value={"/addUser"})
    @BusiResponseBody
    public RspBO<Oauth2addUserRspBo> addUser(@RequestBody Object reqBo) {
        Oauth2addUserReqBo addUserReqBo = (Oauth2addUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2addUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getUsername())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getPassword())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getClientId())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (addUserReqBo.getClientId().length() >= 13) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u8bf7\u9650\u5236\u5230\u226412\u4f4d [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (!addUserReqBo.getClientId().matches("[\\x00-\\x7F]+")) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u5305\u542b\u4e2d\u6587 [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (!addUserReqBo.getClientId().matches("[a-zA-Z].*")) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u9996\u5b57\u7b26\u53ea\u80fd\u4e3a\u5b57\u6bcd [\u5b8c\u6574\u683c\u5f0f\uff1a\u9996\u5b57\u7b26\u4e3a\u5b57\u6bcd\uff0c\u4e0d\u5305\u542b\u4e2d\u6587\uff0c\u957f\u5ea6\u226412]");
        }
        if (ObjectUtils.isEmpty((Object)addUserReqBo.getClusterId())) {
            throw new ZTBusinessException("\u96c6\u7fa4ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Oauth2addUserRspBo rsp = this.oauth2PluginUserService.addUser(addUserReqBo);
        if (Boolean.TRUE.equals(rsp.isSuccess())) {
            return RspBO.success((Object)rsp);
        }
        return RspBO.error((String)rsp.getResultMessage());
    }

    @PostMapping(value={"/accessToken"})
    @BusiResponseBody
    public RefreshTokenRspBo accessToken(@RequestBody Object obj) {
        RefreshTokenReqBo reqBo = this.accessTokenCheckReq(obj);
        return this.oauth2PluginUserService.accessToken(reqBo);
    }

    @PostMapping(value={"/mock/accessToken"})
    @BusiResponseBody
    public RspBO<RefreshTokenRspBo> mockAccessToken(@RequestBody Object obj) {
        RefreshTokenReqBo reqBo = this.accessTokenCheckReq(obj);
        RefreshTokenRspBo rspBo = new RefreshTokenRspBo();
        try {
            rspBo = this.oauth2PluginUserService.accessToken(reqBo);
        }
        catch (Exception e) {
            rspBo.setResultMessage("\u6a21\u62df\u8c03\u7528\u5f02\u5e38:" + e.getMessage());
            rspBo.setSuccess(Boolean.FALSE);
        }
        return RspBO.success((Object)rspBo);
    }

    private RefreshTokenReqBo accessTokenCheckReq(@RequestBody Object obj) {
        RefreshTokenReqBo reqBo = (RefreshTokenReqBo)JSON.parseObject((String)JSON.toJSONString((Object)obj), RefreshTokenReqBo.class);
        if (ObjectUtils.isEmpty((Object)reqBo.getUserName())) {
            throw new ZTBusinessException("\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getUserPassword())) {
            throw new ZTBusinessException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!"access_token".equals(reqBo.getGrantType())) {
            throw new ZTBusinessException("\u9274\u6743\u7c7b\u578b\u5f02\u5e38");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getClientId())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aefID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getClientSecret())) {
            throw new ZTBusinessException("\u5ba2\u6237\u7aef\u79d8\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)reqBo.getTimestamp())) {
            throw new ZTBusinessException("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return reqBo;
    }

    @PostMapping(value={"/selectUserList"})
    @BusiResponseBody
    public RspBO<RspPage<AbilityProvideOauth2RspBo>> selectUserList(@RequestBody Object obj) {
        AbilityProvideOauth2ReqBo reqBo = (AbilityProvideOauth2ReqBo)JSON.parseObject((String)JSON.toJSONString((Object)obj), AbilityProvideOauth2ReqBo.class);
        return this.oauth2PluginUserService.selectUserList(reqBo);
    }

    @PostMapping(value={"/modifyUserPassword"})
    @BusiResponseBody
    public RspBO<Oauth2ModifyUserRspBo> modifyUserPassword(@RequestBody Object reqBo) {
        Oauth2ModifyUserReqBo modifyUserReqBo = (Oauth2ModifyUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2ModifyUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOauthId())) {
            throw new ZTBusinessException("\u9274\u6743\u8d26\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOldPassword())) {
            throw new ZTBusinessException("\u5386\u53f2\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getNewPassword())) {
            throw new ZTBusinessException("\u4fee\u6539\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Oauth2ModifyUserRspBo rsp = this.oauth2PluginUserService.modifyUserPassword(modifyUserReqBo);
        if (Boolean.TRUE.equals(rsp.isSuccess())) {
            return RspBO.success((Object)rsp);
        }
        return RspBO.error((String)rsp.getResultMessage());
    }

    @PostMapping(value={"/checkOut"})
    @BusiResponseBody
    public RspBO<String> checkOut(@RequestBody Object reqBo) {
        Oauth2ModifyUserReqBo modifyUserReqBo = (Oauth2ModifyUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2ModifyUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOauthId())) {
            throw new ZTBusinessException("\u9274\u6743\u8d26\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.oauth2PluginUserService.checkOut(modifyUserReqBo);
    }

    @PostMapping(value={"/checkIn"})
    @BusiResponseBody
    public RspBO<String> checkIn(@RequestBody Object reqBo) {
        Oauth2ModifyUserReqBo modifyUserReqBo = (Oauth2ModifyUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2ModifyUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOauthId())) {
            throw new ZTBusinessException("\u9274\u6743\u8d26\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.oauth2PluginUserService.checkIn(modifyUserReqBo);
    }

    @PostMapping(value={"/deleteUser"})
    @BusiResponseBody
    public RspBO<String> deleteUser(@RequestBody Object reqBo) {
        Oauth2ModifyUserReqBo modifyUserReqBo = (Oauth2ModifyUserReqBo)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), Oauth2ModifyUserReqBo.class);
        if (ObjectUtils.isEmpty((Object)modifyUserReqBo.getOauthId())) {
            throw new ZTBusinessException("\u9274\u6743\u8d26\u53f7ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.oauth2PluginUserService.deleteUser(modifyUserReqBo);
    }
}

