/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.config;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.piscesplatform.model.bo.AbilityInterfaceTaskVersionReqBo;
import com.ohaotian.piscesplatform.model.bo.InsertTaskReqBo;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.util.StrUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ObjectUtils;

public class ExportDocxToExcel {
    public static Map<String, JSONObject> childObj = new HashMap<String, JSONObject>();

    public static void exportDocxToExcel(InsertTaskReqBo insertTaskReqBo, HttpServletResponse response) throws IOException {
        AbilityInterfaceTaskVersionReqBo taskVersionInfo = insertTaskReqBo.getTaskVersionInfo();
        String taskName = StringUtils.isNotBlank((CharSequence)insertTaskReqBo.getTaskName()) ? insertTaskReqBo.getTaskName() : "\u9ed8\u8ba4\u4efb\u52a1";
        String taskVersion = StringUtils.isNotBlank((CharSequence)taskVersionInfo.getVersion()) ? taskVersionInfo.getVersion() : "v1";
        String fileName = new String((taskName + "-" + taskVersion + "-" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date())).getBytes(), StandardCharsets.UTF_8);
        ServletOutputStream out = response.getOutputStream();
        response.setContentType("multipart/form-data");
        response.setCharacterEncoding("utf-8");
        response.setHeader("File-name", fileName + ".xlsx");
        response.setHeader("File-type", "Stream");
        ArrayList<ExportBO> exportBOList = new ArrayList<ExportBO>();
        JSONObject reqObj = ExportDocxToExcel.docxStringToObj(taskVersionInfo.getReqDocxData());
        JSONObject rspObj = ExportDocxToExcel.docxStringToObj(taskVersionInfo.getRspDocxData());
        ExportDocxToExcel.buildSheets(reqObj, exportBOList, "-req");
        ExportDocxToExcel.buildSheets(rspObj, exportBOList, "-rsp");
        ExcelWriter writer = new ExcelWriter((OutputStream)out, ExcelTypeEnum.XLSX, true);
        for (ExportBO bo : exportBOList) {
            writer.write1(bo.getRows(), bo.getSheet());
        }
        writer.finish();
        out.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String docxTypeToExcelType(String type, String targetField, JSONObject fieldInfo) {
        if (!"Object".equals(type)) {
            if (!"Array".equals(type)) return type;
            JSONObject items = (JSONObject)fieldInfo.get((Object)"items");
            String itemType = items.get((Object)"type").toString();
            return "List<" + ExportDocxToExcel.docxTypeToExcelType(itemType, targetField, items) + ">";
        }
        Object properties = fieldInfo.get((Object)"properties");
        if (!Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)properties))) return "Object";
        type = targetField.toUpperCase();
        childObj.put(type, (JSONObject)properties);
        return type;
    }

    public static void getFieldRow(List<List<Object>> rows, JSONObject properties) {
        for (Map.Entry entry : properties.entrySet()) {
            ArrayList column = Lists.newArrayList();
            String targetField = (String)entry.getKey();
            JSONObject fieldInfo = (JSONObject)entry.getValue();
            column.add(fieldInfo.get((Object)"originField"));
            column.add(targetField);
            column.add(fieldInfo.get((Object)"description"));
            column.add(ExportDocxToExcel.docxTypeToExcelType(fieldInfo.get((Object)"type").toString(), targetField, fieldInfo));
            column.add(fieldInfo.get((Object)"notNull"));
            column.add(fieldInfo.get((Object)"defaultValue"));
            rows.add(column);
        }
    }

    public static List<List<Object>> buildRows(JSONObject jsonObject) {
        ArrayList rows = Lists.newArrayList();
        Object properties = jsonObject.get((Object)"properties");
        if (properties != null) {
            JSONObject abilityProperties = (JSONObject)properties;
            ExportDocxToExcel.getFieldRow(rows, abilityProperties);
            if (Boolean.FALSE.equals(childObj.isEmpty())) {
                Iterator<Map.Entry<String, JSONObject>> iterator = childObj.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, JSONObject> childEntry = iterator.next();
                    String objectName = childEntry.getKey();
                    ArrayList objNameRow = Lists.newArrayList();
                    objNameRow.add(objectName);
                    rows.add(objNameRow);
                    ExportDocxToExcel.getFieldRow(rows, childEntry.getValue());
                    iterator.remove();
                }
            }
        }
        return rows;
    }

    public static List<ExportBO> buildSheets(JSONObject jsonObject, List<ExportBO> exportBOList, String reqOrRspName) {
        int position = 1;
        List columns = Stream.of("\u6e90\u5355\u5b57\u6bb5", "\u76ee\u6807\u5b57\u6bb5", "\u5b57\u6bb5\u8bf4\u660e", "\u5b57\u6bb5\u7c7b\u578b", "\u5fc5\u4f20", "\u9ed8\u8ba4\u503c").collect(Collectors.toList());
        for (Map.Entry entry : jsonObject.entrySet()) {
            String sheetName = (String)entry.getKey() + reqOrRspName;
            ExportBO exportBO = ExportBO.builder().sheetName(sheetName).columns(columns).position(Integer.valueOf(position)).build();
            Sheet sheet = new Sheet(position++, 3);
            sheet.setSheetName(sheetName);
            sheet.setAutoWidth(Boolean.TRUE);
            ArrayList header = Lists.newArrayList();
            for (String column : columns) {
                ArrayList strs = Lists.newArrayList();
                strs.add(StrUtil.unlineToCamel((String)column));
                header.add(strs);
            }
            sheet.setHead((List)header);
            exportBO.setSheet(sheet);
            exportBO.setRows(ExportDocxToExcel.buildRows((JSONObject)entry.getValue()));
            exportBOList.add(exportBO);
        }
        return exportBOList;
    }

    public static JSONObject docxStringToObj(String docxString) {
        if (docxString != null && docxString.length() != 0) {
            return JSON.parseObject((String)docxString);
        }
        return new JSONObject();
    }
}

