/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.piscesplatform.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.piscesplatform.util.AdvancedJsonToXmlUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.model.baseEnum.BaseAttributes;
import com.ohaotian.plugin.model.baseEnum.BaseMethods;
import com.ohaotian.plugin.model.baseEnum.BaseTags;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.springframework.util.ObjectUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class RuleToXmlUtil {
    public static final String TAG_REPLACE = "##";
    public static final String LIST_REPLACE = "[]";
    public static final String RETURN_REPLACE = "&&";
    public static final String INTERFACE_TEMPLATE = BaseTags.TAG_INTERFACE.getTemplate();
    public static final String VALUATION_TEMPLATE = BaseTags.TAG_VALUATION.getTemplate();
    public static final String VARIABLE_TEMPLATE = BaseTags.TAG_VARIABLE.getTemplate();
    public static final String IF_TEMPLATE = BaseTags.TAG_IF.getTemplate();
    public static final String FOR_TEMPLATE = BaseTags.TAG_FOR.getTemplate();
    public static final String CLASS_TEMPLATE = BaseTags.TAG_CLASS.getTemplate();
    public static final String PARAM_TEMPLATE = BaseTags.TAG_PARAM.getTemplate();
    public static final String PRINT_TEMPLATE = BaseTags.TAG_PRINT.getTemplate();
    public static final String ROOT_PATH = "$.system.variable.";
    public static final String OBJECT_ROOT_PATH_REQ = "$.system.variable.reqText.";
    public static final String OBJECT_ROOT_PATH_RSP = "$.system.variable.rspText.";
    public static String REQ_PATH = "";
    public static String REQ_OR_RSP = "req";
    public static final String TARGET_PATH = "$.system.variable.targetText.";
    public static final String CHILD_RETURN_PATH = "$.system.variable.defaultReturn.";

    public static void initReqPath() {
        if ("req".equals(REQ_OR_RSP)) {
            REQ_PATH = OBJECT_ROOT_PATH_REQ;
        } else if ("rsp".equals(REQ_OR_RSP)) {
            REQ_PATH = OBJECT_ROOT_PATH_RSP;
        } else {
            throw new ZTBusinessException("REQ_OR_RSP\u6807\u8bc6\u7b26\u5185\u5bb9\u9519\u8bef\uff1a" + REQ_OR_RSP);
        }
    }

    public static String ruleToXmlUtil(String docx, String rule) {
        JSONObject docxObject = JSON.parseObject((String)docx);
        JSONArray ruleArray = JSON.parseArray((String)rule);
        if ((ObjectUtils.isEmpty((Object)docx) || ObjectUtils.isEmpty((Object)docxObject)) && (ObjectUtils.isEmpty((Object)rule) || ObjectUtils.isEmpty((Object)ruleArray))) {
            return null;
        }
        if (StringUtils.isNotBlank((CharSequence)rule) && Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)ruleArray))) {
            return AdvancedJsonToXmlUtil.advancedJsonToXml(rule);
        }
        try {
            StringBuilder xml = new StringBuilder();
            JSONObject docxJson = JSON.parseObject((String)docx, (Feature[])new Feature[]{Feature.OrderedField});
            int abilityCount = 0;
            for (Map.Entry abilityJson : docxJson.entrySet()) {
                String abilityEname = (String)abilityJson.getKey();
                JSONObject abilityObject = (JSONObject)JSON.toJSON(abilityJson.getValue());
                String type = abilityObject.get((Object)"type").toString();
                if ("Array".equals(type)) {
                    REQ_PATH = ROOT_PATH;
                } else if ("Object".equals(type)) {
                    RuleToXmlUtil.initReqPath();
                } else {
                    throw new ZTBusinessException(abilityEname + "\u80fd\u529b\u7684\u6570\u636e\u7c7b\u578b\u9519\u8bef\uff01\u5f53\u524d\u7c7b\u578b\u4e3a" + type);
                }
                String abilityXml = RuleToXmlUtil.getPropertiesXml((JSONObject)JSON.toJSON((Object)abilityObject.get((Object)"properties")), TARGET_PATH + abilityEname);
                xml.append(abilityXml);
                if (docxJson.size() != ++abilityCount) {
                    xml.append(RuleToXmlUtil.getInvokeXml(abilityEname));
                    continue;
                }
                RuleToXmlUtil.initReqPath();
                xml.append(RuleToXmlUtil.getValuationXml(RETURN_REPLACE + abilityEname, "String", REQ_PATH.substring(0, REQ_PATH.length() - 1)));
            }
            xml = new StringBuilder(INTERFACE_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(xml.toString())));
            return RuleToXmlUtil.formatXml(xml.toString(), 4, false);
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    public static String getJSONObjectXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        Map<String, String> properties = RuleToXmlUtil.getProperties(jsonObject);
        if (ObjectUtils.isEmpty((Object)properties.get("type"))) {
            throw new ZTBusinessException("\u76ee\u6807\u5b57\u6bb5\u4e3a" + parentField + "\u5b57\u6bb5type\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u7ed3\u6784!");
        }
        if ("JSONArray".equals(properties.get("type"))) {
            String itemsXml;
            if (properties.get("items").isEmpty()) {
                throw new ZTBusinessException("\u76ee\u6807\u5b57\u6bb5\u4e3a" + parentField + "\u7684Array\u7c7b\u578b\u4e0b\u9762 \u6ca1\u6709\u6307\u5b9aitems\uff0c\u8bf7\u5f00\u53d1\u4eba\u5458\u68c0\u67e5\uff01");
            }
            JSONObject itemsObject = JSON.parseObject((String)properties.get("items"));
            if (StringUtils.isNotBlank((CharSequence)properties.get("originField"))) {
                itemsObject.put("originField", (Object)properties.get("originField"));
            }
            if (StringUtils.isNotBlank((CharSequence)properties.get("defaultValue"))) {
                itemsObject.put("defaultValue", (Object)properties.get("defaultValue"));
            }
            if (StringUtils.isNotBlank((CharSequence)(itemsXml = RuleToXmlUtil.getItemsXml(itemsObject, parentField)))) {
                xml.append(itemsXml);
                return xml.toString();
            }
        }
        if (Boolean.FALSE.equals(StringUtils.isNotBlank((CharSequence)properties.get("defaultValue")) || StringUtils.isNotBlank((CharSequence)properties.get("originField")) || StringUtils.isNotBlank((CharSequence)properties.get("properties")) || StringUtils.isNotBlank((CharSequence)properties.get("class")))) {
            return null;
        }
        if (properties.get("description") != null) {
            xml.append(RuleToXmlUtil.getDescriptionXml(properties.get("description")));
        }
        if (properties.get("defaultValue") != null) {
            xml.append(RuleToXmlUtil.getDefaultValueXml(properties.get("defaultValue"), properties.get("type"), parentField));
        }
        if (StringUtils.isNotBlank((CharSequence)properties.get("class"))) {
            xml.append(RuleToXmlUtil.getClassXml(properties.get("class"), properties.get("type"), parentField));
            if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
                xml.append(RuleToXmlUtil.getNotNullXml(parentField));
            }
            return xml.toString();
        }
        if (StringUtils.isNotBlank((CharSequence)properties.get("originField"))) {
            xml.append(RuleToXmlUtil.getValuationXml(properties.get("originField"), properties.get("type"), parentField));
            if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
                xml.append(RuleToXmlUtil.getNotNullXml(parentField));
            }
            return xml.toString();
        }
        if ("JSONObject".equals(properties.get("type"))) {
            if (StringUtils.isNotBlank((CharSequence)properties.get("properties"))) {
                String propertiesXml = RuleToXmlUtil.getPropertiesXml(JSON.parseObject((String)properties.get("properties"), (Feature[])new Feature[]{Feature.OrderedField}), parentField);
                if (propertiesXml != null) {
                    xml.append(propertiesXml);
                }
            } else {
                throw new ZTBusinessException(parentField + "\u76ee\u6807\u5b57\u6bb5\u7684\u5b69\u5b50\u8282\u70b9\u6570\u636e\u4e3a\u7a7a\uff01\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f");
            }
        }
        if (properties.get("notNull") != null && "true".equals(properties.get("notNull"))) {
            xml.append(RuleToXmlUtil.getNotNullXml(parentField));
        }
        return xml.toString();
    }

    public static String getPropertiesXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String jsonObjectXml = RuleToXmlUtil.getJSONObjectXml((JSONObject)JSON.toJSON(value), parentField + "." + key);
            if (jsonObjectXml == null) continue;
            xml.append(jsonObjectXml);
        }
        return xml.toString();
    }

    public static String getItemsXml(JSONObject jsonObject, String parentField) {
        StringBuilder xml = new StringBuilder();
        Map<String, String> properties = RuleToXmlUtil.getProperties(jsonObject);
        String tempListName = "";
        String originField = properties.get("originField");
        String defaultValue = properties.get("defaultValue");
        if (StringUtils.isNotBlank((CharSequence)originField)) {
            int lastDotIndex = originField.lastIndexOf(".");
            tempListName = lastDotIndex == -1 ? originField : originField.substring(lastDotIndex + 1);
        }
        if (StringUtils.isNotBlank((CharSequence)properties.get("properties"))) {
            String propertiesXml = tempListName.isEmpty() ? RuleToXmlUtil.getPropertiesXml(JSON.parseObject((String)properties.get("properties"), (Feature[])new Feature[]{Feature.OrderedField}), parentField + "[0]") : RuleToXmlUtil.getPropertiesXml(JSON.parseObject((String)properties.get("properties"), (Feature[])new Feature[]{Feature.OrderedField}), parentField + "[*" + tempListName + "*]");
            if (StringUtils.isNotBlank((CharSequence)propertiesXml)) {
                String stopCountField = originField;
                stopCountField = ObjectUtils.isEmpty((Object)stopCountField) ? "1" : (stopCountField.startsWith(TAG_REPLACE) ? RuleToXmlUtil.arrayItemConversion(CHILD_RETURN_PATH + stopCountField.substring(2) + ".length()") : RuleToXmlUtil.arrayItemConversion(REQ_PATH + stopCountField + ".length()"));
                String forXml = FOR_TEMPLATE.replaceFirst(TAG_REPLACE, "0");
                forXml = forXml.replaceFirst(TAG_REPLACE, "&lt;");
                forXml = forXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(stopCountField));
                forXml = forXml.replaceFirst(TAG_REPLACE, "++");
                forXml = forXml.replaceFirst(TAG_REPLACE, tempListName.isEmpty() ? "tempName" : tempListName);
                forXml = forXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(propertiesXml));
                xml.append(forXml);
            } else if (StringUtils.isNotBlank((CharSequence)originField)) {
                xml.append(RuleToXmlUtil.getValuationXml(originField, "JSONArray", parentField));
            } else if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                xml.append(RuleToXmlUtil.getValuationXml(defaultValue, "JSONArray", parentField));
            }
        }
        return xml.toString();
    }

    public static Map<String, String> getProperties(JSONObject jsonObject) {
        HashMap<String, String> properties = new HashMap<String, String>(7);
        block10: for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            switch (key) {
                case "type": {
                    if ("Object".equals(value.toString())) {
                        properties.put("type", "JSONObject");
                        continue block10;
                    }
                    if ("Array".equals(value.toString())) {
                        properties.put("type", "JSONArray");
                        continue block10;
                    }
                    properties.put("type", value.toString());
                    continue block10;
                }
                case "class": 
                case "properties": 
                case "items": {
                    properties.put(key, JSON.toJSONString(value));
                    continue block10;
                }
            }
            properties.put(key, value.toString());
        }
        return properties;
    }

    public static String getInvokeXml(String abilityEname) {
        String invokeJsonString = "{\"method\":\"Ability.invoke(msgContext, svcName, version, reqData, inputProtocol)\",\"param\":[{\"type\":\"Object\",\"originField\":\"$.system.base\"},{\"type\":\"String\",\"defaultValue\":\"" + abilityEname + "\"},{\"type\":\"String\",\"defaultValue\":\"v1\"},{\"type\":\"String\",\"originField\":\"" + TARGET_PATH + abilityEname + "\"}]}";
        String returnType = "JSONObject";
        String returnField = CHILD_RETURN_PATH + abilityEname;
        return RuleToXmlUtil.getClassXml(invokeJsonString, returnType, returnField);
    }

    public static String getDescriptionXml(String description) {
        return "<!-- " + description + " -->";
    }

    public static String getDefaultValueXml(String defaultValue, String type, String parentField) {
        defaultValue = defaultValue.replace("\"", "&quot;");
        String defaultValueXml = VALUATION_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField));
        defaultValueXml = defaultValueXml.replaceFirst(TAG_REPLACE, type);
        defaultValueXml = defaultValueXml.replaceFirst(TAG_REPLACE, defaultValue);
        return defaultValueXml;
    }

    public static String getValuationXml(String originField, String type, String parentField) {
        String inPath = RuleToXmlUtil.conversionOriginFiled(originField);
        String valuationXml = VALUATION_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(parentField));
        valuationXml = valuationXml.replaceFirst(TAG_REPLACE, type);
        valuationXml = valuationXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(inPath));
        return valuationXml;
    }

    public static String conversionOriginFiled(String originField) {
        if ((originField = RuleToXmlUtil.arrayItemConversion(originField)).contains(RETURN_REPLACE)) {
            originField = originField.replace(RETURN_REPLACE, TARGET_PATH);
        } else if (originField.contains(TAG_REPLACE)) {
            originField = CHILD_RETURN_PATH + originField.substring(2);
        } else if (originField.length() != 0) {
            originField = REQ_PATH + originField;
        }
        return originField;
    }

    public static String arrayItemConversion(String originField) {
        if (originField.contains(LIST_REPLACE)) {
            String[] originFields = originField.split("\\.");
            originField = "";
            for (String field : originFields) {
                originField = field.endsWith(LIST_REPLACE) ? originField + field.replace(LIST_REPLACE, "[*" + field.substring(0, field.length() - 2) + "*]") : originField + field;
                originField = originField + ".";
            }
            if (originField.endsWith(".")) {
                originField = originField.substring(0, originField.length() - 1);
            }
        }
        return originField;
    }

    public static String getNotNullXml(String originField) {
        String printXml = PRINT_TEMPLATE.replaceFirst(TAG_REPLACE, "");
        printXml = printXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(originField + "\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u62a5\u6587"));
        String ifXml = IF_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(originField));
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "==");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "null");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "null");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, "");
        ifXml = ifXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(printXml));
        return "";
    }

    public static String getClassXml(String classString, String type, String returnField) {
        try {
            JSONObject classObject = JSON.parseObject((String)classString);
            String inPath = "";
            if (Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)classObject.get((Object)BaseAttributes.ATTRIBUTE_INPATH.getCode())))) {
                inPath = RuleToXmlUtil.conversionOriginFiled(classObject.get((Object)BaseAttributes.ATTRIBUTE_INPATH.getCode()).toString());
            }
            String method = classObject.get((Object)BaseAttributes.ATTRIBUTE_METHOD.getCode()).toString();
            JSONArray params = (JSONArray)classObject.get((Object)BaseTags.TAG_PARAM.getCode().toLowerCase());
            String[] paramAndValuation = BaseMethods.getWithCode((String)method).getTemplate().split(",");
            String[] paramCounts = paramAndValuation[1].split(":");
            boolean checkParamCount = Boolean.FALSE;
            for (String paramCount : paramCounts) {
                if (!paramCount.equals(params.size() + "")) continue;
                checkParamCount = Boolean.TRUE;
            }
            if (Boolean.FALSE.equals(checkParamCount)) {
                throw new ZTBusinessException("\u6267\u884c\u65b9\u6cd5" + method + "\u7684\u65f6\u5019\uff0c\u53c2\u6570\u4e2a\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            String valuationCount = paramAndValuation[2];
            String classXml = CLASS_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(inPath));
            classXml = classXml.replaceFirst(TAG_REPLACE, method);
            String methodXml = "";
            for (Object param : params) {
                JSONObject paramMap = (JSONObject)param;
                String paramXml = "";
                if (ObjectUtils.isEmpty((Object)paramMap.get((Object)"originField")) && Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)paramMap.get((Object)"defaultValue")))) {
                    paramXml = PARAM_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(paramMap.get((Object)"defaultValue").toString()));
                } else if (ObjectUtils.isEmpty((Object)paramMap.get((Object)"defaultValue")) && Boolean.FALSE.equals(ObjectUtils.isEmpty((Object)paramMap.get((Object)"originField")))) {
                    paramXml = PARAM_TEMPLATE.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(RuleToXmlUtil.conversionOriginFiled(paramMap.get((Object)"originField").toString())));
                } else {
                    throw new ZTBusinessException(method + "\u65b9\u6cd5\u4e2d\u6ca1\u6307\u5b9a\u5165\u53c2\u6216\u8005\u65e2\u6307\u5b9a\u4e86\u9ed8\u8ba4\u503c\u53c8\u6307\u5b9a\u4e86\u6e90\u5355\u5b57\u6bb5");
                }
                paramXml = paramXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(paramMap.get((Object)"type").toString()));
                methodXml = methodXml + paramXml;
            }
            if (Boolean.FALSE.equals("0".equals(valuationCount))) {
                methodXml = methodXml + RuleToXmlUtil.getValuationXml("", type, returnField);
            }
            classXml = classXml.replaceFirst(TAG_REPLACE, Matcher.quoteReplacement(methodXml));
            return classXml;
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u83b7\u53d6Class\u6807\u7b7e\u9519\u8bef\uff0c\u76ee\u6807\u5b57\u6bb5\u4e3a\uff1a" + returnField + "\u5f02\u5e38\u8be6\u60c5\u4e3a\uff1a" + e.getMessage());
        }
    }

    public static String formatXml(String xmlString, int indent, boolean ignoreDeclaration) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setXIncludeAware(false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader(xmlString));
            Document document = db.parse(src);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            transformerFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            transformerFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("omit-xml-declaration", ignoreDeclaration ? "yes" : "no");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indent));
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            return ((Object)out).toString();
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u683c\u5f0f\u5316xml\u51fa\u9519:\n" + xmlString);
        }
    }

    @Test
    public void t() throws IOException {
        File file = new File("E:\\Tydic\\Git\\Ability\\ability-base\\ability-admin-plugin\\admin-pisces-platform\\src\\main\\java\\com\\ohaotian\\piscesplatform\\util\\testDocx.json");
        String s = FileUtils.readFileToString((File)file, (String)"UTF-8");
        String s1 = RuleToXmlUtil.ruleToXmlUtil(s, "");
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println(s1);
        File writeFile = new File("E:\\Tydic\\Git\\Ability\\ability-base\\ability-admin-plugin\\admin-pisces-platform\\src\\main\\java\\com\\ohaotian\\piscesplatform\\util\\testDocx.xml");
        FileOutputStream fos = new FileOutputStream(writeFile, false);
        fos.write(s1.getBytes());
        fos.close();
    }
}

