/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service.impl;

import com.alibaba.excel.metadata.Sheet;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mapper.PluginPriorityMapper;
import com.ohaotian.plugin.model.po.PluginPriorityPO;
import com.ohaotian.portalcommon.annotation.PluginTypeHandlerType;
import com.ohaotian.portalcommon.enums.ExtensionPointPositionEnum;
import com.ohaotian.portalcommon.model.bo.AbilityPluginReqBO;
import com.ohaotian.portalcommon.model.bo.ExportBO;
import com.ohaotian.portalcommon.model.bo.RspBO;
import com.ohaotian.portalcommon.strategy.AbstractPluginHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
@PluginTypeHandlerType(value="priority", position=ExtensionPointPositionEnum.EXPORT_POSITION)
public class PriorityExportHandler
extends AbstractPluginHandler<List<ExportBO>> {
    @Resource
    private PluginPriorityMapper pluginPriorityMapper;

    public RspBO<List<ExportBO>> handleGetAbilityPlugin(AbilityPluginReqBO abilityPluginReqBO) throws ZTBusinessException {
        ArrayList exportBOList = Lists.newArrayList();
        List abilityPluginDeployIds = abilityPluginReqBO.getAbilityPluginDeployIds();
        List<PluginPriorityPO> pluginPriorityPOList = this.pluginPriorityMapper.queryPluginByPluginDeployIds(abilityPluginDeployIds);
        ArrayList provideDeployRows = Lists.newArrayList();
        Sheet sheet = new Sheet(1, 3);
        sheet.setSheetName("plugin_priority");
        sheet.setAutoWidth(Boolean.TRUE);
        ArrayList header = Lists.newArrayList();
        ArrayList strs = Lists.newArrayList();
        strs.add("pluginPriorityId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("abilityPluginDeployId");
        header.add(strs);
        strs = Lists.newArrayList();
        strs.add("priority");
        header.add(strs);
        sheet.setHead((List)header);
        for (PluginPriorityPO pluginPriorityPO : pluginPriorityPOList) {
            ArrayList objs = Lists.newArrayList();
            objs.add(pluginPriorityPO.getPluginPriorityId());
            objs.add(pluginPriorityPO.getAbilityPluginDeployId());
            objs.add(pluginPriorityPO.getPriority());
            provideDeployRows.add(objs);
        }
        ExportBO exportBO = ExportBO.builder().sheet(sheet).rows((List)provideDeployRows).build();
        exportBOList.add(exportBO);
        return RspBO.success((Object)exportBOList);
    }
}

