/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.constant.ConstantBaseVersion;
import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.AbilityPluginBO;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.RegionBO;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.model.bo.system.SelfDefHeader;
import com.ohaotian.abilitycommon.model.bo.system.TlogReqHeader;
import com.ohaotian.abilitycommon.plugin.PluginC;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.atp.base.model.AbilityRedisTokenDataBo;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.model.bo.G3PlusReturnMsgReqBO;
import com.ohaotian.plugin.model.bo.G3PlusReturnMsgRspBO;
import com.ohaotian.plugin.service.CallG3PlusService;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="g3PlusHPC")
public class G3PlusHpartyCheckService
implements PluginC {
    private static final Logger logger = LogManager.getLogger(G3PlusHpartyCheckService.class);
    @Resource
    private CacheClient cacheClient;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Autowired
    private ConstantBaseVersion constantBaseVersion;

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> "g3PlusHPC".equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                logger.debug("g3PlusHpartyCheck\u6821\u9a8c\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            logger.info("G3PlusHPC : \u6267\u884c\u63d2\u4ef6\u52a0\u5bc6 --> AbilityId : {} AbilityName : {}", (Object)msgContext.getEsbAbility().getAbilityId(), (Object)msgContext.getEsbAbility().getAbilityName());
            RegionBO regionBO = msgContext.getSelfDefHeader().getRegionBO();
            String regionCode = regionBO.getRegionCode();
            logger.debug("\u83b7\u53d6\u8def\u7531\u540e\u7684\u7f16\u7801\u4e3a:" + regionCode);
            String key = this.constantBaseVersion.getATP() + "g3PlusHPC-" + this.nodeInfoConfig.getClusterId() + "-" + regionCode + "-token";
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)this.cacheClient.get(key).toString(), AbilityRedisTokenDataBo.class);
            String token = abilityRedisTokenDataBo.getToken();
            String authPassword = abilityRedisTokenDataBo.getClientSecret();
            if (StringUtils.isEmpty((Object)token)) {
                logger.warn("G3PlusHpartyCheckService >>> \u6b64\u5206\u533atoken\u672a\u914d\u7f6e");
                return;
            }
            TlogReqHeader tlogReqHeader = msgContext.getTlogReqHeader();
            Map headersMap = tlogReqHeader.getHeadersMap();
            headersMap.put("Content-type", "application/json;charset=utf8");
            headersMap.put("Authorization", "Bearer " + token);
            tlogReqHeader.setHeadersMap(headersMap);
            SelfDefHeader selfDefHeader = msgContext.getSelfDefHeader();
            selfDefHeader.setSelfDefMap(headersMap);
            HashMap reqMap = Maps.newHashMap();
            Map req = this.json2Map(new String(tlogReqHeader.getReqData(), "UTF-8"));
            req.forEach((k, y) -> reqMap.put(k, y));
            logger.debug("g3PlusHpartyCheckService--web reqMap\u5f00\u59cb --> {}", (Object)reqMap);
            List<String> appendList = Arrays.asList(abilityRedisTokenDataBo.getAppends().split(","));
            if (appendList.size() > 0) {
                reqMap.put("token", token);
            }
            logger.debug("G3PlusHpartyCheckPlugin--web: reqMap\u5c01\u88c5\u7ed3\u675f --> {}", (Object)reqMap);
            switch (abilityRedisTokenDataBo.getCallProtocol().toString()) {
                case "0": {
                    String content = (String)reqMap.get("content");
                    reqMap.put("content", CallG3PlusService.encryption(authPassword, content));
                    tlogReqHeader.setReqData(G3PlusHpartyCheckService.map2Json(reqMap).getBytes("UTF-8"));
                    break;
                }
                case "1": {
                    tlogReqHeader.setReqData(G3PlusHpartyCheckService.map2form(reqMap).getBytes("UTF-8"));
                    selfDefHeader.getSelfDefMap().put("Content-Type", "application/x-www-form-urlencoded");
                    break;
                }
                default: {
                    tlogReqHeader.setReqData(G3PlusHpartyCheckService.map2Json(reqMap).getBytes("UTF-8"));
                }
            }
            logger.debug("\u8c03\u7528\u843d\u5730\u62a5\u6587\u4e3a:" + new String(tlogReqHeader.getReqData(), "UTF-8"));
            msgContext.setTlogReqHeader(tlogReqHeader);
            msgContext.setIsAddToken(Boolean.TRUE);
            List lists = msgContext.getEsbAbility().getAbilityPluginBOList();
            for (AbilityPluginBO abilityPluginBO : lists) {
                if (!"g3PlusHPC".equals(abilityPluginBO.getPluginType())) continue;
                abilityPluginBO.setDealJudgeRsp(Boolean.TRUE);
            }
            msgContext.getEsbAbility().setAbilityPluginBOList(lists);
        }
        catch (AbilityException e) {
            logger.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            logger.error("G3PlusHpartyCheck\u63d2\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":G3PlusHpartyCheckService >>> G3PlusHpartyCheck\u63d2\u4ef6\u5f02\u5e38:"}) + e.getMessage());
        }
        logger.debug("\u6700\u7ec8\u843d\u5730\u8bf7\u6c42\u62a5\u6587\u4e3a: {}", (Object)msgContext);
    }

    public void doAfterService(MsgContext msgContext) {
        try {
            logger.info("G3PlusHPC : \u6267\u884c\u63d2\u4ef6\u89e3\u5bc6 --> AbilityId : {} AbilityName : {}", (Object)msgContext.getEsbAbility().getAbilityId(), (Object)msgContext.getEsbAbility().getAbilityName());
            String rsp = msgContext.getTlogRspHeader().getRspDataString();
            G3PlusReturnMsgReqBO g3PlusReturnMsgReqBO = (G3PlusReturnMsgReqBO)GsonUtil.fromJson((String)rsp, G3PlusReturnMsgReqBO.class);
            G3PlusReturnMsgRspBO g3PlusReturnMsgRspBO = new G3PlusReturnMsgRspBO();
            g3PlusReturnMsgRspBO.setReturnCode(g3PlusReturnMsgReqBO.getReturnCode());
            String regionCode = msgContext.getSelfDefHeader().getRegionBO().getRegionCode();
            String key = this.constantBaseVersion.getATP() + "g3PlusHPC-" + this.nodeInfoConfig.getClusterId() + "-" + regionCode + "-token";
            AbilityRedisTokenDataBo abilityRedisTokenDataBo = (AbilityRedisTokenDataBo)GsonUtil.fromJson((String)this.cacheClient.get(key).toString(), AbilityRedisTokenDataBo.class);
            String authPassword = abilityRedisTokenDataBo.getClientSecret();
            g3PlusReturnMsgRspBO.setMessage(CallG3PlusService.decryptMsg(g3PlusReturnMsgReqBO.getMessage()));
            if (g3PlusReturnMsgReqBO.getContent() != null) {
                String content = CallG3PlusService.decrypt(authPassword, g3PlusReturnMsgReqBO.getContent());
                g3PlusReturnMsgRspBO.setContent((JsonObject)GsonUtil.fromJson((String)content, JsonObject.class));
            }
            rsp = GsonUtil.toJson((Object)g3PlusReturnMsgRspBO);
            msgContext.getTlogRspHeader().setRspDataString(rsp);
        }
        catch (Exception e) {
            logger.error("G3PlusHPC : \u6267\u884c\u63d2\u4ef6\u89e3\u5bc6\u5f02\u5e38\uff01");
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static String map2Json(Map map) {
        return GsonUtil.toJson((Object)map);
    }

    public static String map2form(Map map) {
        StringBuffer s = new StringBuffer(16);
        map.forEach((k, v) -> {
            if (v instanceof Map) {
                s.append(k).append("=").append(JSONObject.fromObject((Object)v)).append("&");
            } else if (v instanceof List) {
                s.append(k).append("=").append(JSONArray.fromObject((Object)v)).append("&");
            } else {
                s.append(k).append("=").append(v).append("&");
            }
        });
        return s.toString().substring(0, s.length() - 1);
    }

    private Map json2Map(String json) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        Map map = (Map)objectMapper.readValue(json, Map.class);
        return map;
    }
}

