/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.api.AppApi;
import com.ohaotian.abilitycommon.config.nodedata.NodeInfoConfig;
import com.ohaotian.abilitycommon.model.bo.AppSecretBO;
import com.ohaotian.abilitycommon.util.GsonUtil;
import com.ohaotian.abilitycommon.util.MD5Util;
import com.ohaotian.plugin.bo.GSCheckPluginAccessTokenReq;
import com.ohaotian.plugin.bo.GSCheckPluginResultData;
import com.ohaotian.plugin.service.GSCheckPluginAccessTokenService;
import com.ohaotian.plugin.util.GSCheckPluginKeyUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.UUID;
import javax.annotation.Resource;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Service
public class GSCheckPluginAccessTokenServiceImpl
implements GSCheckPluginAccessTokenService {
    @Resource
    private ReactiveRedisTemplate<String, String> reactiveRedisTemplate;
    @Resource
    private NodeInfoConfig nodeInfoConfig;
    @Resource
    private AppApi appApi;

    @Override
    public Mono<GSCheckPluginResultData> accessToken(GSCheckPluginAccessTokenReq GSCheckPluginAccessTokenReq2) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        AppSecretBO appSecretBO = this.appApi.selectByAppCodeandClusterId(GSCheckPluginAccessTokenReq2.getAppKey(), this.nodeInfoConfig.getClusterId());
        if (appSecretBO == null) {
            return Mono.just((Object)GSCheckPluginResultData.error("99", "\u5e94\u7528\u4e0d\u5408\u6cd5"));
        }
        String appSecret = appSecretBO.getAppSecret();
        String appSecret_md5 = MD5Util.md5((String)appSecret);
        if (!appSecret_md5.equals(GSCheckPluginAccessTokenReq2.getAppSecret())) {
            return Mono.just((Object)GSCheckPluginResultData.error("99", "\u5e94\u7528\u4e0d\u5408\u6cd5"));
        }
        String token_new = UUID.randomUUID().toString().replaceAll("-", "");
        String key_new = GSCheckPluginKeyUtil.getTokenKey(token_new, this.nodeInfoConfig.getClusterId(), GSCheckPluginAccessTokenReq2.getSupplierCode());
        String value = GsonUtil.toJson((Object)appSecretBO);
        return this.reactiveRedisTemplate.opsForValue().set((Object)key_new, (Object)value, Duration.ofHours(24L)).flatMap(b -> {
            if (b.booleanValue()) {
                StringBuilder sb = new StringBuilder("gs_check_plugin_redis_token_key_");
                sb.append(GSCheckPluginAccessTokenReq2.getAppKey());
                sb.append('_');
                sb.append(GSCheckPluginAccessTokenReq2.getSupplierCode());
                String tokenKey = sb.toString();
                this.reactiveRedisTemplate.opsForValue().get((Object)tokenKey).subscribe(s -> {
                    if (!StringUtils.isEmpty((Object)s)) {
                        this.reactiveRedisTemplate.delete((Object[])new String[]{s}).subscribe();
                    }
                });
                return this.reactiveRedisTemplate.opsForValue().set((Object)tokenKey, (Object)key_new, Duration.ofHours(25L)).flatMap(b1 -> {
                    if (b1.booleanValue()) {
                        return Mono.just((Object)GSCheckPluginResultData.success(token_new));
                    }
                    return Mono.just((Object)GSCheckPluginResultData.error("07", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
                });
            }
            return Mono.just((Object)GSCheckPluginResultData.error("07", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
        }).onErrorResume(e -> {
            System.out.println(e.getMessage());
            return Mono.just((Object)GSCheckPluginResultData.error("07", "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01"));
        });
    }
}

