/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.service;

import com.ohaotian.abilitycommon.exception.AbilityException;
import com.ohaotian.abilitycommon.model.bo.CodeMsg;
import com.ohaotian.abilitycommon.model.bo.system.MsgContext;
import com.ohaotian.abilitycommon.plugin.PluginB;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DemoPluginService
implements PluginB {
    private static final Logger log = LogManager.getLogger(DemoPluginService.class);
    private static final String PLUGIN_TYPE = "demo";

    public void doService(MsgContext msgContext) throws AbilityException {
        try {
            List abilityPluginBOList = msgContext.getEsbAbility().getAbilityPluginBOList().stream().filter(bo -> PLUGIN_TYPE.equalsIgnoreCase(bo.getPluginType())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(abilityPluginBOList)) {
                log.debug("\u63d2\u4ef6-\u672a\u8ba2\u8d2d");
                return;
            }
            log.debug("\u5904\u7406\u63d2\u4ef6\u4e1a\u52a1\u903b\u8f91\u5f00\u59cb");
            log.debug("\u5904\u7406\u63d2\u4ef6\u4e1a\u52a1\u903b\u8f91\u7ed3\u675f");
        }
        catch (AbilityException e) {
            log.error(e.codeMsg.getRspDesc());
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new AbilityException(CodeMsg.E_PLUGIN_ERROR.fillArgs(new Object[]{":%s >>> " + e.getMessage()}).fillArgs(new Object[]{this.getClass().getSimpleName()}), (Throwable)e);
        }
    }
}

