/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.datasource;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class PluginDataSourceConfig {
    @Bean(name={"pluginDataSource"})
    @ConfigurationProperties(prefix="plugin.datasource")
    public DataSource pluginDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"pluginSqlSessionFactory"})
    public SqlSessionFactory pluginSqlSessionFactory(@Qualifier(value="pluginDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/plugin/*.xml"));
        return bean.getObject();
    }

    @Bean(name={"pluginTransactionManager"})
    public DataSourceTransactionManager pluginTransactionManager(@Qualifier(value="pluginDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"pluginSqlSessionTemplate"})
    public SqlSessionTemplate pluginSqlSessionTemplate(@Qualifier(value="pluginSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

