/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.datasource;

import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class WebDataSourceConfig {
    @Bean(name={"webDataSource"})
    @ConfigurationProperties(prefix="web.datasource")
    @Primary
    public DataSource testDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"webSqlSessionFactory"})
    @Primary
    public SqlSessionFactory testSqlSessionFactory(@Qualifier(value="webDataSource") DataSource dataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:mapper/web/*.xml"));
        return bean.getObject();
    }

    @Bean(name={"webTransactionManager"})
    @Primary
    public DataSourceTransactionManager testTransactionManager(@Qualifier(value="webDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean(name={"webSqlSessionTemplate"})
    @Primary
    public SqlSessionTemplate webSqlSessionTemplate(@Qualifier(value="webSqlSessionFactory") SqlSessionFactory sqlSessionFactory) throws Exception {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}

