/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.abilityweb.config.esbability;

import com.ohaotian.abilitycommon.model.bo.system.EsbAbility;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EsbAbilityMap {
    private static Map<String, EsbAbility> ability = new ConcurrentHashMap<String, EsbAbility>();

    public static void pushAbility(EsbAbility esbAbility) {
        ability.put(EsbAbilityMap.getKey(esbAbility), esbAbility);
    }

    public static void pushAbility(List<EsbAbility> esbAbilities) {
        for (EsbAbility esbAbility : esbAbilities) {
            ability.put(EsbAbilityMap.getKey(esbAbility), esbAbility);
        }
    }

    public static EsbAbility getAbility(String key) {
        return ability.get(key);
    }

    public static EsbAbility getAbility(String englishName, String version) {
        String key = version.toUpperCase().startsWith("V") ? englishName + "_" + version.substring(1) : englishName + "_" + version;
        return ability.get(key);
    }

    public static EsbAbility deleteAbility(String englishName, String version) {
        String key = version.toUpperCase().startsWith("V") ? englishName + "_" + version.substring(1) : englishName + "_" + version;
        return ability.remove(key);
    }

    private static String getKey(EsbAbility esbAbility) {
        if (esbAbility.getAbilityVersion().toUpperCase().startsWith("V")) {
            return esbAbility.getAbilityEname() + "_" + esbAbility.getAbilityVersion().substring(1);
        }
        return esbAbility.getAbilityEname() + "_" + esbAbility.getAbilityVersion();
    }

    public static void removeAll() {
        ability.clear();
    }
}

